/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.GuiColor;
import cofh.lib.util.helpers.MathHelper;
import java.util.Random;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.util.math.MOMathHelper;
import org.lwjgl.opengl.GL11;

public class ElementScanProgress
extends MOElementBase {
    Random random = new Random();
    int seed = 0;
    float progress;
    float[] values;
    private static float NoiseSize = 0.1f;

    public ElementScanProgress(GuiBase gui, int posX, int posY) {
        super(gui, posX, posY);
        this.setTexture("mo:textures/gui/elements/screen.png", 117, 47);
        this.values = new float[26];
    }

    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.posX, (float)this.posY, (float)0.0f);
        this.gui.bindTexture(this.texture);
        this.drawTexturedModalRect(0, 0, 0, 0, 117, 47);
        GuiColor color = new GuiColor(191, 228, 230);
        this.random.setSeed(this.seed);
        int progress = MathHelper.floor((double)(this.progress * 26.0f));
        int marginsTop = 8;
        int marginsLeft = 7;
        int maxHeight = 32;
        for (int i = 0; i < 26; ++i) {
            float newValue = 0.0f;
            if (i < progress) {
                double noiseValue = (MOMathHelper.noise(0.0, 0.05f * (float)i, Math.pow(this.seed * 100, 2.0)) + 1.0) / 2.0;
                double contrastFactor = 2.0;
                noiseValue = contrastFactor * (noiseValue - 0.5) + 0.5;
                noiseValue = Math.pow(Math.min(noiseValue, 1.0), 2.0);
                noiseValue = noiseValue * 0.8 + this.random.nextDouble() * 0.2;
                newValue = (float)noiseValue;
                int height = MathHelper.round((double)(this.values[i] * (float)maxHeight));
                int x1 = marginsLeft + i * 4;
                int y1 = maxHeight + marginsTop;
                int x2 = x1 + 2;
                int y2 = maxHeight - height + marginsTop;
                this.gui.drawSizedRect(x1, y1, x2, y2, color.getColor());
                this.gui.drawSizedRect(x1, y2 - 1, x2, y2 - 2, color.getColor());
            } else {
                newValue = 0.0f;
            }
            this.values[i] = MOMathHelper.Lerp(this.values[i], newValue, 0.05f);
        }
        GL11.glPopMatrix();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public void drawForeground(int mouseX, int mouseY) {
    }
}

