/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.util.RenderUtils;
import matteroverdrive.util.math.MOMathHelper;

public class ElementGrid
extends ElementBaseGroup {
    private int maxWidth;
    float scrollYSmooth = 0.0f;
    int scrollX = 0;
    int scrollY = 0;
    int scrollSpeed = 10;
    int marginTop = 0;
    int marginLeft = 0;

    public ElementGrid(GuiBase guiBase, int x, int y, int width, int height, int maxWidth) {
        super(guiBase, x, y, width, height);
        this.maxWidth = maxWidth;
    }

    @Override
    public void update(int mouseX, int mouseY) {
    }

    private void manageDrag(int maxHeight) {
        this.scrollY = Math.max(this.scrollY, -maxHeight);
        this.scrollYSmooth = MOMathHelper.Lerp(this.scrollYSmooth, this.scrollY, 0.1f);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        int widthCount = this.marginLeft;
        int height = this.marginTop;
        int maxTempHeigh = 0;
        for (ElementBase element : this.elements) {
            if (element != null && this.shouldBeDisplayed(element)) {
                if (widthCount > this.maxWidth - element.getWidth()) {
                    height += maxTempHeigh;
                    widthCount = this.marginLeft;
                    maxTempHeigh = 0;
                }
                if (MathHelper.round((double)((float)height + this.scrollYSmooth)) < this.sizeY || maxTempHeigh == 0 && MathHelper.round((double)((float)height + this.scrollYSmooth)) > -maxTempHeigh) {
                    element.setPosition(widthCount, MathHelper.round((double)((float)height + this.scrollYSmooth)));
                    element.setVisible(true);
                } else {
                    element.setVisible(false);
                }
                maxTempHeigh = Math.max(maxTempHeigh, element.getHeight() + 2);
                widthCount += element.getWidth() + 3;
                continue;
            }
            element.setVisible(false);
        }
        this.manageDrag(height);
        RenderUtils.beginStencil();
        this.drawStencil(this.posX, this.posY, this.posX + this.sizeX, this.posY + this.sizeY, 1);
        super.drawBackground(mouseX, mouseY, gameTicks);
        RenderUtils.endStencil();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        RenderUtils.beginStencil();
        this.drawStencil(this.posX, this.posY, this.sizeX + this.posX, this.sizeY + this.posY, 1);
        super.drawForeground(mouseX, mouseY);
        RenderUtils.endStencil();
    }

    @Override
    public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
        if (StringHelper.isControlKeyDown()) {
            if (movement <= 0 && movement < 0) {
                // empty if block
            }
        } else if (movement > 0) {
            this.scrollUp();
        } else if (movement < 0) {
            this.scrollDown();
        }
        return true;
    }

    public void scrollDown() {
        this.scrollY -= this.scrollSpeed;
        this.onScrollV(this.scrollY);
    }

    public void scrollUp() {
        if (this.scrollY < 0) {
            this.scrollY = Math.min(this.scrollY + this.scrollSpeed, 0);
            this.onScrollV(this.scrollY);
        }
    }

    protected void onScrollV(int newStartIndex) {
        this.scrollY = newStartIndex;
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, int texWidth, int texHeight) {
        this.gui.drawSizedTexturedModalRect(x, y, u, v, width, height, (float)texWidth, (float)texHeight);
    }

    public void setMargins(int left, int right, int top, int bottom) {
        this.marginTop = top;
        this.marginLeft = left;
    }

    public boolean shouldBeDisplayed(ElementBase element) {
        return true;
    }
}

