/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.GuiColor;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.util.helpers.MathHelper;
import java.util.ArrayList;
import java.util.List;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.container.IButtonHandler;
import matteroverdrive.container.MOBaseContainer;
import matteroverdrive.container.slot.SlotPlayerInventory;
import matteroverdrive.data.ScaleTexture;
import matteroverdrive.gui.GuiElementList;
import matteroverdrive.gui.element.CloseButton;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementInventorySlot;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.gui.element.MOElementButton;
import matteroverdrive.gui.element.MOElementIconButton;
import matteroverdrive.gui.element.SidePannel;
import matteroverdrive.gui.events.IListHandler;
import matteroverdrive.gui.events.ITextHandler;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class MOGuiBase
extends GuiBase
implements IButtonHandler,
ITextHandler,
IListHandler,
GuiElementList {
    int currentPage = -1;
    protected SidePannel sidePannel;
    protected CloseButton closeButton;
    ScaleTexture background = new ScaleTexture(new ResourceLocation("mo:textures/gui/elements/base_gui_hotbar.png"), 92, 77);
    protected List<ElementBaseGroup> pages;
    protected List<MOElementButton> pageButtons;
    int texW;
    int texH;

    public MOGuiBase(MOBaseContainer container) {
        this(container, 225, 186);
    }

    public MOGuiBase(MOBaseContainer container, int width, int height) {
        super((Container)container);
        this.background.setOffsets(57, 34, 42, 34);
        this.field_146999_f = width;
        this.field_147000_g = height;
        this.sidePannel = new SidePannel(this, this.field_146999_f - 12, 33, this.field_147000_g - 34);
        this.closeButton = new CloseButton(this, this, this.field_146999_f - 17, 6, "close");
        this.drawTitle = false;
        this.drawInventory = false;
        this.texW = 224;
        this.texH = 176;
        this.field_146294_l = width;
        this.field_146295_m = height;
        this.pages = new ArrayList<ElementBaseGroup>(3);
        this.pageButtons = new ArrayList<MOElementButton>(3);
        this.registerPages(container);
    }

    protected void func_146976_a(float partialTick, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.background.Render(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        this.mouseX = x - this.field_147003_i;
        this.mouseY = y - this.field_147009_r;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        this.drawElements(partialTick, false);
        this.drawTabs(partialTick, false);
        GL11.glPopMatrix();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        for (ElementBaseGroup page : this.pages) {
            page.init();
            this.addElement(page);
        }
        this.addElement(this.sidePannel);
        this.sidePannel.init();
        this.addElement((ElementBase)this.closeButton);
        for (MOElementButton button : this.pageButtons) {
            this.sidePannel.addElement((ElementBase)button);
        }
        this.setPage(this.currentPage);
    }

    public void registerPages(MOBaseContainer container) {
    }

    @Override
    public void handleElementButtonClick(ElementBase element, String buttonName, int mouseButton) {
        for (int i = 0; i < this.pageButtons.size(); ++i) {
            if (i >= this.pages.size() || !((Object)((Object)this.pageButtons.get(i))).equals(element)) continue;
            this.setPage(i);
        }
    }

    public void setPage(int page) {
        if (this.currentPage != (page = MathHelper.clampI((int)page, (int)0, (int)(this.pages.size() - 1)))) {
            this.onPageChange(page);
        }
        this.currentPage = page;
        for (int i = 0; i < this.pages.size(); ++i) {
            this.pages.get(i).setVisible(i == this.currentPage);
            if (i >= this.pageButtons.size()) continue;
            this.pageButtons.get(i).setEnabled(i != this.currentPage);
        }
    }

    public void onPageChange(int newPage) {
    }

    protected ElementBase getElementAtPosition(int mX, int mY) {
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase element = (ElementBase)this.elements.get(i);
            if (!element.isVisible() || !element.intersectsWith(mX, mY)) continue;
            return element;
        }
        return null;
    }

    public void setTooltip(List<String> tooltip) {
        this.tooltip = tooltip;
    }

    public void addToTooltip(String string) {
        this.tooltip.add(string);
    }

    public List<String> getTooltips() {
        return this.tooltip;
    }

    public void handleListChange(String listName, int mouseButton, int element) {
    }

    protected void updateElementInformation() {
        int i;
        for (i = 0; i < this.pageButtons.size(); ++i) {
            this.pageButtons.get(i).setPosition(6, 8 + (this.pageButtons.get(i).getHeight() + 2) * i);
        }
        i = this.elements.size();
        while (i-- > 0) {
            if (!(this.elements.get(i) instanceof MOElementBase)) continue;
            ((MOElementBase)((Object)this.elements.get(i))).updateInfo();
        }
    }

    protected void AddMainPlayerSlots(Container container, GuiElementList elements) {
        this.AddPlayerSlots(45, this.field_147000_g - 106, container, elements, true, false, "small", null);
    }

    protected void AddHotbarPlayerSlots(Container container, GuiElementList elements) {
        this.AddPlayerSlots(45, this.field_147000_g - 27, container, elements, false, true, "small", null);
    }

    protected void AddMainPlayerSlots(Container container, GuiElementList elements, String type, GuiColor color, int x, int y) {
        this.AddPlayerSlots(x, y, container, elements, true, false, type, color);
    }

    protected void AddHotbarPlayerSlots(Container container, GuiElementList elements, String type, GuiColor color, int x, int y) {
        this.AddPlayerSlots(x, y, container, elements, false, true, type, color);
    }

    protected void AddPlayerSlots(int x, int y, Container container, GuiElementList elements, boolean main, boolean hotbar, String type, GuiColor color) {
        for (int i = 0; i < container.field_75151_b.size(); ++i) {
            ElementInventorySlot inventorySlot;
            if (!(container.field_75151_b.get(i) instanceof SlotPlayerInventory)) continue;
            SlotPlayerInventory slot = (SlotPlayerInventory)((Object)container.field_75151_b.get(i));
            if (main && !slot.isHotbar()) {
                inventorySlot = new ElementInventorySlot((GuiBase)this, slot, 18, 18, type);
                inventorySlot.setColor(color);
                inventorySlot.setPosition(x + 18 * (slot.getSlotIndex() % 9), y + 18 * (slot.getSlotIndex() / 9));
                elements.addElement(inventorySlot);
                continue;
            }
            if (!hotbar || !slot.isHotbar()) continue;
            inventorySlot = new ElementInventorySlot((GuiBase)this, slot, 18, 18, type);
            inventorySlot.setColor(color);
            inventorySlot.setPosition(x + 18 * (slot.getSlotIndex() % 9), y);
            elements.addElement(inventorySlot);
        }
    }

    public MOElementIconButton AddPage(ElementBaseGroup page, HoloIcon icon, String tooltip) {
        this.pages.add(page);
        MOElementIconButton button = new MOElementIconButton(this, this, 0, 0, page.getName(), 0, 0, 24, 0, 24, 0, 24, 24, "", icon);
        button.setTexture("mo:textures/gui/elements/page_button.png", 48, 24);
        button.setToolTip(tooltip);
        this.pageButtons.add(button);
        return button;
    }

    public MOBaseContainer getContainer() {
        return (MOBaseContainer)this.field_147002_h;
    }
}

