/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import cofh.lib.gui.GuiBase;
import matteroverdrive.Reference;
import matteroverdrive.api.weapon.IWeapon;
import matteroverdrive.container.ContainerWeaponStation;
import matteroverdrive.container.slot.MOSlot;
import matteroverdrive.data.ScaleTexture;
import matteroverdrive.gui.MOGuiMachine;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementInventorySlot;
import matteroverdrive.gui.element.ElementModelPreview;
import matteroverdrive.gui.element.ElementSlot;
import matteroverdrive.tile.TileEntityWeaponStation;
import matteroverdrive.util.MatterHelper;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class GuiWeaponStation
extends MOGuiMachine<TileEntityWeaponStation> {
    public static final ScaleTexture BG = new ScaleTexture(new ResourceLocation("mo:textures/gui/weapon_station.png"), 255, 141).setOffsets(213, 34, 42, 94);
    ElementModelPreview weaponPreview;
    ElementSlot[] module_slots = new ElementSlot[5];
    String[] module_slots_info = new String[]{"battery", "color", "barrel", "sights", "other"};

    public GuiWeaponStation(InventoryPlayer inventoryPlayer, TileEntityWeaponStation machine) {
        super(new ContainerWeaponStation(inventoryPlayer, machine), machine, 255, 237);
        this.texW = 255;
        this.texH = 237;
        this.background = BG;
        this.weaponPreview = new ElementModelPreview(this, 130, 90, this.field_146999_f, this.field_147000_g);
        for (int i = 0; i < this.module_slots.length; ++i) {
            this.module_slots[i] = new ElementInventorySlot((GuiBase)this, (MOSlot)this.field_147002_h.func_75139_a(i + 1), 20, 20, "holo", machine.getInventoryContainer().getSlot(i).getHoloIcon());
            this.module_slots[i].setColor(Reference.COLOR_MATTER.getIntR(), Reference.COLOR_MATTER.getIntG(), Reference.COLOR_MATTER.getIntB(), 78);
            this.module_slots[i].setInfo("module." + this.module_slots_info[i] + ".name");
        }
        this.sidePannel.setPosition(243, 33);
        this.closeButton.setPosition(237, 6);
        this.indicator.setPosition(6, 220);
        this.slotsList.getMainSlot().setType("big_main_dark");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ((ElementBaseGroup)this.pages.get(0)).addElement(this.weaponPreview);
        for (int i = 0; i < this.module_slots.length; ++i) {
            ((ElementBaseGroup)this.pages.get(0)).addElement(this.module_slots[i]);
        }
        this.AddMainPlayerSlots(this.field_147002_h, this);
        this.AddHotbarPlayerSlots(this.field_147002_h, this);
    }

    @Override
    protected void updateElementInformation() {
        super.updateElementInformation();
        ItemStack item = ((TileEntityWeaponStation)this.machine).func_70301_a(((TileEntityWeaponStation)this.machine).INPUT_SLOT);
        this.weaponPreview.setItemStack(item);
        if (MatterHelper.isWeapon(item)) {
            IWeapon weapon = (IWeapon)item.func_77973_b();
            IItemRenderer renderer = MinecraftForgeClient.getItemRenderer((ItemStack)item, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.INVENTORY);
            this.weaponPreview.setRenderer(renderer);
            for (int i = 0; i < this.module_slots.length; ++i) {
                if (weapon.supportsModule(i, item)) {
                    Vector2f pos = weapon.getSlotPosition(i, item);
                    this.module_slots[i].setColor(Reference.COLOR_MATTER.getIntR(), Reference.COLOR_MATTER.getIntG(), Reference.COLOR_MATTER.getIntB(), 78);
                    this.module_slots[i].setPosition((int)pos.x, (int)pos.y);
                    continue;
                }
                this.module_slots[i].setColor(30, 30, 30, 78);
                this.ResetModuleSlotPos(i);
            }
        } else {
            for (int i = 0; i < this.module_slots.length; ++i) {
                this.module_slots[i].setColor(30, 30, 30, 78);
                this.ResetModuleSlotPos(i);
            }
            this.weaponPreview.setRenderer(null);
        }
    }

    private void ResetModuleSlotPos(int i) {
        if (i < this.module_slots.length) {
            this.module_slots[i].setPosition(216, 121 + i * 22);
        }
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        ItemStack item = ((TileEntityWeaponStation)this.machine).func_70301_a(((TileEntityWeaponStation)this.machine).INPUT_SLOT);
        if (MatterHelper.isWeapon(item) && ((ElementBaseGroup)this.pages.get(0)).isVisible()) {
            GL11.glDisable((int)3553);
            GL11.glPushMatrix();
            GL11.glLineWidth((float)1.0f);
            GL11.glColor4f((float)Reference.COLOR_MATTER.getFloatR(), (float)Reference.COLOR_MATTER.getFloatG(), (float)Reference.COLOR_MATTER.getFloatB(), (float)1.0f);
            IWeapon weapon = (IWeapon)item.func_77973_b();
            for (int i = 0; i < this.module_slots.length; ++i) {
                if (!weapon.supportsModule(i, item)) continue;
                GL11.glBegin((int)1);
                Vector2f slotPos = weapon.getSlotPosition(i, item);
                Vector2f modulePos = weapon.getModuleScreenPosition(i, item);
                slotPos = this.getClosestOnSlot(slotPos, modulePos);
                GL11.glVertex3f((float)slotPos.x, (float)slotPos.y, (float)0.0f);
                GL11.glVertex3f((float)modulePos.x, (float)modulePos.y, (float)0.0f);
                GL11.glEnd();
            }
            GL11.glPopMatrix();
            GL11.glEnable((int)3553);
        }
    }

    Vector2f getClosestOnSlot(Vector2f slotPos, Vector2f modulePos) {
        int slotWidth = 18;
        int slotHeight = 18;
        Vector2f center = new Vector2f(slotPos.x + (float)(slotWidth / 2), slotPos.y + (float)(slotHeight / 2));
        Vector2f intersect = null;
        intersect = MOMathHelper.Intersects(slotPos, new Vector2f(slotPos.x + (float)slotWidth, slotPos.y), modulePos, center);
        if (intersect != null) {
            return intersect;
        }
        intersect = MOMathHelper.Intersects(slotPos, new Vector2f(slotPos.x, slotPos.y + (float)slotHeight), modulePos, center);
        if (intersect != null) {
            return intersect;
        }
        intersect = MOMathHelper.Intersects(new Vector2f(slotPos.x + (float)slotWidth, slotPos.y + (float)slotHeight), new Vector2f(slotPos.x, slotPos.y + (float)slotHeight), modulePos, center);
        if (intersect != null) {
            return intersect;
        }
        intersect = MOMathHelper.Intersects(new Vector2f(slotPos.x + (float)slotWidth, slotPos.y + (float)slotHeight), new Vector2f(slotPos.x + (float)slotWidth, slotPos.y), modulePos, center);
        if (intersect != null) {
            return intersect;
        }
        return center;
    }
}

