/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import cofh.lib.gui.element.ElementBase;
import matteroverdrive.container.ContainerFactory;
import matteroverdrive.gui.MOGuiMachine;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementIntegerField;
import matteroverdrive.gui.element.ElementMatterStored;
import matteroverdrive.gui.element.ElementTransportList;
import matteroverdrive.gui.element.MOElementButton;
import matteroverdrive.gui.element.MOElementButtonScaled;
import matteroverdrive.gui.element.MOElementEnergy;
import matteroverdrive.gui.element.MOElementTextField;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.machines.transporter.TileEntityMachineTransporter;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;

public class GuiTransporter
extends MOGuiMachine<TileEntityMachineTransporter> {
    MOElementEnergy energy;
    ElementMatterStored matterStored;
    ElementIntegerField xCoords;
    ElementIntegerField yCoords;
    ElementIntegerField zCoords;
    MOElementButtonScaled importButton;
    MOElementButtonScaled newLocationButton;
    MOElementButtonScaled resetButton;
    MOElementTextField name;
    ElementTransportList list;
    MOElementButtonScaled removeLocation;

    public GuiTransporter(InventoryPlayer inventoryPlayer, TileEntityMachineTransporter machine) {
        super(ContainerFactory.createMachineContainer(machine, inventoryPlayer), machine, 225, 220);
        this.energy = new MOElementEnergy(this, this.field_146999_f - 35, 50, machine.getEnergyStorage());
        this.matterStored = new ElementMatterStored(this, this.field_146999_f - 35, 100, machine.getMatterStorage());
        this.xCoords = new ElementIntegerField(this, this, 80, 50, 80, 16);
        this.xCoords.setName("XCoord");
        this.yCoords = new ElementIntegerField(this, this, 80, 68, 80, 16);
        this.yCoords.setName("YCoord");
        this.zCoords = new ElementIntegerField(this, this, 80, 86, 80, 16);
        this.zCoords.setName("ZCoord");
        this.list = new ElementTransportList(this, this, 45, 30, 140, 100, machine);
        this.list.setName("Locations");
        this.name = new MOElementTextField(this, this, 86, 32, 74, 16);
        this.name.setTextOffset(6, 4);
        this.name.setBackground(MOElementButton.HOVER_TEXTURE_DARK);
        this.name.setName("LocationName");
        this.importButton = new MOElementButtonScaled(this, this, 70, 109, "Import", 50, 18);
        this.importButton.setNormalTexture(MOElementButton.NORMAL_TEXTURE);
        this.importButton.setOverTexture(MOElementButton.HOVER_TEXTURE);
        this.importButton.setDisabledTexture(MOElementButton.HOVER_TEXTURE_DARK);
        this.importButton.setText(MOStringHelper.translateToLocal("gui.label.button.import"));
        this.resetButton = new MOElementButtonScaled(this, this, 122, 109, "Reset", 50, 18);
        this.resetButton.setNormalTexture(MOElementButton.NORMAL_TEXTURE);
        this.resetButton.setOverTexture(MOElementButton.HOVER_TEXTURE);
        this.resetButton.setText(MOStringHelper.translateToLocal("gui.label.button.reset"));
        this.newLocationButton = new MOElementButtonScaled(this, this, 115, this.field_147000_g - 55, "New", 40, 18);
        this.newLocationButton.setNormalTexture(MOElementButton.NORMAL_TEXTURE);
        this.newLocationButton.setOverTexture(MOElementButton.HOVER_TEXTURE);
        this.newLocationButton.setText(MOStringHelper.translateToLocal("gui.label.button.new"));
        this.removeLocation = new MOElementButtonScaled(this, this, 50, this.field_147000_g - 55, "Remove", 60, 18);
        this.removeLocation.setNormalTexture(MOElementButton.NORMAL_TEXTURE);
        this.removeLocation.setText(MOStringHelper.translateToLocal("gui.label.button.remove"));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ((ElementBaseGroup)this.pages.get(0)).addElement((ElementBase)this.energy);
        ((ElementBaseGroup)this.pages.get(0)).addElement(this.matterStored);
        ((ElementBaseGroup)this.pages.get(0)).addElement(this.list);
        ((ElementBaseGroup)this.pages.get(1)).addElement(this.xCoords);
        ((ElementBaseGroup)this.pages.get(1)).addElement(this.yCoords);
        ((ElementBaseGroup)this.pages.get(1)).addElement(this.zCoords);
        ((ElementBaseGroup)this.pages.get(1)).addElement((ElementBase)this.importButton);
        ((ElementBaseGroup)this.pages.get(1)).addElement((ElementBase)this.name);
        ((ElementBaseGroup)this.pages.get(1)).addElement((ElementBase)this.resetButton);
        ((ElementBaseGroup)this.pages.get(0)).addElement((ElementBase)this.removeLocation);
        ((ElementBaseGroup)this.pages.get(0)).addElement((ElementBase)this.newLocationButton);
        ((ElementBaseGroup)this.pages.get(1)).getElements().get(0).setPosition(60, 150);
        this.xCoords.init();
        this.yCoords.init();
        this.zCoords.init();
        this.updateInfo();
        this.AddHotbarPlayerSlots(this.field_147002_h, this);
    }

    private void updateInfo() {
        this.list.setSelectedIndex(((TileEntityMachineTransporter)this.machine).selectedLocation);
        this.name.setText(((TileEntityMachineTransporter)this.machine).getSelectedLocation().name);
        this.xCoords.setBounds(((TileEntityMachineTransporter)this.machine).field_145851_c - ((TileEntityMachineTransporter)this.machine).getTransportRange(), ((TileEntityMachineTransporter)this.machine).field_145851_c + ((TileEntityMachineTransporter)this.machine).getTransportRange());
        this.yCoords.setBounds(((TileEntityMachineTransporter)this.machine).field_145848_d - ((TileEntityMachineTransporter)this.machine).getTransportRange(), ((TileEntityMachineTransporter)this.machine).field_145848_d + ((TileEntityMachineTransporter)this.machine).getTransportRange());
        this.zCoords.setBounds(((TileEntityMachineTransporter)this.machine).field_145849_e - ((TileEntityMachineTransporter)this.machine).getTransportRange(), ((TileEntityMachineTransporter)this.machine).field_145849_e + ((TileEntityMachineTransporter)this.machine).getTransportRange());
        if (((TileEntityMachineTransporter)this.machine).getSelectedLocation() != null) {
            this.xCoords.setNumber(((TileEntityMachineTransporter)this.machine).getSelectedLocation().x);
            this.yCoords.setNumber(((TileEntityMachineTransporter)this.machine).getSelectedLocation().y);
            this.zCoords.setNumber(((TileEntityMachineTransporter)this.machine).getSelectedLocation().z);
        } else {
            this.xCoords.setNumber(0);
            this.yCoords.setNumber(0);
            this.zCoords.setNumber(0);
        }
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        if (((ElementBaseGroup)this.pages.get(1)).isVisible()) {
            this.getFontRenderer().func_78276_b("X:", this.xCoords.getPosX() - 10, this.xCoords.getPosY() + 4, 0xFFFFFF);
            this.getFontRenderer().func_78276_b(Integer.toString(this.xCoords.getNumber() - ((TileEntityMachineTransporter)this.machine).field_145851_c), this.xCoords.getPosX() + this.xCoords.getWidth() + 4, this.xCoords.getPosY() + 4, 0xFFFFFF);
            this.getFontRenderer().func_78276_b("Y:", this.yCoords.getPosX() - 10, this.yCoords.getPosY() + 4, 0xFFFFFF);
            this.getFontRenderer().func_78276_b(Integer.toString(this.yCoords.getNumber() - ((TileEntityMachineTransporter)this.machine).field_145848_d), this.yCoords.getPosX() + this.yCoords.getWidth() + 4, this.yCoords.getPosY() + 4, 0xFFFFFF);
            this.getFontRenderer().func_78276_b("Z:", this.zCoords.getPosX() - 10, this.zCoords.getPosY() + 4, 0xFFFFFF);
            this.getFontRenderer().func_78276_b(Integer.toString(this.zCoords.getNumber() - ((TileEntityMachineTransporter)this.machine).field_145849_e), this.zCoords.getPosX() + this.zCoords.getWidth() + 4, this.zCoords.getPosY() + 4, 0xFFFFFF);
        }
    }

    @Override
    public void handleElementButtonClick(ElementBase element, String buttonName, int mouseButton) {
        super.handleElementButtonClick(element, buttonName, mouseButton);
        if (buttonName == "Import") {
            ItemStack usb = ((TileEntityMachineTransporter)this.machine).func_70301_a(((TileEntityMachineTransporter)this.machine).usbSlotID);
            if (usb != null && MatterOverdriveItems.transportFlashDrive.hasTarget(usb)) {
                ((TileEntityMachineTransporter)this.machine).setSelectedLocation(MatterOverdriveItems.transportFlashDrive.getTargetX(usb), MatterOverdriveItems.transportFlashDrive.getTargetY(usb) + 1, MatterOverdriveItems.transportFlashDrive.getTargetZ(usb), this.name.getText());
                ((TileEntityMachineTransporter)this.machine).sendConfigsToServer(true);
                this.updateInfo();
            }
        } else if (buttonName == "New") {
            ((TileEntityMachineTransporter)this.machine).addNewLocation(((TileEntityMachineTransporter)this.machine).field_145851_c, ((TileEntityMachineTransporter)this.machine).field_145848_d, ((TileEntityMachineTransporter)this.machine).field_145849_e, this.name.getText());
            ((TileEntityMachineTransporter)this.machine).sendConfigsToServer(true);
            this.updateInfo();
            this.list.setSelectedIndex(this.list.getElementCount() - 1);
        } else if (buttonName == "Reset") {
            ((TileEntityMachineTransporter)this.machine).setSelectedLocation(((TileEntityMachineTransporter)this.machine).field_145851_c, ((TileEntityMachineTransporter)this.machine).field_145848_d, ((TileEntityMachineTransporter)this.machine).field_145849_e, ((TileEntityMachineTransporter)this.machine).getSelectedLocation().name);
            ((TileEntityMachineTransporter)this.machine).sendConfigsToServer(true);
            this.updateInfo();
        } else if (buttonName == "Remove") {
            ((TileEntityMachineTransporter)this.machine).removeLocation(this.list.getSelectedIndex());
            ((TileEntityMachineTransporter)this.machine).sendConfigsToServer(true);
            this.updateInfo();
        } else if (buttonName.equals("XCoord") || buttonName.equals("YCoord") || buttonName.equals("ZCoord")) {
            ((TileEntityMachineTransporter)this.machine).setSelectedLocation(this.xCoords.getNumber(), this.yCoords.getNumber(), this.zCoords.getNumber(), this.name.getText());
            ((TileEntityMachineTransporter)this.machine).sendConfigsToServer(true);
        }
    }

    @Override
    protected void updateElementInformation() {
        super.updateElementInformation();
        ItemStack usb = ((TileEntityMachineTransporter)this.machine).func_70301_a(((TileEntityMachineTransporter)this.machine).usbSlotID);
        if (usb != null) {
            int targetDestination = MatterOverdriveItems.transportFlashDrive.getTargetDistance(usb);
            int transportRange = ((TileEntityMachineTransporter)this.machine).getTransportRange();
            boolean hasTarget = MatterOverdriveItems.transportFlashDrive.hasTarget(usb);
            if (!hasTarget || targetDestination > transportRange) {
                this.importButton.setEnabled(false);
                this.importButton.setToolTip(MOStringHelper.translateToLocal("gui.label.button.import.too_far"));
            } else {
                this.importButton.setEnabled(true);
                this.importButton.setToolTip(null);
            }
        } else {
            this.importButton.setEnabled(false);
            this.importButton.setToolTip(null);
        }
    }

    @Override
    public void onPageChange(int newPage) {
        if (newPage == 1) {
            this.updateInfo();
        }
    }

    @Override
    public void ListSelectionChange(String name, int selected) {
        if (name == "Locations") {
            this.updateInfo();
            ((TileEntityMachineTransporter)this.machine).selectedLocation = selected;
            ((TileEntityMachineTransporter)this.machine).sendConfigsToServer(true);
            this.list.setSelectedIndex(((TileEntityMachineTransporter)this.machine).selectedLocation);
        }
    }

    @Override
    public void textChanged(String elementName, String text, boolean typed) {
        if (typed && elementName.equals("LocationName")) {
            ((TileEntityMachineTransporter)this.machine).setSelectedLocation(this.xCoords.getNumber(), this.yCoords.getNumber(), this.zCoords.getNumber(), this.name.getText());
            ((TileEntityMachineTransporter)this.machine).sendConfigsToServer(true);
        }
    }
}

