/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import cofh.lib.gui.GuiColor;
import java.util.Collection;
import java.util.List;
import matteroverdrive.Reference;
import matteroverdrive.api.renderer.ISpaceBodyHoloRenderer;
import matteroverdrive.container.ContainerStarMap;
import matteroverdrive.container.MOBaseContainer;
import matteroverdrive.data.ScaleTexture;
import matteroverdrive.gui.MOGuiMachine;
import matteroverdrive.gui.element.MOElementButton;
import matteroverdrive.gui.pages.PageGalaxy;
import matteroverdrive.gui.pages.PagePlanetMenu;
import matteroverdrive.gui.pages.PagePlanetStats;
import matteroverdrive.gui.pages.PageQuadrant;
import matteroverdrive.gui.pages.PageStar;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.starmap.data.TravelEvent;
import matteroverdrive.tile.TileEntityMachineStarMap;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

public class GuiStarMap
extends MOGuiMachine<TileEntityMachineStarMap> {
    public static ScaleTexture BG = new ScaleTexture(new ResourceLocation("mo:textures/gui/star_map.png"), 255, 141).setOffsets(213, 34, 42, 94);
    Minecraft field_146297_k = Minecraft.func_71410_x();
    IModelCustom sphere = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("mo:models/block/sphere.obj"));
    PagePlanetMenu planetPage;
    PageQuadrant pageQuadrant;
    PageStar pageStar;
    PagePlanetStats pagePlanetStats;

    public GuiStarMap(InventoryPlayer inventoryPlayer, TileEntityMachineStarMap machine) {
        super(new ContainerStarMap(inventoryPlayer, machine), machine, 480, 360);
        this.background = BG;
        this.texW = 255;
        this.texH = 237;
        this.slotsList.getElements().clear();
        this.sidePannel.BACKGROUND_TEXTURE.setLocation(new ResourceLocation("mo:textures/gui/elements/right_side_bar_panel_bg_holo.png"));
        this.sidePannel.setOpenable(false);
        this.sidePannel.setOpen(true);
    }

    @Override
    public void registerPages(MOBaseContainer container, TileEntityMachineStarMap starMap) {
        PageGalaxy galaxyPage = new PageGalaxy(this, 0, 0, this.field_146294_l, this.field_146295_m, starMap);
        galaxyPage.setName("Galaxy");
        this.AddPage(galaxyPage, ClientProxy.holoIcons.getIcon("page_icon_galaxy"), MOStringHelper.translateToLocal("gui.tooltip.page.galaxy")).setIconColor(Reference.COLOR_MATTER);
        this.pageQuadrant = new PageQuadrant(this, 0, 0, this.field_146294_l, this.field_146295_m, starMap);
        this.pageQuadrant.setName("Quadrant");
        this.AddPage(this.pageQuadrant, ClientProxy.holoIcons.getIcon("page_icon_quadrant"), MOStringHelper.translateToLocal("gui.tooltip.page.quadrant")).setIconColor(Reference.COLOR_MATTER);
        this.pageStar = new PageStar(this, 0, 0, this.field_146294_l, this.field_146295_m, starMap);
        this.pageStar.setName("Star");
        this.AddPage(this.pageStar, ClientProxy.holoIcons.getIcon("page_icon_star"), MOStringHelper.translateToLocal("gui.tooltip.page.star")).setIconColor(Reference.COLOR_MATTER);
        this.planetPage = new PagePlanetMenu(this, 0, 0, this.field_146294_l, this.field_146295_m, (ContainerStarMap)container, starMap);
        this.planetPage.setName("Planet");
        this.AddPage(this.planetPage, ClientProxy.holoIcons.getIcon("page_icon_planet"), MOStringHelper.translateToLocal("gui.tooltip.page.planet")).setIconColor(Reference.COLOR_MATTER);
        this.pagePlanetStats = new PagePlanetStats(this, 0, 0, this.field_146294_l, this.field_146295_m, starMap);
        this.pagePlanetStats.setName("Planet Stats");
        this.AddPage(this.pagePlanetStats, ClientProxy.holoIcons.getIcon("icon_stats"), MOStringHelper.translateToLocal("gui.tooltip.page.planet_stats")).setIconColor(Reference.COLOR_MATTER);
        this.setPage(((TileEntityMachineStarMap)this.machine).getZoomLevel());
    }

    @Override
    protected void func_146976_a(float partialTick, int x, int y) {
        super.func_146976_a(partialTick, x, y);
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.field_147003_i, (double)this.field_147009_r, (double)0.0);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)1);
        Collection<ISpaceBodyHoloRenderer> renderers = ClientProxy.renderHandler.getStarmapRenderRegistry().getStarmapRendererCollection(((TileEntityMachineStarMap)this.machine).getActiveSpaceBody().getClass());
        if (renderers != null) {
            for (ISpaceBodyHoloRenderer renderer : renderers) {
                if (!renderer.displayOnZoom(((TileEntityMachineStarMap)this.machine).getZoomLevel(), ((TileEntityMachineStarMap)this.machine).getActiveSpaceBody())) continue;
                GL11.glPushMatrix();
                GL11.glTranslated((double)(this.field_146999_f / 2), (double)this.field_147000_g, (double)0.0);
                if (((TileEntityMachineStarMap)this.machine).getActiveSpaceBody() != null) {
                    renderer.renderGUIInfo(GalaxyClient.getInstance().getTheGalaxy(), ((TileEntityMachineStarMap)this.machine).getActiveSpaceBody(), (TileEntityMachineStarMap)this.machine, partialTick, 0.8f);
                }
                GL11.glPopMatrix();
            }
        }
        GL11.glPopMatrix();
    }

    public void func_73863_a(int x, int y, float partialTick) {
        super.func_73863_a(x, y, partialTick);
    }

    public void func_146270_b(int p_146270_1_) {
    }

    @Override
    public void onPageChange(int newPage) {
        this.pageQuadrant.init();
        this.pageStar.init();
        this.planetPage.init();
        this.pagePlanetStats.init();
        if (newPage != ((TileEntityMachineStarMap)this.machine).getZoomLevel()) {
            ((TileEntityMachineStarMap)this.machine).setZoomLevel(newPage);
            ((TileEntityMachineStarMap)this.machine).SyncCommandsToServer();
        }
    }

    public void onPlanetChange(Planet planet) {
        this.pageStar.init();
        this.pagePlanetStats.loadShips();
        this.planetPage.init();
    }

    public void onTravelEventsChange(List<TravelEvent> travelEvents) {
        this.pagePlanetStats.init();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.indicator.setVisible(false);
        this.AddMainPlayerSlots(this.field_147002_h, this, "holo_with_BG", new GuiColor(Reference.COLOR_HOLO.getIntR() / 3, Reference.COLOR_HOLO.getIntG() / 3, Reference.COLOR_HOLO.getIntB() / 3), 45, this.field_147000_g - 104);
        this.AddHotbarPlayerSlots(this.field_147002_h, this, "holo_with_BG", new GuiColor(Reference.COLOR_HOLO.getIntR() / 2, Reference.COLOR_HOLO.getIntG() / 2, Reference.COLOR_HOLO.getIntB() / 2), 45, this.field_147000_g - 25);
    }

    public void func_146281_b() {
        ((TileEntityMachineStarMap)this.machine).SyncCommandsToServer();
    }

    @Override
    protected void updateElementInformation() {
        if (((TileEntityMachineStarMap)this.machine).getZoomLevel() != this.currentPage) {
            this.setPage(((TileEntityMachineStarMap)this.machine).getZoomLevel());
        }
        super.updateElementInformation();
        ((MOElementButton)((Object)this.pageButtons.get(4))).setVisible(((TileEntityMachineStarMap)this.machine).getPlanet() != null);
        ((MOElementButton)((Object)this.pageButtons.get(3))).setVisible(((TileEntityMachineStarMap)this.machine).getPlanet() != null);
        ((MOElementButton)((Object)this.pageButtons.get(2))).setVisible(((TileEntityMachineStarMap)this.machine).getStar() != null);
        ((MOElementButton)((Object)this.pageButtons.get(1))).setVisible(((TileEntityMachineStarMap)this.machine).getQuadrant() != null);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73876_c() {
        super.func_73876_c();
    }
}

