/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.inventory;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import matteroverdrive.api.IUpgradeable;
import matteroverdrive.api.inventory.IUpgrade;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.data.inventory.Slot;
import matteroverdrive.proxy.ClientProxy;
import net.minecraft.item.ItemStack;

public class UpgradeSlot
extends Slot {
    private IUpgradeable upgradeable;

    public UpgradeSlot(boolean isMainSlot, IUpgradeable upgradeable) {
        super(isMainSlot);
        this.upgradeable = upgradeable;
    }

    @Override
    public boolean isValidForSlot(ItemStack item) {
        if (item.func_77973_b() instanceof IUpgrade) {
            IUpgrade upgrade = (IUpgrade)item.func_77973_b();
            Map<UpgradeTypes, Double> upgradeMap = upgrade.getUpgrades(item);
            for (Map.Entry<UpgradeTypes, Double> entry : upgradeMap.entrySet()) {
                if (!this.upgradeable.isAffectedByUpgrade(entry.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public HoloIcon getHoloIcon() {
        return ClientProxy.holoIcons.getIcon("upgrade");
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    @Override
    public boolean keepOnDismatle() {
        return true;
    }

    @Override
    public String getUnlocalizedTooltip() {
        return "gui.tooltip.slot.upgrade";
    }
}

