/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.inventory;

import cofh.lib.util.helpers.EnergyHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import matteroverdrive.api.weapon.IWeaponModule;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.data.inventory.Slot;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.MatterHelper;
import net.minecraft.item.ItemStack;

public class ModuleSlot
extends Slot {
    int type;

    public ModuleSlot(boolean isMainSlot, int type) {
        super(isMainSlot);
        this.type = type;
    }

    @Override
    public boolean isValidForSlot(ItemStack item) {
        switch (this.type) {
            case 0: {
                return EnergyHelper.isEnergyContainerItem((ItemStack)item);
            }
        }
        return MatterHelper.isWeaponModule(item) && ((IWeaponModule)item.func_77973_b()).getSlot(item) == this.type;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public HoloIcon getHoloIcon() {
        switch (this.type) {
            case 0: {
                return ClientProxy.holoIcons.getIcon("battery");
            }
            case 1: {
                return ClientProxy.holoIcons.getIcon("color");
            }
            case 2: {
                return ClientProxy.holoIcons.getIcon("barrel");
            }
            case 3: {
                return ClientProxy.holoIcons.getIcon("sights");
            }
        }
        return ClientProxy.holoIcons.getIcon("module");
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }
}

