/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.biostats;

import cofh.lib.audio.SoundBase;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import matteroverdrive.api.events.bionicStats.MOEventBionicStat;
import matteroverdrive.data.biostats.AbstractBioticStat;
import matteroverdrive.entity.AndroidPlayer;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.util.IConfigSubscriber;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;

public class BioticStatNightvision
extends AbstractBioticStat
implements IConfigSubscriber {
    public static int ENERGY_PER_TICK = 16;

    public BioticStatNightvision(String name, int xp) {
        super(name, xp);
        this.setShowOnWheel(true);
        this.setShowOnHud(true);
    }

    @Override
    public String getDetails(int level) {
        return String.format(super.getDetails(level), EnumChatFormatting.YELLOW.toString() + ENERGY_PER_TICK + " RF");
    }

    @Override
    public void onAndroidUpdate(AndroidPlayer android, int level) {
        if (!android.getPlayer().field_70170_p.field_72995_K) {
            if (this.isActive(android, level) && !MinecraftForge.EVENT_BUS.post((Event)new MOEventBionicStat(this, level, android))) {
                android.extractEnergy(ENERGY_PER_TICK, false);
            }
        } else if (!MinecraftForge.EVENT_BUS.post((Event)new MOEventBionicStat(this, level, android))) {
            this.manageNightvision(android, level);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void manageNightvision(AndroidPlayer android, int level) {
        if (this.isActive(android, level)) {
            android.getPlayer().func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 500));
        }
    }

    public void setActive(AndroidPlayer androidPlayer, int level, boolean active) {
        androidPlayer.getPlayer().func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 500));
        androidPlayer.getEffects().func_74757_a("Nightvision", active);
        androidPlayer.sync(1, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onActionKeyPress(AndroidPlayer androidPlayer, int level, KeyBinding keyBinding) {
        if (androidPlayer.getActiveStat() != null && androidPlayer.getActiveStat().equals(this)) {
            androidPlayer.setActionToServer(2, !androidPlayer.getEffects().func_74767_n("Nightvision"));
            if (!androidPlayer.getEffects().func_74767_n("Nightvision")) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SoundBase("mo:night_vision", 0.05f + androidPlayer.getPlayer().func_70681_au().nextFloat() * 0.1f, 0.95f + androidPlayer.getPlayer().func_70681_au().nextFloat() * 0.1f));
            } else {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SoundBase("mo:power_down", 0.05f + androidPlayer.getPlayer().func_70681_au().nextFloat() * 0.1f, 0.95f + androidPlayer.getPlayer().func_70681_au().nextFloat() * 0.1f));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onKeyPress(AndroidPlayer androidPlayer, int level, int keycode, boolean down) {
    }

    @Override
    public void onLivingEvent(AndroidPlayer androidPlayer, int level, LivingEvent event) {
    }

    @Override
    public void changeAndroidStats(AndroidPlayer androidPlayer, int level, boolean enabled) {
        if (!this.isEnabled(androidPlayer, level) && this.isActive(androidPlayer, level)) {
            androidPlayer.setActionToServer(2, false);
        }
    }

    @Override
    public Multimap attributes(AndroidPlayer androidPlayer, int level) {
        return null;
    }

    @Override
    public boolean isActive(AndroidPlayer androidPlayer, int level) {
        return androidPlayer.getEffects().func_74767_n("Nightvision");
    }

    @Override
    public boolean isEnabled(AndroidPlayer androidPlayer, int level) {
        return super.isEnabled(androidPlayer, level) && androidPlayer.extractEnergy(ENERGY_PER_TICK, true) >= ENERGY_PER_TICK;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        ENERGY_PER_TICK = config.getInt("nighvision_energy_per_tick", "abilities", 16, "The energy cost of the Nightvision");
    }
}

