/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.biostats;

import java.util.ArrayList;
import java.util.List;
import matteroverdrive.api.android.IBionicStat;
import matteroverdrive.entity.AndroidPlayer;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;

public abstract class AbstractBioticStat
implements IBionicStat {
    int xp;
    String name;
    IBionicStat root;
    List<IBionicStat> competitors;
    List<ItemStack> reqiredItems;
    List<IBionicStat> enabledBlacklist;
    int maxLevel;
    boolean showOnHud;
    boolean showOnWheel;
    IIcon icon;

    public AbstractBioticStat(String name, int xp) {
        this.name = name;
        this.xp = xp;
        this.competitors = new ArrayList<IBionicStat>();
        this.reqiredItems = new ArrayList<ItemStack>();
        this.enabledBlacklist = new ArrayList<IBionicStat>();
        this.maxLevel = 1;
    }

    @Override
    public String getUnlocalizedName() {
        return this.name;
    }

    @Override
    public String getDisplayName(AndroidPlayer androidPlayer, int level) {
        return MOStringHelper.translateToLocal("biotic_stat." + this.name + ".name");
    }

    @Override
    public boolean isEnabled(AndroidPlayer android, int level) {
        return this.checkBlacklistActive(android, level);
    }

    public String getDetails(int level) {
        return MOStringHelper.translateToLocal("biotic_stat." + this.name + ".details");
    }

    @Override
    public boolean canBeUnlocked(AndroidPlayer android, int level) {
        if (this.root != null && !android.isUnlocked(this.root, this.root.maxLevel())) {
            return false;
        }
        if (this.competitors.size() > 0) {
            for (IBionicStat compeditor : this.competitors) {
                if (!android.isUnlocked(compeditor, 0)) continue;
                return false;
            }
        }
        if (this.reqiredItems.size() > 0) {
            for (ItemStack item : this.reqiredItems) {
                if (this.hasItem(android, item)) continue;
                return false;
            }
        }
        if (android.isAndroid()) {
            return android.getPlayer().field_71075_bZ.field_75098_d || android.getPlayer().field_71068_ca >= this.xp;
        }
        return false;
    }

    protected boolean hasItem(AndroidPlayer player, ItemStack stack) {
        int amountCount = stack.field_77994_a;
        for (int i = 0; i < player.getPlayer().field_71071_by.func_70302_i_(); ++i) {
            ItemStack s = player.getPlayer().field_71071_by.func_70301_a(i);
            if (s == null || !s.func_77969_a(stack)) continue;
            amountCount -= s.field_77994_a;
        }
        return amountCount <= 0;
    }

    @Override
    public void onUnlock(AndroidPlayer android, int level) {
        android.getPlayer().func_82242_a(-this.xp);
        this.consumeItems(android);
    }

    protected void consumeItems(AndroidPlayer androidPlayer) {
        for (ItemStack itemStack : this.reqiredItems) {
            int itemCount = itemStack.field_77994_a;
            for (int j = 0; j < androidPlayer.getPlayer().field_71071_by.func_70302_i_(); ++j) {
                ItemStack pStack = androidPlayer.getPlayer().field_71071_by.func_70301_a(j);
                if (pStack != null && pStack.func_77969_a(itemStack)) {
                    int countShouldTake = Math.min(itemCount, pStack.field_77994_a);
                    androidPlayer.getPlayer().field_71071_by.func_70298_a(j, countShouldTake);
                    itemCount -= countShouldTake;
                }
                if (itemCount > 0) continue;
                return;
            }
        }
    }

    @Override
    public void onTooltip(AndroidPlayer android, int level, List<String> list, int mouseX, int mouseY) {
        String[] detailsSplit;
        String name = this.getDisplayName(android, level);
        if (this.maxLevel() > 1) {
            name = name + String.format(" [%s/%s]", level, this.maxLevel());
        }
        list.add(EnumChatFormatting.WHITE + name);
        String details = this.getDetails(level);
        for (String detail : detailsSplit = details.split("/n/")) {
            list.add(EnumChatFormatting.GRAY + detail);
        }
        String reqires = "";
        if (this.root != null) {
            reqires = reqires + EnumChatFormatting.GOLD + String.format("[%s%s]", this.root.getDisplayName(android, 0), this.root.maxLevel() > 1 ? " " + this.root.maxLevel() : "");
        }
        if (this.reqiredItems.size() > 0) {
            for (ItemStack itemStack : this.reqiredItems) {
                if (!reqires.isEmpty()) {
                    reqires = reqires + EnumChatFormatting.GRAY + ", ";
                }
                if (itemStack.field_77994_a > 1) {
                    reqires = reqires + EnumChatFormatting.WHITE.toString() + itemStack.field_77994_a + "x";
                }
                reqires = reqires + EnumChatFormatting.WHITE + "[" + itemStack.func_82833_r() + "]";
            }
        }
        if (!reqires.isEmpty()) {
            list.add(MOStringHelper.translateToLocal("gui.tooltip.requires") + ": " + reqires);
        }
        if (level <= this.maxLevel()) {
            list.add((android.getPlayer().field_71068_ca < this.xp ? EnumChatFormatting.RED : EnumChatFormatting.GREEN) + "XP: " + this.xp);
        }
    }

    public boolean checkBlacklistActive(AndroidPlayer androidPlayer, int level) {
        for (IBionicStat stat : this.enabledBlacklist) {
            if (!stat.isActive(androidPlayer, level)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void registerIcons(TextureMap holoIcons) {
        this.icon = holoIcons.func_94245_a("mo:biotic_stat_" + this.name);
    }

    public void addReqiredItm(ItemStack stack) {
        this.reqiredItems.add(stack);
    }

    @Override
    public boolean showOnHud(AndroidPlayer android, int level) {
        return this.showOnHud;
    }

    @Override
    public boolean showOnWheel(AndroidPlayer androidPlayer, int level) {
        return this.showOnWheel;
    }

    @Override
    public int maxLevel() {
        return this.maxLevel;
    }

    @Override
    public IBionicStat getRoot() {
        return this.root;
    }

    public void setRoot(IBionicStat stat) {
        this.root = stat;
    }

    public void addCompetitor(IBionicStat stat) {
        this.competitors.add(stat);
    }

    public void removeCompetitor(IBionicStat competitor) {
        this.competitors.remove(competitor);
    }

    public List<IBionicStat> getCompetitors() {
        return this.competitors;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setShowOnHud(boolean showOnHud) {
        this.showOnHud = showOnHud;
    }

    public void setShowOnWheel(boolean showOnWheel) {
        this.showOnWheel = showOnWheel;
    }

    @Override
    public List<ItemStack> getRequiredItems() {
        return this.reqiredItems;
    }

    public List<IBionicStat> getEnabledBlacklist() {
        return this.enabledBlacklist;
    }

    public void addToEnabledBlacklist(IBionicStat stat) {
        this.enabledBlacklist.add(stat);
    }

    @Override
    public IIcon getIcon(int level) {
        return this.icon;
    }
}

