/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data;

import cofh.api.energy.IEnergyStorage;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.machines.MOTileEntityMachine;
import net.minecraft.nbt.NBTTagCompound;

public class MachineEnergyStorage<T extends MOTileEntityMachine>
implements IEnergyStorage {
    protected int energy;
    protected int capacity;
    protected int maxReceive;
    protected int maxExtract;
    protected final T machine;

    public MachineEnergyStorage(T machine, int capacity) {
        this(machine, capacity, capacity, capacity);
    }

    public MachineEnergyStorage(T machine, int capacity, int maxReceive, int maxExtract) {
        this.machine = machine;
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        this.energy = tagCompound.func_74762_e("Energy");
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("Energy", this.energy);
    }

    public void modifyEnergyStored(int amount) {
        this.energy += amount;
        if (this.energy > this.getMaxEnergyStored()) {
            this.energy = this.getEnergyStored();
        } else if (this.energy < 0) {
            this.energy = 0;
        }
    }

    public int receiveEnergy(int amount, boolean simulate) {
        int clampedAmount = Math.min(this.getMaxEnergyStored() - this.energy, Math.min(this.getMaxReceive(), amount));
        if (!simulate) {
            this.energy += clampedAmount;
        }
        return clampedAmount;
    }

    public int extractEnergy(int amount, boolean simulate) {
        int clampedAmount = Math.min(this.getMaxEnergyStored(), Math.min(this.getMaxExtract(), amount));
        if (!simulate) {
            this.energy -= clampedAmount;
        }
        return clampedAmount;
    }

    public int getMaxReceive() {
        return Math.max(0, (int)((double)this.maxReceive * ((MOTileEntityMachine)this.machine).getUpgradeMultiply(UpgradeTypes.PowerTransfer)));
    }

    public int getMaxExtract() {
        return Math.max(0, (int)((double)this.maxExtract * ((MOTileEntityMachine)this.machine).getUpgradeMultiply(UpgradeTypes.PowerTransfer)));
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return Math.max(0, (int)((double)this.capacity * ((MOTileEntityMachine)this.machine).getUpgradeMultiply(UpgradeTypes.PowerStorage)));
    }

    public void setMaxTransfer(int amount) {
        this.setMaxReceive(amount);
        this.setMaxExtract(amount);
    }

    public void setEnergyStored(int energy) {
        this.energy = energy;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
    }

    public void setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
    }
}

