/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.tileentity.starmap;

import cofh.lib.gui.GuiColor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import matteroverdrive.Reference;
import matteroverdrive.client.render.tileentity.starmap.StarMapRendererStars;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.data.Galaxy;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.starmap.data.Quadrant;
import matteroverdrive.starmap.data.SpaceBody;
import matteroverdrive.starmap.data.TravelEvent;
import matteroverdrive.tile.TileEntityMachineStarMap;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class StarMapRenderGalaxy
extends StarMapRendererStars {
    @Override
    public void renderBody(Galaxy galaxy, SpaceBody spaceBody, TileEntityMachineStarMap starMap, float partialTicks, float viewerDistance) {
        double distanceMultiply = 2.0;
        GL11.glLineWidth((float)1.0f);
        for (Quadrant quadrant : galaxy.getQuadrants()) {
            this.renderStars(quadrant, starMap, distanceMultiply, 2.0);
        }
        GL11.glDisable((int)3553);
        for (int i = 0; i < galaxy.getTravelEvents().size(); ++i) {
            TravelEvent travelEvent = galaxy.getTravelEvents().get(i);
            if (!travelEvent.isValid(GalaxyClient.getInstance().getTheGalaxy())) continue;
            Vec3 from = GalaxyClient.getInstance().getTheGalaxy().getPlanet(travelEvent.getFrom()).getStar().getPosition(2.0);
            Vec3 to = GalaxyClient.getInstance().getTheGalaxy().getPlanet(travelEvent.getTo()).getStar().getPosition(2.0);
            Vec3 dir = from.func_72444_a(to);
            double percent = travelEvent.getPercent(starMap.func_145831_w());
            RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, 0.5f);
            GL11.glPolygonMode((int)1032, (int)6913);
            GL11.glPushMatrix();
            GL11.glTranslated((double)(from.field_72450_a + dir.field_72450_a * percent), (double)(from.field_72448_b + dir.field_72448_b * percent), (double)(from.field_72449_c + dir.field_72449_c * percent));
            RenderUtils.rotateTowards(Vec3.func_72443_a((double)-1.0, (double)0.0, (double)0.0), dir.func_72432_b(), Vec3.func_72443_a((double)0.0, (double)1.0, (double)0.0));
            RenderUtils.drawShip(0.0, 0.0, 0.0, 0.02);
            GL11.glPopMatrix();
            GL11.glPolygonMode((int)1032, (int)6914);
            RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO_PURPLE, 0.5f);
            GL11.glBegin((int)3);
            GL11.glVertex3d((double)from.field_72450_a, (double)from.field_72448_b, (double)from.field_72449_c);
            GL11.glVertex3d((double)to.field_72450_a, (double)to.field_72448_b, (double)to.field_72449_c);
            GL11.glEnd();
        }
        GL11.glEnable((int)3553);
    }

    @Override
    public void renderGUIInfo(Galaxy galaxy, SpaceBody spaceBody, TileEntityMachineStarMap starMap, float partialTicks, float opacity) {
        GL11.glEnable((int)3008);
        int ownedSystemCount = galaxy.getOwnedSystemCount((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        int enemySystemCount = galaxy.getEnemySystemCount((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        int freeSystemCount = galaxy.getStarCount() - ownedSystemCount - enemySystemCount;
        GuiColor color = Reference.COLOR_HOLO_GREEN;
        RenderUtils.applyColorWithMultipy(color, opacity);
        ClientProxy.holoIcons.renderIcon("page_icon_star", 0, -30);
        RenderUtils.drawString(String.format("x%s", ownedSystemCount), 24, -23, color, opacity);
        color = Reference.COLOR_HOLO_RED;
        RenderUtils.applyColorWithMultipy(color, opacity);
        ClientProxy.holoIcons.renderIcon("page_icon_star", 64, -30);
        RenderUtils.drawString(String.format("x%s", enemySystemCount), 88, -23, color, opacity);
        color = Reference.COLOR_HOLO;
        RenderUtils.applyColorWithMultipy(color, opacity);
        ClientProxy.holoIcons.renderIcon("page_icon_star", 128, -30);
        RenderUtils.drawString(String.format("x%s", freeSystemCount), 152, -23, color, opacity);
        for (int i = 0; i < galaxy.getTravelEvents().size(); ++i) {
            TravelEvent travelEvent = galaxy.getTravelEvents().get(i);
            if (!travelEvent.isValid(GalaxyClient.getInstance().getTheGalaxy())) continue;
            Planet from = GalaxyClient.getInstance().getTheGalaxy().getPlanet(travelEvent.getFrom());
            Planet to = GalaxyClient.getInstance().getTheGalaxy().getPlanet(travelEvent.getTo());
            RenderUtils.drawString(String.format("%s -> %s : %s", from.getName(), to.getName(), MOStringHelper.formatRemainingTime(galaxy.getTravelEvents().get(i).getTimeRemainning(starMap.func_145831_w()) / 20L)), 0, -48 - i * 10, Reference.COLOR_HOLO, opacity);
        }
        GL11.glDisable((int)3008);
    }

    @Override
    public boolean displayOnZoom(int zoom, SpaceBody spaceBody) {
        return true;
    }

    @Override
    public double getHologramHeight(SpaceBody spaceBody) {
        return 2.5;
    }
}

