/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.item;

import cofh.lib.gui.GuiColor;
import matteroverdrive.api.weapon.IWeaponModule;
import matteroverdrive.items.weapon.Phaser;
import matteroverdrive.items.weapon.module.WeaponModuleColor;
import matteroverdrive.util.RenderUtils;
import matteroverdrive.util.WeaponHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

public class ItemRendererPhaser
implements IItemRenderer {
    public static final String TEXTURE = "mo:textures/items/phaser.png";
    private static final String TEXTURE_COLOR_MASK = "mo:textures/items/phaser_color_mask.png";
    public static final String MODEL = "mo:models/item/phaser.obj";
    public static final float SCALE = 3.2f;
    public static final float THIRD_PERSON_SCALE = 3.0f;
    public static final float ITEM_SCALE = 3.0f;
    public static final float SCALE_DROP = 2.5f;
    public static IModelCustom phaserModel;
    public static ResourceLocation phaserTexture;
    public static ResourceLocation phaserTextureColorMask;

    public ItemRendererPhaser() {
        phaserTexture = new ResourceLocation(TEXTURE);
        phaserTextureColorMask = new ResourceLocation(TEXTURE_COLOR_MASK);
        phaserModel = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation(MODEL));
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            this.RenderFirstPerson(item);
        } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.RenderItem(item);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            this.RenderDrop(item);
        } else {
            this.RenderThirdPerson(type, item);
        }
    }

    void RenderItem(ItemStack item) {
        GL11.glPushMatrix();
        GL11.glScaled((double)3.0, (double)3.0, (double)3.0);
        GL11.glTranslated((double)0.0, (double)0.03, (double)0.0);
        GL11.glRotated((double)0.0, (double)0.0, (double)1.0, (double)0.0);
        this.RenderGun(IItemRenderer.ItemRenderType.INVENTORY, item);
        GL11.glPopMatrix();
    }

    void RenderThirdPerson(IItemRenderer.ItemRenderType renderType, ItemStack item) {
        GL11.glPushMatrix();
        GL11.glScaled((double)3.0, (double)3.0, (double)3.0);
        GL11.glTranslated((double)0.22, (double)0.13, (double)0.22);
        GL11.glRotated((double)-135.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)60.0, (double)1.0, (double)0.0, (double)0.0);
        this.RenderGun(renderType, item);
        GL11.glPopMatrix();
    }

    void RenderDrop(ItemStack item) {
        GL11.glPushMatrix();
        GL11.glScaled((double)2.5, (double)2.5, (double)2.5);
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)15.0, (double)1.0, (double)0.0, (double)0.0);
        this.RenderGun(IItemRenderer.ItemRenderType.ENTITY, item);
        GL11.glPopMatrix();
    }

    void RenderFirstPerson(ItemStack item) {
        GL11.glPushMatrix();
        GL11.glScaled((double)3.2f, (double)3.2f, (double)3.2f);
        if (Minecraft.func_71410_x().field_71439_g.func_71039_bw()) {
            GL11.glTranslated((double)0.2, (double)0.2, (double)0.08);
            GL11.glRotated((double)150.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)-26.0, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)-5.0, (double)1.0, (double)0.0, (double)1.0);
        } else {
            GL11.glTranslated((double)0.05, (double)0.25, (double)0.05);
            GL11.glRotated((double)137.5, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)-12.0, (double)1.0, (double)0.0, (double)0.0);
        }
        this.RenderGun(IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON, item);
        GL11.glPopMatrix();
    }

    void RenderGun(IItemRenderer.ItemRenderType renderType, ItemStack item) {
        IWeaponModule module;
        Object colorObject;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(phaserTexture);
        phaserModel.renderPart("phaser");
        GuiColor color = WeaponModuleColor.defaultColor;
        ItemStack color_module = WeaponHelper.getModuleAtSlot(1, item);
        if (color_module != null && (colorObject = (module = (IWeaponModule)color_module.func_77973_b()).getValue(color_module)) instanceof GuiColor) {
            color = (GuiColor)colorObject;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)color.getFloatR(), (float)color.getFloatG(), (float)color.getFloatB(), (float)color.getFloatA());
        Minecraft.func_71410_x().field_71446_o.func_110577_a(phaserTextureColorMask);
        phaserModel.renderPart("phaser");
        GL11.glDisable((int)2896);
        RenderUtils.disableLightmap();
        this.renderLevelSlider(item);
        this.renderKillIndicator(item);
        GL11.glEnable((int)2896);
    }

    private void renderLevelSlider(ItemStack item) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(phaserTexture);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        phaserModel.renderPart("level_bg");
        this.setIndicatorColor(item);
        GL11.glPushMatrix();
        double power = ((double)item.func_77978_p().func_74771_c("power") + 1.0) / 6.0;
        GL11.glTranslated((double)0.035, (double)0.0, (double)0.0);
        GL11.glScaled((double)power, (double)1.0, (double)1.0);
        phaserModel.renderPart("level_slider");
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
    }

    private void renderKillIndicator(ItemStack item) {
        GL11.glDisable((int)2896);
        this.setIndicatorColor(item);
        phaserModel.renderPart("kill_indicator");
        GL11.glEnable((int)2896);
    }

    private void setIndicatorColor(ItemStack item) {
        if (Phaser.isKillMode(item)) {
            GL11.glColor3d((double)1.0, (double)0.0, (double)0.0);
        } else {
            GL11.glColor3d((double)0.0, (double)1.0, (double)0.0);
        }
    }
}

