/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import matteroverdrive.tile.pipes.TileEntityPipe;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RendererBlockPipe
implements ISimpleBlockRenderingHandler {
    public static int rendererID;

    public RendererBlockPipe() {
        rendererID = RenderingRegistry.getNextAvailableRenderId();
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        IIcon icon = block.func_149691_a(0, metadata);
        GL11.glPushMatrix();
        GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        Tessellator.field_78398_a.func_78382_b();
        this.renderPipe(0, 0, 0, block, 0, icon, 0xF00040);
        Tessellator.field_78398_a.func_78381_a();
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int meta = world.func_72805_g(x, y, z);
        IIcon icon = block.func_149673_e(world, x, y, z, meta);
        int connections = ((TileEntityPipe)world.func_147438_o(x, y, z)).getConnections();
        int brightness = block.func_149677_c(world, x, y, z);
        this.renderPipe(x, y, z, block, connections, icon, brightness);
        return true;
    }

    protected void renderPipe(int x, int y, int z, Block block, int connections, IIcon icon, int brigtness) {
        float step = 0.33333334f;
        Tessellator.field_78398_a.func_78370_a(255, 255, 255, 255);
        Tessellator.field_78398_a.func_78380_c(brigtness);
        for (int i = 0; i < 6; ++i) {
            if (!MOMathHelper.getBoolean(connections, i)) continue;
            ForgeDirection direction = ForgeDirection.getOrientation((int)i);
            if (direction == ForgeDirection.UP || direction == ForgeDirection.DOWN) {
                this.drawCubeUpDown((float)x + step + step * (float)direction.offsetX, (float)y + step + step * (float)direction.offsetY, (float)z + step + step * (float)direction.offsetZ, 0.33333334f, icon, 6, 0);
                continue;
            }
            if (direction == ForgeDirection.NORTH || direction == ForgeDirection.SOUTH) {
                this.drawCubeNorthSouth((float)x + step + step * (float)direction.offsetX, (float)y + step + step * (float)direction.offsetY, (float)z + step + step * (float)direction.offsetZ, 0.33333334f, icon, 6, 0);
                continue;
            }
            this.drawCube((float)x + step + step * (float)direction.offsetX, (float)y + step + step * (float)direction.offsetY, (float)z + step + step * (float)direction.offsetZ, 0.33333334f, icon, 6, 0);
        }
        if (connections == 3) {
            this.drawCubeUpDown((float)x + step, (float)y + step, (float)z + step, 0.33333334f, icon, 6, 0);
        } else if (connections == 12) {
            this.drawCubeNorthSouth((float)x + step, (float)y + step, (float)z + step, 0.33333334f, icon, 6, 0);
        } else if (connections == 48) {
            this.drawCube((float)x + step, (float)y + step, (float)z + step, 0.33333334f, icon, 6, 0);
        } else {
            this.drawCube((float)x + step, (float)y + step, (float)z + step, 0.33333334f, icon, 0, 0);
        }
    }

    public void drawCube(double x, double y, double z, float size, IIcon icon, int u, int v) {
        Tessellator.field_78398_a.func_78386_a(0.6f, 0.65f, 0.7f);
        Tessellator.field_78398_a.func_78375_b(0.0f, -1.0f, 0.0f);
        Tessellator.field_78398_a.func_78374_a(x, y, z, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y, z, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y, z + (double)size, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78374_a(x, y, z + (double)size, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
        Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
        Tessellator.field_78398_a.func_78374_a(x, y + (double)size, z, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x, y + (double)size, z + (double)size, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y + (double)size, z + (double)size, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y + (double)size, z, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78386_a(0.7f, 0.75f, 0.8f);
        Tessellator.field_78398_a.func_78375_b(-1.0f, 0.0f, 0.0f);
        Tessellator.field_78398_a.func_78374_a(x, y, z, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x, y, z + (double)size, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78374_a(x, y + (double)size, z + (double)size, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78374_a(x, y + (double)size, z, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78386_a(0.7f, 0.75f, 0.8f);
        Tessellator.field_78398_a.func_78375_b(1.0f, 0.0f, 0.0f);
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y, z, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y + (double)size, z, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y + (double)size, z + (double)size, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y, z + (double)size, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78386_a(0.9f, 0.95f, 1.0f);
        Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, 1.0f);
        Tessellator.field_78398_a.func_78374_a(x, y, z + (double)size, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y, z + (double)size, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y + (double)size, z + (double)size, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78374_a(x, y + (double)size, z + (double)size, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78386_a(0.9f, 0.95f, 1.0f);
        Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, -1.0f);
        Tessellator.field_78398_a.func_78374_a(x, y, z, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x, y + (double)size, z, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y + (double)size, z, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y, z, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)v));
    }

    public void drawCubeUpDown(double x, double y, double z, float size, IIcon icon, int u, int v) {
        Tessellator.field_78398_a.func_78386_a(0.6f, 0.65f, 0.7f);
        Tessellator.field_78398_a.func_78375_b(0.0f, -1.0f, 0.0f);
        Tessellator.field_78398_a.func_78374_a(x, y, z, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y, z, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y, z + (double)size, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78374_a(x, y, z + (double)size, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
        Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
        Tessellator.field_78398_a.func_78374_a(x, y + (double)size, z, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x, y + (double)size, z + (double)size, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y + (double)size, z + (double)size, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y + (double)size, z, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78386_a(0.7f, 0.75f, 0.8f);
        Tessellator.field_78398_a.func_78375_b(-1.0f, 0.0f, 0.0f);
        Tessellator.field_78398_a.func_78374_a(x, y, z, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x, y, z + (double)size, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78374_a(x, y + (double)size, z + (double)size, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78374_a(x, y + (double)size, z, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78386_a(0.7f, 0.75f, 0.8f);
        Tessellator.field_78398_a.func_78375_b(1.0f, 0.0f, 0.0f);
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y, z, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y + (double)size, z, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y + (double)size, z + (double)size, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y, z + (double)size, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78386_a(0.9f, 0.95f, 1.0f);
        Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, 1.0f);
        Tessellator.field_78398_a.func_78374_a(x, y, z + (double)size, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y, z + (double)size, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y + (double)size, z + (double)size, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x, y + (double)size, z + (double)size, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78386_a(0.9f, 1.0f, 0.95f);
        Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, -1.0f);
        Tessellator.field_78398_a.func_78374_a(x, y, z, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x, y + (double)size, z, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y + (double)size, z, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y, z, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)(v + 6)));
    }

    public void drawCubeNorthSouth(double x, double y, double z, float size, IIcon icon, int u, int v) {
        Tessellator.field_78398_a.func_78386_a(0.6f, 0.65f, 0.7f);
        Tessellator.field_78398_a.func_78375_b(0.0f, -1.0f, 0.0f);
        Tessellator.field_78398_a.func_78374_a(x, y, z, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y, z, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y, z + (double)size, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x, y, z + (double)size, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
        Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
        Tessellator.field_78398_a.func_78374_a(x, y + (double)size, z, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x, y + (double)size, z + (double)size, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y + (double)size, z + (double)size, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y + (double)size, z, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78386_a(0.7f, 0.75f, 0.8f);
        Tessellator.field_78398_a.func_78375_b(-1.0f, 0.0f, 0.0f);
        Tessellator.field_78398_a.func_78374_a(x, y, z, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x, y, z + (double)size, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x, y + (double)size, z + (double)size, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78374_a(x, y + (double)size, z, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78386_a(0.7f, 0.75f, 0.8f);
        Tessellator.field_78398_a.func_78375_b(1.0f, 0.0f, 0.0f);
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y, z, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y + (double)size, z, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y + (double)size, z + (double)size, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y, z + (double)size, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78386_a(0.9f, 0.95f, 1.0f);
        Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, 1.0f);
        Tessellator.field_78398_a.func_78374_a(x, y, z + (double)size, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y, z + (double)size, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y + (double)size, z + (double)size, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x, y + (double)size, z + (double)size, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78386_a(0.9f, 0.95f, 1.0f);
        Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, -1.0f);
        Tessellator.field_78398_a.func_78374_a(x, y, z, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x, y + (double)size, z, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)v));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y + (double)size, z, (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)(v + 6)));
        Tessellator.field_78398_a.func_78374_a(x + (double)size, y, z, (double)icon.func_94214_a((double)(u + 6)), (double)icon.func_94207_b((double)(v + 6)));
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return rendererID;
    }
}

