/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.biostat;

import matteroverdrive.Reference;
import matteroverdrive.api.renderer.IBioticStatRenderer;
import matteroverdrive.data.biostats.BioticStatShield;
import matteroverdrive.entity.AndroidPlayer;
import matteroverdrive.init.MatterOverdriveBioticStats;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class BioticStatRendererShield
implements IBioticStatRenderer<BioticStatShield> {
    public static final ResourceLocation forcefield_damage_tex = new ResourceLocation("mo:textures/fx/shield_damage.png");
    public static final ResourceLocation forcefield_tex = new ResourceLocation("mo:textures/fx/forcefield_plasma.png");
    public static final ResourceLocation forcefield_plasma_tex = new ResourceLocation("mo:textures/fx/forcefield_plasma_2.png");
    public static final ResourceLocation shield_texture = new ResourceLocation("mo:textures/fx/shield.png");
    public static final ResourceLocation model_path = new ResourceLocation("mo:models/shield_sphere.obj");
    IModelCustom normal_sphere;
    IModelCustom shield_model = AdvancedModelLoader.loadModel((ResourceLocation)model_path);
    float opacityLerp = 0.0f;

    public BioticStatRendererShield() {
        this.normal_sphere = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("mo:models/block/sphere.obj"));
    }

    @Override
    public void onWorldRender(BioticStatShield stat, int level, RenderWorldLastEvent event) {
        for (Object entity : Minecraft.func_71410_x().field_71441_e.field_73010_i) {
            this.renderPlayerShield(event, (EntityPlayer)entity);
        }
    }

    private void renderPlayerShield(RenderWorldLastEvent event, EntityPlayer player) {
        AndroidPlayer androidPlayer = AndroidPlayer.get(player);
        boolean isVisible = this.manageOpacityLerp(androidPlayer, event.partialTicks);
        if (isVisible) {
            double time = Minecraft.func_71410_x().field_71441_e.func_72820_D();
            GL11.glPushMatrix();
            GL11.glDepthMask((boolean)false);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3008);
            GL11.glDisable((int)2884);
            GL11.glBlendFunc((int)1, (int)1);
            Vec3 playerPosition = player.func_70666_h(event.partialTicks);
            Vec3 clientPosition = Minecraft.func_71410_x().field_71439_g.func_70666_h(event.partialTicks);
            RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, 0.2f * this.getOpacityLerp(player));
            Minecraft.func_71410_x().field_71446_o.func_110577_a(shield_texture);
            if (!this.isClient(player)) {
                GL11.glTranslated((double)0.0, (double)((double)player.field_70131_O - 0.5), (double)0.0);
                GL11.glEnable((int)2884);
            } else if (Minecraft.func_71410_x().field_71474_y.field_74320_O > 0) {
                GL11.glEnable((int)2884);
            }
            GL11.glTranslated((double)(playerPosition.field_72450_a - clientPosition.field_72450_a), (double)(playerPosition.field_72448_b - clientPosition.field_72448_b), (double)(playerPosition.field_72449_c - clientPosition.field_72449_c));
            GL11.glTranslated((double)0.0, (double)-0.5, (double)0.0);
            GL11.glScaled((double)3.0, (double)3.0, (double)3.0);
            GL11.glRotated((double)(player.field_70179_y * 45.0), (double)-1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)(player.field_70159_w * 45.0), (double)0.0, (double)0.0, (double)1.0);
            this.shield_model.renderAll();
            GL11.glDisable((int)2884);
            this.renderAttacks(androidPlayer);
            RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, 0.1f * this.getOpacityLerp(player));
            Minecraft.func_71410_x().field_71446_o.func_110577_a(forcefield_tex);
            GL11.glScaled((double)1.02, (double)1.02, (double)1.02);
            this.normal_sphere.renderAll();
            RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, 0.05f * this.getOpacityLerp(player));
            GL11.glPushMatrix();
            GL11.glRotated((double)(time * 0.005), (double)Math.sin(time * 0.01), (double)Math.cos(time * 0.01), (double)0.0);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(forcefield_plasma_tex);
            GL11.glScaled((double)1.01, (double)1.01, (double)1.01);
            this.normal_sphere.renderAll();
            GL11.glPopMatrix();
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2884);
            GL11.glEnable((int)3008);
            GL11.glDepthMask((boolean)true);
            GL11.glPopMatrix();
        }
    }

    private boolean manageOpacityLerp(AndroidPlayer androidPlayer, float partialTicks) {
        if (MatterOverdriveBioticStats.shield.getShieldState(androidPlayer)) {
            if (this.isClient(androidPlayer.getPlayer()) && this.opacityLerp < 1.0f) {
                this.opacityLerp = Math.min(1.0f, this.opacityLerp + partialTicks * 0.1f);
            }
            return true;
        }
        if (this.isClient(androidPlayer.getPlayer()) && this.opacityLerp > 0.0f) {
            this.opacityLerp = Math.max(0.0f, this.opacityLerp - partialTicks * 0.2f);
            return true;
        }
        return false;
    }

    private boolean isClient(EntityPlayer player) {
        return player == Minecraft.func_71410_x().field_71439_g;
    }

    private float getOpacityLerp(EntityPlayer player) {
        if (Minecraft.func_71410_x().field_71439_g == player) {
            return this.opacityLerp;
        }
        return 1.0f;
    }

    private void renderAttacks(AndroidPlayer androidPlayer) {
        float opacity = this.getOpacityLerp(androidPlayer.getPlayer());
        if (androidPlayer.getEffects().func_74764_b("Hits")) {
            NBTTagList hits = androidPlayer.getEffects().func_150295_c("Hits", 10);
            for (int i = 0; i < hits.func_74745_c(); ++i) {
                this.renderAttack(new Vector3f(hits.func_150305_b(i).func_74760_g("x"), -hits.func_150305_b(i).func_74760_g("y"), -hits.func_150305_b(i).func_74760_g("z")).normalise(null), (float)hits.func_150305_b(i).func_74762_e("time") / 10.0f * opacity);
            }
        }
    }

    private void renderAttack(Vector3f dir, float percent) {
        GL11.glPushMatrix();
        Vector3f front = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f c = Vector3f.cross((Vector3f)dir, (Vector3f)front, null);
        double omega = Math.acos(Vector3f.dot((Vector3f)dir, (Vector3f)front));
        GL11.glRotated((double)(omega * 57.29577951308232), (double)c.x, (double)c.y, (double)c.z);
        RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, 1.0f * percent);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(forcefield_damage_tex);
        this.normal_sphere.renderAll();
        GL11.glPopMatrix();
    }
}

