/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.buildcraft;

import buildcraft.api.recipes.BuildcraftRecipes;
import buildcraft.api.recipes.IIntegrationRecipeManager;
import java.util.ArrayList;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.mods.buildcraft.IIntegrationRecipeFunction;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.buildcraft.IntegrationTable")
@ModOnly(value={"BuildCraft|Core"})
public class IntegrationTable {
    @ZenMethod
    public static void addRecipe(IItemStack output, double energy, IIngredient inputA, IIngredient inputB, @Optional IIntegrationRecipeFunction function) {
        MineTweakerAPI.apply(new AddRecipeAction(output, energy, inputA, inputB, function));
    }

    @ZenMethod
    public static void remove(IIngredient output) {
        IntegrationTable.removeRecipe(output, null, null);
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output, @Optional IIngredient inputA, @Optional IIngredient inputB) {
        ArrayList<IIntegrationRecipeManager.IIntegrationRecipe> toRemove = new ArrayList<IIntegrationRecipeManager.IIntegrationRecipe>();
        block0: for (IIntegrationRecipeManager.IIntegrationRecipe recipe : BuildcraftRecipes.integrationTable.getRecipes()) {
            for (ItemStack component : recipe.getComponents()) {
                if (!output.matches(MineTweakerMC.getIItemStack(component))) break;
                if (inputA != null) {
                    for (ItemStack example1 : recipe.getExampleInputsA()) {
                        if (!inputA.matches(MineTweakerMC.getIItemStack(example1))) continue block0;
                    }
                }
                if (inputB != null) {
                    for (ItemStack example2 : recipe.getExampleInputsB()) {
                        if (!inputB.matches(MineTweakerMC.getIItemStack(example2))) continue block0;
                    }
                }
                toRemove.add(recipe);
            }
        }
        for (IIntegrationRecipeManager.IIntegrationRecipe recipe : toRemove) {
            MineTweakerAPI.apply(new RemoveRecipeAction(recipe));
        }
    }

    private static class MTIntegrationRecipe
    implements IIntegrationRecipeManager.IIntegrationRecipe {
        private final IItemStack output;
        private final ItemStack[] components;
        private final double energy;
        private final IIngredient inputA;
        private final ItemStack[] inputAExamples;
        private final IIngredient inputB;
        private final ItemStack[] inputBExamples;
        private final IIntegrationRecipeFunction function;

        private MTIntegrationRecipe(IItemStack output, double energy, IIngredient inputA, IIngredient inputB, IIntegrationRecipeFunction function) {
            this.output = output;
            this.components = new ItemStack[]{MineTweakerMC.getItemStack(output)};
            this.energy = energy;
            this.inputA = inputA;
            this.inputAExamples = MineTweakerMC.getExamples(inputA);
            this.inputB = inputB;
            this.inputBExamples = MineTweakerMC.getExamples(inputB);
            this.function = function;
        }

        public double getEnergyCost() {
            return this.energy;
        }

        public boolean isValidInputA(ItemStack is) {
            return this.inputA.matches(MineTweakerMC.getIItemStack(is));
        }

        public boolean isValidInputB(ItemStack is) {
            return this.inputB.matches(MineTweakerMC.getIItemStack(is));
        }

        public ItemStack getOutputForInputs(ItemStack is, ItemStack is1, ItemStack[] iss) {
            if (this.function != null) {
                IItemStack actualInputA = MineTweakerMC.getIItemStack(is);
                IItemStack actualInputB = MineTweakerMC.getIItemStack(is1);
                return MineTweakerMC.getItemStack(this.function.recipe(this.output, actualInputA, actualInputB));
            }
            return MineTweakerMC.getItemStack(this.output);
        }

        public ItemStack[] getComponents() {
            return this.components;
        }

        public ItemStack[] getExampleInputsA() {
            return this.inputAExamples;
        }

        public ItemStack[] getExampleInputsB() {
            return this.inputBExamples;
        }
    }

    private static class RemoveRecipeAction
    implements IUndoableAction {
        private final IIntegrationRecipeManager.IIntegrationRecipe recipe;

        public RemoveRecipeAction(IIntegrationRecipeManager.IIntegrationRecipe recipe) {
            this.recipe = recipe;
        }

        @Override
        public void apply() {
            BuildcraftRecipes.integrationTable.getRecipes().remove(this.recipe);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            BuildcraftRecipes.integrationTable.addRecipe(this.recipe);
        }

        @Override
        public String describe() {
            return "Removing integration table recipe for " + MineTweakerMC.getIItemStack(this.recipe.getComponents()[0]);
        }

        @Override
        public String describeUndo() {
            return "Restoring integration table recipe for " + MineTweakerMC.getIItemStack(this.recipe.getComponents()[0]);
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        private final MTIntegrationRecipe recipe;

        public AddRecipeAction(IItemStack output, double energy, IIngredient inputA, IIngredient inputB, IIntegrationRecipeFunction function) {
            this.recipe = new MTIntegrationRecipe(output, energy, inputA, inputB, function);
        }

        @Override
        public void apply() {
            BuildcraftRecipes.integrationTable.addRecipe((IIntegrationRecipeManager.IIntegrationRecipe)this.recipe);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            BuildcraftRecipes.integrationTable.getRecipes().remove(this.recipe);
        }

        @Override
        public String describe() {
            return "Adding integration table recipe for " + this.recipe.output;
        }

        @Override
        public String describeUndo() {
            return "Removing integration table recipe for " + this.recipe.output;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

