/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.liquid;

import minetweaker.api.data.IData;
import minetweaker.api.liquid.ILiquidDefinition;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.mc1710.data.NBTConverter;
import minetweaker.mc1710.liquid.MCLiquidDefinition;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class MCLiquidStack
implements ILiquidStack {
    private final FluidStack stack;
    private IData tag = null;

    public MCLiquidStack(FluidStack stack) {
        this.stack = stack;
    }

    private MCLiquidStack(FluidStack stack, IData tag) {
        this.stack = stack;
        this.tag = tag;
    }

    @Override
    public ILiquidDefinition getDefinition() {
        return new MCLiquidDefinition(this.stack.getFluid());
    }

    @Override
    public String getName() {
        return this.stack.getFluid().getName();
    }

    @Override
    public String getDisplayName() {
        return this.stack.getFluid().getLocalizedName();
    }

    @Override
    public int getAmount() {
        return this.stack.amount;
    }

    @Override
    public IData getTag() {
        if (this.tag == null) {
            if (this.stack.tag == null) {
                return null;
            }
            this.tag = NBTConverter.from((NBTBase)this.stack.tag, true);
        }
        return this.tag;
    }

    @Override
    public ILiquidStack withTag(IData data) {
        FluidStack result = new FluidStack(this.stack.fluidID, this.stack.amount);
        result.tag = (NBTTagCompound)NBTConverter.from(data);
        return new MCLiquidStack(result, data.immutable());
    }

    @Override
    public ILiquidStack withAmount(int amount) {
        FluidStack result = new FluidStack(this.stack.fluidID, amount);
        result.tag = this.stack.tag;
        return new MCLiquidStack(result, this.tag);
    }

    @Override
    public int getLuminosity() {
        return this.stack.getFluid().getLuminosity(this.stack);
    }

    @Override
    public int getDensity() {
        return this.stack.getFluid().getDensity(this.stack);
    }

    @Override
    public int getTemperature() {
        return this.stack.getFluid().getTemperature(this.stack);
    }

    @Override
    public int getViscosity() {
        return this.stack.getFluid().getViscosity(this.stack);
    }

    @Override
    public boolean isGaseous() {
        return this.stack.getFluid().isGaseous(this.stack);
    }

    @Override
    public Object getInternal() {
        return this.stack;
    }
}

