/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import minetweaker.MineTweakerAPI;
import minetweaker.api.block.IBlock;
import minetweaker.api.data.DataMap;
import minetweaker.api.data.IData;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemCondition;
import minetweaker.api.item.IItemDefinition;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IItemTransformer;
import minetweaker.api.item.IngredientItem;
import minetweaker.api.item.IngredientOr;
import minetweaker.api.item.WeightedItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.oredict.IOreDictEntry;
import minetweaker.api.player.IPlayer;
import minetweaker.mc1710.actions.SetTranslationAction;
import minetweaker.mc1710.block.MCItemBlock;
import minetweaker.mc1710.data.NBTConverter;
import minetweaker.mc1710.item.MCItemDefinition;
import minetweaker.mc1710.liquid.MCLiquidStack;
import minetweaker.util.ArrayUtil;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class MCItemStack
implements IItemStack {
    private final ItemStack stack;
    private final List<IItemStack> items;
    private IData tag = null;
    private boolean wildcardSize;

    public MCItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            throw new IllegalArgumentException("stack cannot be null");
        }
        this.stack = itemStack.func_77946_l();
        this.items = Collections.singletonList(this);
    }

    public MCItemStack(ItemStack itemStack, boolean wildcardSize) {
        this(itemStack);
        this.wildcardSize = wildcardSize;
    }

    private MCItemStack(ItemStack itemStack, IData tag) {
        if (itemStack == null) {
            throw new IllegalArgumentException("stack cannot be null");
        }
        this.stack = itemStack;
        this.items = Collections.singletonList(this);
        this.tag = tag;
    }

    private MCItemStack(ItemStack itemStack, IData tag, boolean wildcardSize) {
        this.stack = itemStack;
        this.items = Collections.singletonList(this);
        this.tag = tag;
        this.wildcardSize = wildcardSize;
    }

    @Override
    public IItemDefinition getDefinition() {
        return new MCItemDefinition(Item.field_150901_e.func_148750_c((Object)this.stack.func_77973_b()), this.stack.func_77973_b());
    }

    @Override
    public String getName() {
        return this.stack.func_77977_a();
    }

    @Override
    public String getDisplayName() {
        return this.stack.func_82833_r();
    }

    @Override
    public void setDisplayName(String name) {
        MineTweakerAPI.apply(new SetTranslationAction(this.getName() + ".name", name));
    }

    @Override
    public int getDamage() {
        return this.stack.func_77960_j();
    }

    @Override
    public IData getTag() {
        if (this.tag == null) {
            if (this.stack.field_77990_d == null) {
                return DataMap.EMPTY;
            }
            this.tag = NBTConverter.from((NBTBase)this.stack.field_77990_d, true);
        }
        return this.tag;
    }

    @Override
    public int getMaxDamage() {
        return this.stack.func_77958_k();
    }

    @Override
    public ILiquidStack getLiquid() {
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.stack);
        return liquid == null ? null : new MCLiquidStack(liquid);
    }

    @Override
    public IIngredient anyDamage() {
        if (this.stack.func_77973_b().func_77614_k()) {
            MineTweakerAPI.logWarning("subitems don't have damaged states");
            return this;
        }
        ItemStack result = new ItemStack(this.stack.func_77973_b(), this.stack.field_77994_a, Short.MAX_VALUE);
        result.field_77990_d = this.stack.field_77990_d;
        return new MCItemStack(result, this.tag);
    }

    @Override
    public IItemStack withDamage(int damage) {
        if (this.stack.func_77973_b().func_77614_k()) {
            MineTweakerAPI.logWarning("subitems don't have damaged states");
            return this;
        }
        ItemStack result = new ItemStack(this.stack.func_77973_b(), this.stack.field_77994_a, damage);
        result.field_77990_d = this.stack.field_77990_d;
        return new MCItemStack(result, this.tag);
    }

    @Override
    public IItemStack anyAmount() {
        ItemStack result = new ItemStack(this.stack.func_77973_b(), 1, this.stack.func_77960_j());
        result.field_77990_d = this.stack.field_77990_d;
        return new MCItemStack(result, this.tag, true);
    }

    @Override
    public IItemStack withAmount(int amount) {
        ItemStack result = new ItemStack(this.stack.func_77973_b(), amount, this.stack.func_77960_j());
        result.field_77990_d = this.stack.field_77990_d;
        return new MCItemStack(result, this.tag);
    }

    @Override
    public IItemStack withTag(IData tag) {
        ItemStack result = new ItemStack(this.stack.func_77973_b(), this.stack.field_77994_a, this.stack.func_77960_j());
        result.field_77990_d = tag == null ? null : (NBTTagCompound)NBTConverter.from(tag);
        return new MCItemStack(result, tag);
    }

    @Override
    public IItemStack updateTag(IData tagUpdate) {
        if (this.tag == null) {
            if (this.stack.field_77990_d == null) {
                return this.withTag(tagUpdate);
            }
            this.tag = NBTConverter.from((NBTBase)this.stack.field_77990_d, true);
        }
        IData updated = this.tag.update(tagUpdate);
        return this.withTag(updated);
    }

    @Override
    public String getMark() {
        return null;
    }

    @Override
    public int getAmount() {
        return this.stack.field_77994_a;
    }

    @Override
    public List<IItemStack> getItems() {
        return this.items;
    }

    @Override
    public IItemStack amount(int amount) {
        return this.withAmount(amount);
    }

    @Override
    public WeightedItemStack percent(float chance) {
        return new WeightedItemStack(this, chance * 0.01f);
    }

    @Override
    public WeightedItemStack weight(float chance) {
        return new WeightedItemStack(this, chance);
    }

    @Override
    public IIngredient transform(IItemTransformer transformer) {
        return new IngredientItem(this, null, ArrayUtil.EMPTY_CONDITIONS, new IItemTransformer[]{transformer});
    }

    @Override
    public IIngredient only(IItemCondition condition) {
        return new IngredientItem(this, null, new IItemCondition[]{condition}, ArrayUtil.EMPTY_TRANSFORMERS);
    }

    @Override
    public IIngredient marked(String mark) {
        return new IngredientItem(this, mark, ArrayUtil.EMPTY_CONDITIONS, ArrayUtil.EMPTY_TRANSFORMERS);
    }

    @Override
    public IIngredient or(IIngredient ingredient) {
        return new IngredientOr(this, ingredient);
    }

    @Override
    public boolean matches(IItemStack item) {
        ItemStack internal = MineTweakerMC.getItemStack(item);
        return internal.func_77973_b() == this.stack.func_77973_b() && (this.wildcardSize || internal.field_77994_a >= this.stack.field_77994_a) && (this.stack.func_77960_j() == Short.MAX_VALUE || this.stack.func_77960_j() == internal.func_77960_j() || !this.stack.func_77981_g() && !this.stack.func_77973_b().func_77645_m());
    }

    @Override
    public boolean contains(IIngredient ingredient) {
        List<IItemStack> iitems = ingredient.getItems();
        if (iitems == null || iitems.size() != 1) {
            return false;
        }
        return this.matches(iitems.get(0));
    }

    @Override
    public IItemStack applyTransform(IItemStack item, IPlayer byPlayer) {
        return item;
    }

    @Override
    public boolean hasTransformers() {
        return false;
    }

    @Override
    public Object getInternal() {
        return this.stack;
    }

    @Override
    public IBlock asBlock() {
        if (Block.func_149634_a((Item)this.stack.func_77973_b()) == null) {
            throw new ClassCastException("This item is not a block");
        }
        return new MCItemBlock(this.stack);
    }

    @Override
    public List<IOreDictEntry> getOres() {
        ArrayList<IOreDictEntry> result = new ArrayList<IOreDictEntry>();
        block0: for (String key : OreDictionary.getOreNames()) {
            for (ItemStack is : OreDictionary.getOres((String)key)) {
                if (is.func_77973_b() != this.stack.func_77973_b() || is.func_77960_j() != Short.MAX_VALUE && is.func_77960_j() != this.stack.func_77960_j()) continue;
                result.add(MineTweakerAPI.oreDict.get(key));
                continue block0;
            }
        }
        return result;
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + this.stack.func_77973_b().hashCode();
        hash = 41 * hash + this.stack.func_77960_j();
        hash = 41 * hash + this.stack.field_77994_a;
        hash = 41 * hash + (this.stack.field_77990_d == null ? 0 : this.stack.field_77990_d.hashCode());
        hash = 41 * hash + (this.wildcardSize ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MCItemStack other = (MCItemStack)obj;
        if (this.stack.func_77973_b() != other.stack.func_77973_b()) {
            return false;
        }
        if (this.stack.func_77960_j() != other.stack.func_77960_j()) {
            return false;
        }
        if (this.stack.field_77994_a != other.stack.field_77994_a) {
            return false;
        }
        if (this.stack.field_77990_d != other.stack.field_77990_d && (this.stack == null || this.stack.equals(other.stack))) {
            return false;
        }
        return this.wildcardSize == other.wildcardSize;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('<');
        result.append(Item.field_150901_e.func_148750_c((Object)this.stack.func_77973_b()));
        if (this.stack.func_77960_j() == Short.MAX_VALUE) {
            result.append(":*");
        } else if (this.stack.func_77960_j() > 0) {
            result.append(':').append(this.stack.func_77960_j());
        }
        result.append('>');
        if (this.stack.func_77978_p() != null) {
            result.append(".withTag(");
            result.append(NBTConverter.from((NBTBase)this.stack.func_77978_p(), this.wildcardSize).toString());
            result.append(")");
        }
        if (!this.wildcardSize) {
            result.append(" * ").append(this.stack.field_77994_a);
        }
        return result.toString();
    }
}

