/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.recipe;

import java.util.ArrayList;
import java.util.List;
import mods.defeatedcrow.api.recipe.ICookingHeatSource;
import mods.defeatedcrow.api.recipe.IPlateRecipe;
import mods.defeatedcrow.api.recipe.IPlateRecipeRegister;
import mods.defeatedcrow.api.recipe.RecipeRegisterManager;
import mods.defeatedcrow.common.AMTLogger;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PlateRecipeRegister
implements IPlateRecipeRegister {
    private static List<PlateRecipe> recipes;
    @Deprecated
    private static List<ItemStack> heatSource;
    private static List<HeatSource> sources;

    public PlateRecipeRegister() {
        recipes = new ArrayList<PlateRecipe>();
        heatSource = new ArrayList<ItemStack>();
        sources = new ArrayList<HeatSource>();
    }

    public List<PlateRecipe> getRecipeList() {
        return recipes;
    }

    @Override
    public List<ItemStack> getHeatSourceList() {
        return heatSource;
    }

    public List<HeatSource> getHeatSourcesList() {
        return sources;
    }

    public IPlateRecipeRegister instance() {
        return RecipeRegisterManager.plateRecipe;
    }

    @Override
    public PlateRecipe getRecipe(ItemStack item) {
        if (item == null) {
            return null;
        }
        for (PlateRecipe recipe : recipes) {
            if (!this.isItemEqual(item, recipe.getInput().func_77973_b(), recipe.getInput().func_77960_j())) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public boolean isHeatSource(Block block, int meta) {
        if (block == null) {
            return false;
        }
        for (HeatSource source : sources) {
            if (block != source.block || source.metadata != -1 && source.metadata != meta) continue;
            return true;
        }
        return false;
    }

    private boolean isItemEqual(ItemStack a, Item b, int meta) {
        if (a == null) {
            return false;
        }
        boolean flag = false;
        if (a.func_77973_b() == b) {
            if (a.func_77960_j() == meta) {
                flag = true;
            } else if (a.func_77960_j() == Short.MAX_VALUE) {
                flag = true;
            }
        }
        return flag;
    }

    @Override
    public void register(ItemStack input, ItemStack output, int time, boolean isOven) {
        if (input != null && output != null) {
            recipes.add(new PlateRecipe(input, output, time, isOven));
            AMTLogger.debugInfo("Add Plate Recipe: input " + input.func_82833_r() + ", output " + output.func_82833_r());
        }
    }

    @Override
    public void registerHeatSource(Block block, int meta) {
        if (block != null) {
            sources.add(new HeatSource(block, meta));
            AMTLogger.debugInfo("Add plate heat source : " + block.func_149732_F() + ":" + meta);
        }
    }

    public class HeatSource
    implements ICookingHeatSource {
        private final Block block;
        private final int metadata;

        public HeatSource(Block b, int m) {
            this.block = b;
            this.metadata = m;
        }

        @Override
        public Block getBlock() {
            return this.block;
        }

        @Override
        public int getMetadata() {
            return this.metadata;
        }
    }

    public class PlateRecipe
    implements IPlateRecipe {
        private final ItemStack input;
        private final ItemStack output;
        private final int cookTime;
        private final boolean isOven;

        public PlateRecipe(ItemStack inputItem, ItemStack outputItem, int time, boolean flag) {
            this.input = inputItem;
            this.output = outputItem;
            this.cookTime = time;
            this.isOven = flag;
        }

        @Override
        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        @Override
        public ItemStack getOutput() {
            if (this.output == null) {
                return null;
            }
            return this.output.func_77946_l();
        }

        @Override
        public int cookingTime() {
            return this.cookTime;
        }

        @Override
        public boolean useOvenRecipe() {
            return this.isOven;
        }
    }
}

