/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.recipe;

import java.util.ArrayList;
import java.util.List;
import mods.defeatedcrow.api.recipe.IChargeIce;
import mods.defeatedcrow.api.recipe.IIceRecipe;
import mods.defeatedcrow.api.recipe.IIceRecipeRegister;
import mods.defeatedcrow.api.recipe.RecipeRegisterManager;
import mods.defeatedcrow.common.AMTLogger;
import net.minecraft.item.ItemStack;

public class IceRecipeRegister
implements IIceRecipeRegister {
    private static List<IceRecipe> recipes;
    private static List<ChargeIceItem> chargeItems;

    public IceRecipeRegister() {
        recipes = new ArrayList<IceRecipe>();
        chargeItems = new ArrayList<ChargeIceItem>();
    }

    public IIceRecipeRegister instance() {
        return RecipeRegisterManager.iceRecipe;
    }

    public List<IceRecipe> getRecipeList() {
        return recipes;
    }

    public List<ChargeIceItem> getChargeItemList() {
        return chargeItems;
    }

    @Override
    public IceRecipe getRecipe(ItemStack item) {
        if (item == null) {
            return null;
        }
        for (IceRecipe recipe : recipes) {
            if (!this.isItemEqual(item, recipe.getInput())) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public int getChargeAmount(ItemStack item) {
        if (item == null) {
            return 0;
        }
        for (ChargeIceItem chargeable : chargeItems) {
            if (!this.isItemEqual(item, chargeable.getItem())) continue;
            return chargeable.chargeAmount();
        }
        return 0;
    }

    private boolean isItemEqual(ItemStack a, ItemStack b) {
        boolean flag = false;
        if (a.func_77973_b() == b.func_77973_b()) {
            if (a.func_77960_j() == b.func_77960_j()) {
                flag = true;
            } else if (b.func_77960_j() == Short.MAX_VALUE) {
                flag = true;
            }
        }
        return flag;
    }

    @Override
    public void register(ItemStack input, ItemStack output) {
        if (input != null) {
            this.registerCanLeave(input, output, null);
        }
    }

    @Override
    public void registerCanLeave(ItemStack input, ItemStack output, ItemStack leaveStack) {
        if (input != null) {
            recipes.add(new IceRecipe(input, output, leaveStack));
        }
        String container = "null";
        if (leaveStack != null) {
            container = leaveStack.func_82833_r();
        }
        AMTLogger.debugInfo("Add IceMaker Recipe: input " + input.func_82833_r() + ", output " + output.func_82833_r() + ", container " + container);
    }

    @Override
    public void registerCharger(ItemStack input, int val) {
        if (input != null && val > 0) {
            chargeItems.add(new ChargeIceItem(input, val));
        }
        AMTLogger.debugInfo("Add IceMaker chargeable item: input " + input.func_82833_r() + ", amount " + val);
    }

    public class ChargeIceItem
    implements IChargeIce {
        private final ItemStack input;
        private final int amount;

        public ChargeIceItem(ItemStack item, int val) {
            this.input = item;
            this.amount = val;
        }

        @Override
        public int chargeAmount() {
            return this.amount;
        }

        @Override
        public ItemStack getItem() {
            if (this.input == null) {
                return null;
            }
            return this.input;
        }
    }

    public class IceRecipe
    implements IIceRecipe {
        private final ItemStack input;
        private final ItemStack output;
        private final ItemStack container;
        private final int damage = Short.MAX_VALUE;

        public IceRecipe(ItemStack inputItem, ItemStack outputItem, ItemStack containerItem) {
            this.input = inputItem;
            this.output = outputItem;
            this.container = containerItem;
        }

        @Override
        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        @Override
        public ItemStack getOutput() {
            if (this.output == null) {
                return null;
            }
            return this.output.func_77946_l();
        }

        @Override
        public ItemStack getContainer() {
            if (this.container == null) {
                return null;
            }
            return this.container.func_77946_l();
        }
    }
}

