/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.plugin.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mods.defeatedcrow.api.appliance.SoupType;
import mods.defeatedcrow.api.recipe.RecipeRegisterManager;
import mods.defeatedcrow.common.DCsAppleMilk;
import mods.defeatedcrow.plugin.nei.GuiAppliance;
import mods.defeatedcrow.recipe.FondueRecipeRegister;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class FondueRecipeHandler
extends TemplateRecipeHandler {
    private List<FondueRecipeRegister.FondueRecipe> fondueRecipes;

    private List<FondueRecipeRegister.FondueRecipe> recipeLoader() {
        this.fondueRecipes = new ArrayList<FondueRecipeRegister.FondueRecipe>();
        if (RecipeRegisterManager.fondueRecipe.getRecipeList() != null && !RecipeRegisterManager.fondueRecipe.getRecipeList().isEmpty()) {
            this.fondueRecipes = RecipeRegisterManager.fondueRecipe.getRecipeList();
        }
        return this.fondueRecipes;
    }

    public PositionedStack getResult() {
        return null;
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiAppliance.class;
    }

    public String getOverlayIdentifier() {
        return "DCsFondueRecipe";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(62, 8, 20, 20), "DCsFondueRecipe", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("DCsFondueRecipe") && ((Object)((Object)this)).getClass() == FondueRecipeHandler.class) {
            List<FondueRecipeRegister.FondueRecipe> recipes = this.recipeLoader();
            if (recipes == null || recipes.isEmpty()) {
                return;
            }
            for (FondueRecipeRegister.FondueRecipe recipe : recipes) {
                SoupType bef = recipe.getType();
                ItemStack out = recipe.getOutput();
                ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
                inputs.addAll(recipe.getProcessedInput());
                if (inputs.isEmpty() || out == null) continue;
                this.arecipes.add(new RecipeCacher(inputs, bef, out));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List<FondueRecipeRegister.FondueRecipe> recipes = this.recipeLoader();
        if (recipes == null || recipes.isEmpty()) {
            return;
        }
        for (FondueRecipeRegister.FondueRecipe recipe : recipes) {
            SoupType bef = recipe.getType();
            ItemStack out = recipe.getOutput();
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
            inputs.addAll(recipe.getProcessedInput());
            if (inputs.isEmpty() || out == null || !NEIServerUtils.areStacksSameType((ItemStack)out, (ItemStack)result)) continue;
            this.arecipes.add(new RecipeCacher(inputs, bef, out));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<FondueRecipeRegister.FondueRecipe> recipes = this.recipeLoader();
        if (recipes == null || recipes.isEmpty()) {
            return;
        }
        for (FondueRecipeRegister.FondueRecipe recipe : recipes) {
            SoupType bef = recipe.getType();
            ItemStack out = recipe.getOutput();
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
            inputs.addAll(recipe.getProcessedInput());
            boolean flag = this.contain(inputs, ingredient);
            if (flag && !inputs.isEmpty()) {
                RecipeCacher cache = new RecipeCacher(inputs, bef, out);
                cache.setIngredientPermutation(cache.input, ingredient);
                this.arecipes.add(cache);
                continue;
            }
            if (!inputs.isEmpty() && ingredient.func_77973_b() == Item.func_150898_a((Block)DCsAppleMilk.filledSoupPan) && ingredient.func_77960_j() == bef.id) {
                this.arecipes.add(new RecipeCacher(inputs, bef, out));
                continue;
            }
            if (inputs.isEmpty() || ingredient.func_77973_b() != Item.func_150898_a((Block)DCsAppleMilk.emptyPanGaiden) || bef.id != 0) continue;
            this.arecipes.add(new RecipeCacher(inputs, bef, out));
        }
    }

    private boolean contain(List<ItemStack> inputs, ItemStack check) {
        boolean flag1 = false;
        if (check == null) {
            return false;
        }
        for (ItemStack ret : inputs) {
            if (ret == null || !NEIServerUtils.areStacksSameType((ItemStack)ret, (ItemStack)check)) continue;
            flag1 = true;
        }
        return flag1;
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"dc.FondueRecipeGuiNEI");
    }

    public String getGuiTexture() {
        return "defeatedcrow:textures/gui/appliancegui_nei.png";
    }

    public void drawExtras(int recipe) {
        Minecraft mc = Minecraft.func_71410_x();
        String d = "Use by Right-Click";
        mc.field_71466_p.func_78276_b(I18n.func_135052_a((String)d, (Object[])new Object[0]), 82, 13, 0);
    }

    public class RecipeCacher
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> input;
        private PositionedStack result;
        private PositionedStack type;

        public RecipeCacher() {
            super((TemplateRecipeHandler)FondueRecipeHandler.this);
            this.input = new ArrayList();
        }

        public RecipeCacher(List<ItemStack> input, SoupType bef, ItemStack res) {
            this();
            this.setInput(input);
            ItemStack item = null;
            item = bef != SoupType.EMPTY ? new ItemStack(DCsAppleMilk.filledSoupPan, 1, bef.id) : new ItemStack(DCsAppleMilk.emptyPanGaiden, 1, 0);
            if (res != null) {
                this.result = new PositionedStack((Object)res, 118, 33);
            }
            if (item != null) {
                this.type = new PositionedStack((Object)item, 77, 33);
            }
        }

        public void setInput(List<ItemStack> items) {
            this.input.clear();
            PositionedStack stack = new PositionedStack(items, 40, 8);
            stack.setMaxSize(1);
            this.input.add(stack);
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(FondueRecipeHandler.this.cycleticks / 20, this.input);
        }

        public PositionedStack getOtherStack() {
            return this.type;
        }
    }
}

