/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.plugin.ffm;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.vect.Vect;
import mods.defeatedcrow.api.plants.IRightClickHarvestable;
import mods.defeatedcrow.plugin.ffm.CropAMTPlants;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FarmableAMT
implements IFarmable {
    private final Block block;
    private final int matureMeta;

    public FarmableAMT(Block block, int matureMeta) {
        this.block = block;
        this.matureMeta = matureMeta;
    }

    public boolean isSaplingAt(World world, int x, int y, int z) {
        if (this.block instanceof IRightClickHarvestable) {
            Block sap = ((IRightClickHarvestable)this.block).getSaplingBlock(this.matureMeta);
            int sapMeta = ((IRightClickHarvestable)this.block).getSaplingMeta(this.matureMeta);
            return world.func_147439_a(x, y, z) == sap && world.func_72805_g(x, y, z) == sapMeta;
        }
        return false;
    }

    public ICrop getCropAt(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != this.block) {
            return null;
        }
        if (world.func_72805_g(x, y, z) != this.matureMeta) {
            return null;
        }
        return new CropAMTPlants(world, this.block, this.matureMeta, new Vect(x, y, z));
    }

    public boolean isGermling(ItemStack stack) {
        if (this.block instanceof IRightClickHarvestable && stack != null && stack.func_77973_b() instanceof ItemBlock) {
            Block sap = ((IRightClickHarvestable)this.block).getSaplingBlock(this.matureMeta);
            int sapMeta = ((IRightClickHarvestable)this.block).getSaplingMeta(this.matureMeta);
            return stack.func_77973_b() == Item.func_150898_a((Block)sap) && stack.func_77960_j() == sapMeta;
        }
        return false;
    }

    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }

    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, int x, int y, int z) {
        if (this.block instanceof IRightClickHarvestable) {
            Block sap = ((IRightClickHarvestable)this.block).getSaplingBlock(this.matureMeta);
            int sapMeta = ((IRightClickHarvestable)this.block).getSaplingMeta(this.matureMeta);
            return world.func_147465_d(x, y, z, sap, sapMeta, 2);
        }
        return false;
    }
}

