/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.common.tile.energy;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.tileentity.IEnergyInfo;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.Optional;
import mods.defeatedcrow.common.config.PropertyHandler;
import mods.defeatedcrow.common.tile.energy.TileChargerBase;
import mods.defeatedcrow.plugin.IC2.EUItemHandler;
import mods.defeatedcrow.plugin.IC2.EUSinkManager;
import mods.defeatedcrow.plugin.IC2.IEUSinkChannel;
import mods.defeatedcrow.plugin.SSector.SS2ItemHandler;
import mods.defeatedcrow.plugin.cofh.RFItemHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import shift.sextiarysector.api.gearforce.tileentity.IGearForceHandler;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.energy.IEnergyHandler", modid="CoFHAPI|energy"), @Optional.Interface(iface="cofh.api.tileentity.IEnergyInfo", modid="CoFHAPI|tileentity"), @Optional.Interface(iface="shift.sextiarysector.api.gearforce.tileentity.IGearForceHandler", modid="SextiarySector")})
public class TileChargerDevice
extends TileChargerBase
implements IEnergyHandler,
IEnergyInfo,
IGearForceHandler {
    protected IEUSinkChannel EUChannel;

    public TileChargerDevice() {
        if (Loader.isModLoaded((String)"IC2")) {
            this.EUChannel = EUSinkManager.getChannel(this, 128000, 3);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        if (this.EUChannel != null) {
            this.EUChannel.readFromNBT2(par1NBTTagCompound);
        }
        super.func_145839_a(par1NBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        if (this.EUChannel != null) {
            this.EUChannel.writeToNBT2(par1NBTTagCompound);
        }
        super.func_145841_b(par1NBTTagCompound);
    }

    @Override
    public Packet func_145844_m() {
        return super.func_145844_m();
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
    }

    private static int exchangeRateRF() {
        return PropertyHandler.rateRF();
    }

    private static int exchangeRateEU() {
        return PropertyHandler.rateEU();
    }

    private static int exchangeRateGF() {
        return PropertyHandler.rateGF();
    }

    @Override
    public boolean isChargeableBattery(ItemStack item) {
        boolean flag = false;
        if (Loader.isModLoaded((String)"SextiarySector")) {
            flag = SS2ItemHandler.isGFItem(item);
        }
        if (ModAPIManager.INSTANCE.hasAPI("CoFHAPI|energy") && !flag) {
            flag = RFItemHandler.isChargeable(item);
        }
        if (!flag && Loader.isModLoaded((String)"IC2") && !flag) {
            flag = EUItemHandler.isChargeable(item);
        }
        return flag;
    }

    @Override
    public int chargeAnotherBattery(ItemStack item, int inc, boolean flag) {
        int i;
        int ret = 0;
        if (Loader.isModLoaded((String)"SextiarySector")) {
            i = SS2ItemHandler.chargeAmount(item, inc * this.exchangeRateGF(), flag);
            ret = Math.round(i / this.exchangeRateGF());
        }
        if (ModAPIManager.INSTANCE.hasAPI("CoFHAPI|energy") && ret == 0) {
            i = RFItemHandler.chargeAmount(item, inc * this.exchangeRateRF(), flag);
            ret = Math.round(i / this.exchangeRateRF());
        }
        if (Loader.isModLoaded((String)"IC2") && ret == 0) {
            i = EUItemHandler.chargeAmount(item, inc * this.exchangeRateEU(), flag);
            ret = Math.round(i / this.exchangeRateEU());
        }
        return ret;
    }

    @Override
    public int acceptChargeFromDir(ForgeDirection dir) {
        int ret = 0;
        if (this.EUChannel != null) {
            int i = this.getChargeAmount();
            double eu = Math.min(this.EUChannel.getEnergyStored2(), 512.0);
            double get = eu / (double)this.exchangeRateEU();
            if ((double)(128000 - i) < get) {
                return 0;
            }
            if (this.EUChannel.useEnergy2(eu)) {
                ret = (int)get;
            }
        }
        if (ret == 0) {
            return super.acceptChargeFromDir(dir);
        }
        return ret;
    }

    @Override
    public int getItemBurnTime(ItemStack item) {
        int i;
        if (item == null) {
            return 0;
        }
        int ret = 0;
        int inc = 16;
        if (Loader.isModLoaded((String)"SextiarySector") && ret == 0) {
            i = SS2ItemHandler.dischargeAmount(item, inc * TileChargerDevice.exchangeRateGF(), true);
            ret = Math.round(i / TileChargerDevice.exchangeRateGF());
        }
        if (ModAPIManager.INSTANCE.hasAPI("CoFHAPI|energy") && ret == 0) {
            i = RFItemHandler.dischargeAmount(item, inc * TileChargerDevice.exchangeRateRF(), true);
            ret = Math.round(i / TileChargerDevice.exchangeRateRF());
        }
        if (Loader.isModLoaded((String)"IC2") && ret == 0) {
            i = EUItemHandler.dischargeAmount(item, inc * TileChargerDevice.exchangeRateEU(), true);
            ret = Math.round(i / TileChargerDevice.exchangeRateEU());
        }
        if (ret == 0) {
            return super.getItemBurnTime(item);
        }
        return ret;
    }

    @Override
    public int discharge(ItemStack item, int amount, int slot) {
        int i;
        if (item == null) {
            return 0;
        }
        int ret = 0;
        int inc = amount;
        if (Loader.isModLoaded((String)"SextiarySector") && ret == 0 && (ret = Math.round((i = SS2ItemHandler.dischargeAmount(item, inc * TileChargerDevice.exchangeRateGF(), false)) / TileChargerDevice.exchangeRateGF())) > 0 && SS2ItemHandler.getAmount(item) == 0 && this.itemstacks[1] == null) {
            if (item == null || item.field_77994_a == 0) {
                this.func_70299_a(0, null);
            } else {
                this.func_70299_a(1, item.func_77946_l());
                this.func_70298_a(slot, 1);
            }
        }
        if (ModAPIManager.INSTANCE.hasAPI("CoFHAPI|energy") && ret == 0 && (ret = Math.round((i = RFItemHandler.dischargeAmount(item, inc * TileChargerDevice.exchangeRateRF(), false)) / TileChargerDevice.exchangeRateRF())) > 0 && RFItemHandler.getAmount(item) == 0 && this.itemstacks[1] == null) {
            if (item == null || item.field_77994_a == 0) {
                this.func_70299_a(0, null);
            } else {
                this.func_70299_a(1, item.func_77946_l());
                this.func_70298_a(slot, 1);
            }
        }
        if (Loader.isModLoaded((String)"IC2") && ret == 0 && (ret = Math.round((i = EUItemHandler.dischargeAmount(item, inc * TileChargerDevice.exchangeRateEU(), false)) / TileChargerDevice.exchangeRateEU())) > 0 && EUItemHandler.getAmount(item) == 0 && this.itemstacks[1] == null) {
            if (item == null || item.field_77994_a == 0) {
                this.func_70299_a(0, null);
            } else {
                this.func_70299_a(1, item.func_77946_l());
                this.func_70298_a(slot, 1);
            }
        }
        if (ret == 0) {
            this.func_70298_a(slot, 1);
            ret = super.getItemBurnTime(item);
        }
        return ret;
    }

    public void func_145843_s() {
        if (this.EUChannel != null) {
            this.EUChannel.invalidate2();
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (this.EUChannel != null) {
            this.EUChannel.onChunkUnload2();
        }
        super.onChunkUnload();
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.EUChannel != null) {
            this.EUChannel.updateEntity2();
        }
        super.func_145845_h();
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public boolean canConnectEnergy(ForgeDirection dir) {
        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
        boolean flag = tile instanceof IEnergyConnection;
        return flag;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int receiveEnergy(ForgeDirection dir, int in, boolean flag) {
        int get;
        int eng;
        block5: {
            block4: {
                eng = this.getChargeAmount();
                get = in;
                if (this.isFullCharged()) break block4;
                if (get >= this.exchangeRateRF()) break block5;
            }
            return 0;
        }
        int ret = Math.min((this.getMaxChargeAmount() - eng) * this.exchangeRateRF(), get);
        if (!flag) {
            int i = Math.round(ret / this.exchangeRateRF());
            this.setChargeAmount(eng + i);
        }
        return ret;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int extractEnergy(ForgeDirection paramForgeDirection, int paramInt, boolean paramBoolean) {
        return 0;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getEnergyStored(ForgeDirection paramForgeDirection) {
        return this.getChargeAmount() * this.exchangeRateRF();
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getMaxEnergyStored(ForgeDirection paramForgeDirection) {
        return this.getMaxChargeAmount() * this.exchangeRateRF();
    }

    @Optional.Method(modid="CoFHAPI|tileentity")
    public int getInfoEnergyPerTick() {
        return 0;
    }

    @Optional.Method(modid="CoFHAPI|tileentity")
    public int getInfoMaxEnergyPerTick() {
        return 0;
    }

    @Optional.Method(modid="CoFHAPI|tileentity")
    public int getInfoEnergyStored() {
        int eng = this.getChargeAmount();
        int get = eng * this.exchangeRateRF();
        return get;
    }

    @Optional.Method(modid="CoFHAPI|tileentity")
    public int getInfoMaxEnergyStored() {
        int eng = this.getMaxChargeAmount();
        int get = eng * this.exchangeRateRF();
        return get;
    }

    @Optional.Method(modid="SextiarySector")
    public int addEnergy(ForgeDirection from, int power, int speed, boolean simulate) {
        int eng = this.getChargeAmount();
        int get = speed;
        if (this.isFullCharged() || power < 3) {
            return 0;
        }
        if (get < this.exchangeRateGF()) {
            get = 3;
        }
        int ret = Math.min((this.getMaxChargeAmount() - eng) * this.exchangeRateGF(), get);
        if (!simulate) {
            int i = Math.round(1.0f * (float)ret / (float)this.exchangeRateGF());
            this.setChargeAmount(eng + i);
        }
        return ret;
    }

    @Optional.Method(modid="SextiarySector")
    public int drawEnergy(ForgeDirection from, int power, int speed, boolean simulate) {
        return 0;
    }

    @Optional.Method(modid="SextiarySector")
    public boolean canInterface(ForgeDirection from) {
        return true;
    }

    @Optional.Method(modid="SextiarySector")
    public int getSpeedStored(ForgeDirection from) {
        int eng = this.getChargeAmount();
        int get = eng * this.exchangeRateGF();
        return get;
    }

    @Optional.Method(modid="SextiarySector")
    public int getPowerStored(ForgeDirection from) {
        return 0;
    }

    @Optional.Method(modid="SextiarySector")
    public int getMaxSpeedStored(ForgeDirection from) {
        int eng = this.getMaxChargeAmount();
        int get = eng * this.exchangeRateGF();
        return get;
    }

    @Optional.Method(modid="SextiarySector")
    public int getMaxPowerStored(ForgeDirection from) {
        return 3;
    }
}

