/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.common.tile.appliance;

import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cpw.mods.fml.common.Optional;
import mods.defeatedcrow.api.recipe.IPlateRecipe;
import mods.defeatedcrow.api.recipe.RecipeRegisterManager;
import mods.defeatedcrow.common.AMTLogger;
import mods.defeatedcrow.common.DCsAppleMilk;
import mods.defeatedcrow.common.config.DCsConfig;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="buildcraft.api.transport.IPipeConnection", modid="BuildCraft|Core")})
public class TileTeppanII
extends TileEntity
implements ISidedInventory,
IPipeConnection {
    private int cookTime = 0;
    private int cookFinishTime = 0;
    private int cookFailTime = 0;
    private boolean fisnished = false;
    private boolean failed = false;
    private int lastAmount = 0;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{1, 2};
    private static final int[] slots_sides = new int[]{0, 1, 2};
    public ItemStack[] plateItems = new ItemStack[3];

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("Items", 10);
        this.plateItems = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.plateItems.length) continue;
            this.plateItems[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.cookTime = par1NBTTagCompound.func_74765_d("CookTime");
        this.cookFinishTime = par1NBTTagCompound.func_74765_d("FinTime");
        this.cookFailTime = par1NBTTagCompound.func_74765_d("FailTime");
        this.fisnished = par1NBTTagCompound.func_74767_n("finish");
        this.failed = par1NBTTagCompound.func_74767_n("fail");
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74777_a("CookTime", (short)this.cookTime);
        par1NBTTagCompound.func_74777_a("FinishTime", (short)this.cookFinishTime);
        par1NBTTagCompound.func_74777_a("FailTime", (short)this.cookFailTime);
        par1NBTTagCompound.func_74757_a("finish", this.fisnished);
        par1NBTTagCompound.func_74757_a("fail", this.failed);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.plateItems.length; ++i) {
            if (this.plateItems[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.plateItems[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_145841_b(nbtTagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean isFinishCooking() {
        return this.fisnished && !this.failed && this.plateItems[1] != null;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public boolean isReadyToCook() {
        return !this.fisnished && !this.failed && this.plateNoHoldingItem();
    }

    public void refreshPlate() {
        this.fisnished = false;
        this.failed = false;
        this.func_70299_a(0, null);
        this.func_70299_a(1, null);
        this.func_70299_a(2, null);
        this.cookTime = 0;
        this.setCookFinishTime(0);
        this.func_70296_d();
    }

    public void updatePlate() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, DCsAppleMilk.teppanII);
        this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, DCsAppleMilk.teppanII);
        this.func_70296_d();
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public void setCookTime(int par1) {
        this.cookTime = par1;
    }

    public int getCookFinishTime() {
        return this.cookFinishTime;
    }

    public void setCookFinishTime(int par1) {
        int i = DCsConfig.teppannRandomCookTime ? this.field_145850_b.field_73012_v.nextInt(par1 + 1) : par1;
        int k = DCsConfig.teppannReadyTime > 0 ? par1 + DCsConfig.teppannReadyTime : par1 * 2;
        this.cookFinishTime = i;
        this.cookFailTime = k;
    }

    public int getCookFailTime() {
        return this.cookFailTime;
    }

    public boolean plateNoHoldingItem() {
        return this.plateItems[0] == null && this.plateItems[1] == null && this.plateItems[2] == null;
    }

    public boolean canSetRecipe(ItemStack item) {
        if (!this.plateNoHoldingItem()) {
            return false;
        }
        if (item == null) {
            return false;
        }
        IPlateRecipe recipe = RecipeRegisterManager.plateRecipe.getRecipe(item);
        return recipe != null;
    }

    public boolean setRecipe(ItemStack item) {
        if (!this.plateNoHoldingItem()) {
            return false;
        }
        if (item == null) {
            return false;
        }
        IPlateRecipe recipe = RecipeRegisterManager.plateRecipe.getRecipe(item);
        if (recipe != null) {
            this.func_70299_a(0, item);
            this.setCookFinishTime(recipe.cookingTime());
            return true;
        }
        return false;
    }

    public boolean isOnHeatSource() {
        if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) {
            return false;
        }
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (block != null) {
            AMTLogger.debugInfo("Current block : " + block.func_149739_a() + ":" + meta);
            return RecipeRegisterManager.plateRecipe.isHeatSource(block, meta);
        }
        AMTLogger.debugInfo("Current block is null");
        return false;
    }

    public boolean isOvenMode() {
        int count = 0;
        boolean b = false;
        if (this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            for (int i = 0; i < 3; ++i) {
                if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 1 + i, this.field_145849_e) || this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1 + i, this.field_145849_e).func_149688_o() == Material.field_151586_h) continue;
                b = true;
            }
            return false;
        }
        b = true;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int z;
            int y;
            int x;
            Block block;
            if (dir == ForgeDirection.DOWN || dir == ForgeDirection.UP || (block = this.field_145850_b.func_147439_a(x = this.field_145851_c + dir.offsetX, y = this.field_145848_d, z = this.field_145849_e + dir.offsetZ)) == null || this.field_145850_b.func_147437_c(x, y, z)) continue;
            if (block.func_149688_o() == Material.field_151586_h || block.func_149688_o() != Material.field_151579_a) {
                // empty if block
            }
            ++count;
        }
        return b && count >= 3;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.onServerUpdate();
        }
        if (!this.plateNoHoldingItem()) {
            IPlateRecipe recipe;
            if (DCsConfig.teppannHardMode && this.cookFailTime > 0 && this.cookTime > this.cookFailTime && this.plateItems[1] != null) {
                this.func_70299_a(1, null);
                this.func_70299_a(2, new ItemStack(DCsAppleMilk.clam, 1, 2));
                this.failed = true;
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "random.fizz", 1.0f, 1.0f);
                this.updatePlate();
            }
            if (this.cookFinishTime > 0 && this.cookTime > this.cookFinishTime && !this.fisnished && this.plateItems[0] != null && this.plateItems[1] == null && (recipe = RecipeRegisterManager.plateRecipe.getRecipe(this.plateItems[0])) != null && recipe.getOutput() != null) {
                ItemStack ret = recipe.getOutput();
                ret.field_77994_a = 1;
                this.func_70299_a(0, null);
                this.func_70299_a(1, ret);
                this.fisnished = true;
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "random.fizz", 1.0f, 1.0f);
                this.updatePlate();
            }
            if (this.plateItems[0] != null && this.isOnHeatSource() && this.plateItems[1] == null) {
                boolean cooking = false;
                IPlateRecipe recipe2 = RecipeRegisterManager.plateRecipe.getRecipe(this.plateItems[0]);
                if (recipe2 != null) {
                    cooking = true;
                    if (this.cookFinishTime == 0) {
                        this.setCookFinishTime(recipe2.cookingTime());
                    }
                }
                if (recipe2.useOvenRecipe() && cooking) {
                    cooking = this.isOvenMode();
                }
                if (cooking) {
                    ++this.cookTime;
                }
            }
        } else if (this.fisnished || this.failed) {
            this.refreshPlate();
        }
    }

    private void onServerUpdate() {
        int itemCount = 0;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            itemCount += this.func_70301_a(i).func_82833_r().length();
        }
        if (this.lastAmount != itemCount) {
            this.lastAmount = itemCount;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public int func_70302_i_() {
        return this.plateItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        par1 = MathHelper.func_76125_a((int)par1, (int)0, (int)this.func_70302_i_());
        return this.plateItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.plateItems[par1 = MathHelper.func_76125_a((int)par1, (int)0, (int)this.func_70302_i_())] != null) {
            ItemStack itemstack = null;
            if (this.plateItems[par1].field_77994_a <= par2) {
                itemstack = this.plateItems[par1];
                this.plateItems[par1] = null;
                return itemstack;
            }
            itemstack = this.plateItems[par1].func_77979_a(par2);
            if (this.plateItems[par1].field_77994_a == 0) {
                this.plateItems[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.plateItems[par1 = MathHelper.func_76125_a((int)par1, (int)0, (int)this.func_70302_i_())] != null) {
            ItemStack itemstack = this.plateItems[par1];
            this.plateItems[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        if (par1 > 2) {
            par1 = 0;
        }
        this.plateItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "Teppan";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return par1 == 0 ? !this.fisnished && this.canSetRecipe(par2ItemStack) : false;
    }

    public int[] func_94128_d(int par1) {
        return par1 == 0 ? slots_bottom : (par1 == 1 ? slots_top : slots_sides);
    }

    public boolean func_102007_a(int par1, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    public boolean func_102008_b(int par1, ItemStack par2ItemStack, int par3) {
        return par1 != 0;
    }

    @Optional.Method(modid="BuildCraft|Core")
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return IPipeConnection.ConnectOverride.DISCONNECT;
    }
}

