/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.common.tile.appliance;

import mods.defeatedcrow.api.appliance.ITeaMaker;
import mods.defeatedcrow.api.recipe.ITeaRecipe;
import mods.defeatedcrow.api.recipe.RecipeRegisterManager;
import mods.defeatedcrow.common.DCsAppleMilk;
import mods.defeatedcrow.handler.Util;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileMakerNext
extends TileEntity
implements ITeaMaker {
    private byte remain = 1;
    private byte contentsID = 0;
    private boolean isMilk = false;
    private ItemStack input = null;
    private String tex = "defeatedcrow:textures/blocks/contents_water.png";
    private String tex_milk = "defeatedcrow:textures/blocks/contents_water.png";
    private byte coolTime = 0;

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74764_b("Input")) {
            this.setItemStack(ItemStack.func_77949_a((NBTTagCompound)par1NBTTagCompound.func_74775_l("Input")));
        }
        this.remain = par1NBTTagCompound.func_74771_c("Remaining");
        this.isMilk = par1NBTTagCompound.func_74767_n("Milk");
        this.tex = par1NBTTagCompound.func_74779_i("Tex");
        this.tex_milk = par1NBTTagCompound.func_74779_i("Tex_Milk");
        this.coolTime = par1NBTTagCompound.func_74771_c("CoolTime");
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74774_a("Remaining", this.remain);
        par1NBTTagCompound.func_74757_a("Milk", this.isMilk);
        par1NBTTagCompound.func_74778_a("Tex", this.tex);
        par1NBTTagCompound.func_74778_a("Tex_Milk", this.tex_milk);
        par1NBTTagCompound.func_74774_a("CoolTime", this.coolTime);
        if (this.getItemStack() != null) {
            par1NBTTagCompound.func_74782_a("Input", (NBTBase)this.getItemStack().func_77955_b(new NBTTagCompound()));
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_145841_b(nbtTagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public ITeaRecipe getRecipe() {
        if (Util.notEmptyItem(this.input)) {
            return RecipeRegisterManager.teaRecipe.getRecipe(this.input);
        }
        return null;
    }

    @Override
    public void setRecipe(ItemStack item) {
        this.input = item;
        this.setTexture(item);
        this.setRemain((byte)(3 + this.field_145850_b.field_73012_v.nextInt(3)));
        this.updateTeaMaker();
    }

    @Override
    public byte getRemain() {
        return this.remain;
    }

    @Override
    public void setRemain(byte par1) {
        this.remain = par1;
    }

    @Override
    public boolean getMilked() {
        return this.isMilk;
    }

    @Override
    public void setMilk(boolean flag) {
        this.isMilk = flag;
        this.remain = (byte)3;
        this.updateTeaMaker();
    }

    @Override
    public ItemStack getOutput() {
        ITeaRecipe recipe;
        if (this.input != null && (recipe = RecipeRegisterManager.teaRecipe.getRecipe(this.input)) != null) {
            if (this.isMilk && recipe.getOutputMilk() != null) {
                return recipe.getOutputMilk();
            }
            return recipe.getOutput();
        }
        return null;
    }

    @Override
    public boolean canSetRecipe(ItemStack item) {
        if (this.input != null) {
            return false;
        }
        ITeaRecipe recipe = RecipeRegisterManager.teaRecipe.getRecipe(item);
        return recipe != null;
    }

    public ItemStack getItemStack() {
        return this.input;
    }

    private void setItemStack(ItemStack item) {
        this.input = item;
    }

    public String getCurrentTexture() {
        return this.isMilk ? this.tex_milk : this.tex;
    }

    private void setTexture(ItemStack input) {
        if (input == null) {
            this.tex = "defeatedcrow:textures/blocks/contents_water.png";
            this.tex_milk = "defeatedcrow:textures/blocks/contents_water.png";
            return;
        }
        ITeaRecipe recipe = RecipeRegisterManager.teaRecipe.getRecipe(input);
        if (recipe != null) {
            this.tex = recipe.getTex();
            this.tex_milk = recipe.getMilkTex() != null ? recipe.getMilkTex() : recipe.getTex();
        } else {
            this.tex = "defeatedcrow:textures/blocks/contents_water.png";
            this.tex_milk = "defeatedcrow:textures/blocks/contents_water.png";
        }
    }

    private byte getCoolTime() {
        return this.coolTime;
    }

    private void setCoolTime(byte t) {
        this.coolTime = t;
    }

    public int getMetadata() {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        if (this.input == null) {
            this.clearTile();
        }
        if (this.coolTime == 0) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.setCoolTime((byte)20);
        }
        super.func_145845_h();
    }

    public void clearTile() {
        this.input = null;
        this.setTexture(null);
        this.isMilk = false;
        this.remain = 0;
        this.func_70296_d();
    }

    private void updateTeaMaker() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, DCsAppleMilk.teaMakerNext);
        this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, DCsAppleMilk.teaMakerNext);
        this.func_70296_d();
    }
}

