/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.common.tile.appliance;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.defeatedcrow.api.recipe.IIceRecipe;
import mods.defeatedcrow.api.recipe.RecipeRegisterManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class TileIceMaker
extends TileEntity
implements ISidedInventory {
    public int chargeAmount;
    public int currentItemCharge;
    public int cookTime;
    private int coolTime = 8;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{2, 3, 1};
    private static final int[] slots_sides = new int[]{1};
    public ItemStack[] iceItemStacks = new ItemStack[4];

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("Items", 10);
        this.iceItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.iceItemStacks.length) continue;
            this.iceItemStacks[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.chargeAmount = par1NBTTagCompound.func_74765_d("ChargeAmount");
        this.cookTime = par1NBTTagCompound.func_74765_d("CookTime");
        this.coolTime = par1NBTTagCompound.func_74771_c("CoolTime");
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74777_a("ChargeAmount", (short)((byte)this.chargeAmount));
        par1NBTTagCompound.func_74777_a("CookTime", (short)this.cookTime);
        par1NBTTagCompound.func_74774_a("CoolTime", (byte)this.coolTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.iceItemStacks.length; ++i) {
            if (this.iceItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.iceItemStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_145841_b(nbtTagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int par1) {
        return this.cookTime * par1 / 150;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int par1) {
        return this.chargeAmount * par1 / 127;
    }

    public boolean isBurning() {
        return this.cookTime > 0;
    }

    public boolean isCharged() {
        return this.chargeAmount > 0;
    }

    public void setChargeAmount(int par1) {
        this.chargeAmount = par1;
    }

    public int getChargeAmount() {
        return this.chargeAmount;
    }

    public void func_145845_h() {
        boolean flag = this.isCharged();
        boolean flag1 = false;
        if (this.coolTime > 0) {
            --this.coolTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.coolTime == 0) {
                if (this.chargeAmount < 127) {
                    int i;
                    if (TileIceMaker.isItemFuel(this.iceItemStacks[1]) && (i = this.chargeAmount + TileIceMaker.getItemBurnTime(this.iceItemStacks[1])) < 128) {
                        this.chargeAmount = i;
                        flag1 = true;
                        if (this.iceItemStacks[1] != null) {
                            --this.iceItemStacks[1].field_77994_a;
                            if (this.iceItemStacks[1].field_77994_a == 0) {
                                this.iceItemStacks[1] = this.iceItemStacks[1].func_77973_b().getContainerItem(this.iceItemStacks[1]);
                            }
                        }
                    }
                }
                if (this.isHotBiome() == 2 && this.isCharged()) {
                    --this.chargeAmount;
                    if (!this.isCharged()) {
                        flag1 = false;
                    }
                }
                this.coolTime = 8;
            }
            if (this.isCharged() && this.canSmelt()) {
                ++this.cookTime;
                if (this.cookTime == 150) {
                    this.cookTime = 0;
                    this.smeltItem();
                    flag1 = true;
                }
            } else {
                this.cookTime = 0;
            }
            if (flag != this.isCharged()) {
                flag1 = true;
            }
            if (flag1) {
                this.func_70296_d();
            }
        }
    }

    private boolean canSmelt() {
        if (this.iceItemStacks[0] == null) {
            return false;
        }
        IIceRecipe recipe = RecipeRegisterManager.iceRecipe.getRecipe(this.iceItemStacks[0]);
        if (recipe != null) {
            if (this.iceItemStacks[0].field_77994_a < recipe.getInput().field_77994_a) {
                return false;
            }
            if (recipe.getContainer() != null) {
                ItemStack container = recipe.getContainer();
                ItemStack output = recipe.getOutput();
                if (output == null || container == null) {
                    return false;
                }
                boolean flag1 = false;
                boolean flag2 = false;
                if (this.iceItemStacks[2] == null) {
                    flag1 = true;
                } else if (this.iceItemStacks[2].func_77969_a(output)) {
                    int result = this.iceItemStacks[2].field_77994_a + output.field_77994_a;
                    boolean bl = flag1 = result <= this.func_70297_j_() && result <= output.func_77976_d();
                }
                if (this.iceItemStacks[3] == null) {
                    flag2 = true;
                } else if (this.iceItemStacks[3].func_77969_a(container)) {
                    int leave = this.iceItemStacks[3].field_77994_a + container.field_77994_a;
                    flag2 = leave <= this.func_70297_j_() && leave <= container.func_77976_d();
                }
                return flag1 && flag2;
            }
            ItemStack output = recipe.getOutput();
            if (output == null) {
                return false;
            }
            if (this.iceItemStacks[2] == null) {
                return true;
            }
            if (!this.iceItemStacks[2].func_77969_a(output)) {
                return false;
            }
            int result = this.iceItemStacks[2].field_77994_a + output.field_77994_a;
            return result <= this.func_70297_j_() && result <= output.func_77976_d();
        }
        return false;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            IIceRecipe recipe = RecipeRegisterManager.iceRecipe.getRecipe(this.iceItemStacks[0]);
            ItemStack itemstack = recipe.getOutput();
            ItemStack container = recipe.getContainer();
            if (this.iceItemStacks[0].field_77994_a < recipe.getInput().field_77994_a) {
                return;
            }
            if (this.iceItemStacks[2] == null) {
                this.iceItemStacks[2] = itemstack.func_77946_l();
            } else if (this.iceItemStacks[2].func_77969_a(itemstack)) {
                this.iceItemStacks[2].field_77994_a += itemstack.field_77994_a;
            }
            if (container != null) {
                if (this.iceItemStacks[3] == null) {
                    this.iceItemStacks[3] = container.func_77946_l();
                } else if (this.iceItemStacks[3].func_77969_a(container)) {
                    this.iceItemStacks[3].field_77994_a += container.field_77994_a;
                }
            }
            this.iceItemStacks[0].field_77994_a -= recipe.getInput().field_77994_a;
            if (this.iceItemStacks[0].field_77994_a <= 0) {
                this.iceItemStacks[0] = null;
            }
            this.chargeAmount = this.isHotBiome() == 0 ? --this.chargeAmount : (this.chargeAmount -= this.isHotBiome() * 2);
            if (this.chargeAmount < 0) {
                this.chargeAmount = 0;
            }
        }
    }

    public boolean enoughCharge() {
        int biome = this.isHotBiome();
        if (biome == 0) {
            return this.isCharged();
        }
        if (biome == 2) {
            return this.chargeAmount > 3;
        }
        return this.chargeAmount > 1;
    }

    public static int getItemBurnTime(ItemStack par0ItemStack) {
        if (par0ItemStack == null) {
            return 0;
        }
        if (RecipeRegisterManager.iceRecipe.getChargeAmount(par0ItemStack) > 0) {
            return RecipeRegisterManager.iceRecipe.getChargeAmount(par0ItemStack);
        }
        return 0;
    }

    public static boolean isItemFuel(ItemStack par0ItemStack) {
        return TileIceMaker.getItemBurnTime(par0ItemStack) > 0;
    }

    public int isHotBiome() {
        int l = 1;
        BiomeGenBase biome = this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145849_e);
        l = BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) ? 2 : (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) ? 0 : 1);
        return l;
    }

    public int func_70302_i_() {
        return this.iceItemStacks.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.iceItemStacks[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.iceItemStacks[par1] != null) {
            if (this.iceItemStacks[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.iceItemStacks[par1];
                this.iceItemStacks[par1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.iceItemStacks[par1].func_77979_a(par2);
            if (this.iceItemStacks[par1].field_77994_a == 0) {
                this.iceItemStacks[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.iceItemStacks[par1] != null) {
            ItemStack itemstack = this.iceItemStacks[par1];
            this.iceItemStacks[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        if (par1 > 3) {
            par1 = 0;
        }
        this.iceItemStacks[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "Ice Maker";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return par1 > 1 ? false : (par1 == 1 ? TileIceMaker.isItemFuel(par2ItemStack) : true);
    }

    public int[] func_94128_d(int par1) {
        return par1 == 0 ? slots_bottom : (par1 == 1 ? slots_top : slots_sides);
    }

    public boolean func_102007_a(int par1, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    public boolean func_102008_b(int par1, ItemStack par2ItemStack, int par3) {
        return par3 != 0 || par1 != 1;
    }
}

