/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.common.tile.appliance;

import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.defeatedcrow.api.edibles.IEdibleItem;
import mods.defeatedcrow.api.recipe.IEvaporatorRecipe;
import mods.defeatedcrow.api.recipe.RecipeRegisterManager;
import mods.defeatedcrow.common.AMTLogger;
import mods.defeatedcrow.common.DCsAppleMilk;
import mods.defeatedcrow.common.fluid.DCsTank;
import mods.defeatedcrow.common.tile.appliance.MachineBase;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@Optional.InterfaceList(value={@Optional.Interface(iface="buildcraft.api.transport.IPipeConnection", modid="BuildCraft|Core")})
public class TileEvaporator
extends MachineBase
implements IFluidHandler,
IPipeConnection {
    public DCsTank productTank = new DCsTank(4000);

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.productTank = new DCsTank(4000);
        if (par1NBTTagCompound.func_74764_b("productTank")) {
            this.productTank.readFromNBT(par1NBTTagCompound.func_74775_l("productTank"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        NBTTagCompound tank = new NBTTagCompound();
        this.productTank.writeToNBT(tank);
        par1NBTTagCompound.func_74782_a("productTank", (NBTBase)tank);
    }

    @Override
    public Packet func_145844_m() {
        return super.func_145844_m();
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        boolean flag1 = false;
        boolean flag2 = false;
        int drainAmount = 0;
        Fluid fluid = null;
        ItemStack returnStack = null;
        if (this.productTank.getFluid() != null && this.productTank.getFluidType() != null) {
            fluid = this.productTank.getFluidType();
            boolean bl = flag1 = fluid != null;
        }
        if (flag1 && this.itemstacks[4] != null) {
            ItemStack cur = this.itemstacks[4].func_77946_l();
            if (cur.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150354_m)) {
                this.productTank.drain(this.productTank.getFluidAmount(), true);
            } else if (cur.func_77973_b() == Items.field_151133_ar) {
                returnStack = FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(this.productTank.getFluidType(), 1000), (ItemStack)new ItemStack(Items.field_151133_ar));
                flag2 = returnStack != null && this.productTank.getFluidAmount() >= 1000 * cur.field_77994_a;
                drainAmount = 1000 * cur.field_77994_a;
            } else if (cur.func_77973_b() == Item.func_150898_a((Block)DCsAppleMilk.emptyBottle)) {
                returnStack = FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(this.productTank.getFluidType(), 200), (ItemStack)new ItemStack(DCsAppleMilk.emptyBottle));
                flag2 = returnStack != null && this.productTank.getFluidAmount() >= 200 * cur.field_77994_a;
                drainAmount = 200 * cur.field_77994_a;
            } else {
                returnStack = FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(this.productTank.getFluidType(), 1000), (ItemStack)new ItemStack(cur.func_77973_b(), 1, cur.func_77960_j()));
                flag2 = returnStack != null && this.productTank.getFluidAmount() >= 1000 * cur.field_77994_a;
                drainAmount = 1000 * cur.field_77994_a;
            }
        }
        if (flag1 && flag2 && returnStack != null) {
            ItemStack result = new ItemStack(returnStack.func_77973_b(), this.itemstacks[4].field_77994_a, returnStack.func_77960_j());
            if (this.productTank.drain(drainAmount, true) != null) {
                this.itemstacks[4] = result;
            }
        }
        this.func_70296_d();
    }

    @SideOnly(value=Side.CLIENT)
    public int getFluidAmountScaled(int par1) {
        return this.productTank.getFluidAmount() * par1 / 4000;
    }

    public void getGuiFluidUpdate(int id, int val) {
        if (id == 2) {
            if (this.productTank.getFluid() == null) {
                this.productTank.setFluidById(val);
            } else {
                int amo = this.productTank.getFluidAmount();
                this.productTank.setFluidById(val);
            }
        } else if (id == 3) {
            if (this.productTank.getFluid() == null) {
                this.productTank.setFluid(null);
            } else {
                this.productTank.getFluid().amount = val;
            }
        }
    }

    @Override
    public boolean canSmelt() {
        int fillAmount;
        boolean flag1 = false;
        boolean flag2 = false;
        boolean flag3 = false;
        boolean flag4 = false;
        ItemStack items = null;
        if (this.itemstacks[2] == null) {
            return false;
        }
        items = this.itemstacks[2].func_77946_l();
        IEvaporatorRecipe recipe = RecipeRegisterManager.evaporatorRecipe.getRecipe(items);
        if (recipe == null) {
            return false;
        }
        ItemStack output = recipe.getOutput();
        FluidStack second = recipe.getSecondary();
        if (output == null && second == null || items.field_77994_a < recipe.getInput().field_77994_a) {
            return false;
        }
        flag1 = true;
        ItemStack container = null;
        if (items.func_77973_b() instanceof IEdibleItem) {
            IEdibleItem edible = (IEdibleItem)items.func_77973_b();
            container = edible.getReturnContainer(items.func_77960_j());
        } else if (items.func_77973_b() != DCsAppleMilk.moromi) {
            if (items.func_77973_b().hasContainerItem(items)) {
                container = items.func_77973_b().getContainerItem(items);
            } else if (items.func_77973_b() == DCsAppleMilk.itemLargeBottle) {
                container = items.func_77960_j() > 16 ? new ItemStack(DCsAppleMilk.itemLargeBottle, 1, items.func_77960_j() - 16) : new ItemStack(DCsAppleMilk.emptyBottle, 1, 0);
            }
        }
        if (this.itemstacks[3] == null || output == null) {
            flag2 = true;
        } else if (this.itemstacks[3].func_77969_a(output)) {
            int result = this.itemstacks[3].field_77994_a + output.field_77994_a;
            boolean bl = flag2 = result <= this.func_70297_j_() && result <= output.func_77976_d();
        }
        if (container != null && recipe.returnContainer()) {
            if (this.itemstacks[5] == null) {
                flag4 = true;
            } else if (this.itemstacks[5].func_77969_a(container)) {
                int result = this.itemstacks[5].field_77994_a + container.field_77994_a;
                flag4 = result <= this.func_70297_j_() && result <= container.func_77976_d();
            }
        } else {
            flag4 = true;
        }
        flag3 = second == null ? true : (this.productTank.isEmpty() ? true : (fillAmount = this.productTank.fill(second, false)) >= second.amount);
        return flag1 && flag2 && flag3 && flag4;
    }

    @Override
    public void onProgress() {
        boolean flag1 = false;
        boolean flag2 = false;
        boolean flag3 = false;
        ItemStack items = this.itemstacks[2];
        if (items == null) {
            return;
        }
        IEvaporatorRecipe recipe = RecipeRegisterManager.evaporatorRecipe.getRecipe(items);
        if (recipe == null) {
            return;
        }
        ItemStack output = recipe.getOutput();
        FluidStack second = recipe.getSecondary();
        if (output == null && second == null) {
            return;
        }
        flag1 = true;
        ItemStack container = null;
        if (items.func_77973_b() instanceof IEdibleItem) {
            IEdibleItem edible = (IEdibleItem)items.func_77973_b();
            container = edible.getReturnContainer(items.func_77960_j());
        } else if (items.func_77973_b().hasContainerItem(items)) {
            container = items.func_77973_b().getContainerItem(items);
        } else if (items.func_77973_b() == DCsAppleMilk.itemLargeBottle) {
            container = items.func_77960_j() > 16 ? new ItemStack(DCsAppleMilk.itemLargeBottle, 1, items.func_77960_j() - 16) : new ItemStack(DCsAppleMilk.emptyBottle, 1, 0);
        }
        if (this.itemstacks[2] != null) {
            this.itemstacks[2].field_77994_a -= recipe.getInput().field_77994_a;
            if (this.itemstacks[2].field_77994_a <= 0) {
                this.itemstacks[2] = null;
            }
            if (container != null && recipe.returnContainer()) {
                if (this.itemstacks[5] == null) {
                    this.itemstacks[5] = container.func_77946_l();
                } else if (this.itemstacks[5].func_77969_a(container)) {
                    this.itemstacks[5].field_77994_a += container.field_77994_a;
                }
            }
            flag2 = true;
        }
        if (flag1 && flag2) {
            String out = output == null ? "Empty" : output.toString();
            String sec = second == null ? "Empty" : second.getFluid().getLocalizedName(second);
            AMTLogger.debugInfo("current recipe : " + out + ", " + sec);
            if (output != null) {
                if (this.itemstacks[3] == null) {
                    this.itemstacks[3] = output.func_77946_l();
                } else if (this.itemstacks[3].func_77969_a(output)) {
                    this.itemstacks[3].field_77994_a += output.field_77994_a;
                }
            }
            if (this.productTank.isEmpty()) {
                this.productTank.setFluid(second);
            } else if (this.productTank.getFluid().isFluidEqual(second)) {
                this.productTank.fill(second, true);
            }
            this.func_70296_d();
        }
    }

    @Override
    public int func_70302_i_() {
        return 6;
    }

    @Override
    protected int[] slotsTop() {
        return new int[]{0, 2};
    }

    @Override
    protected int[] slotsBottom() {
        return new int[]{1, 3, 4, 5};
    }

    @Override
    protected int[] slotsSides() {
        return new int[]{0, 1, 2, 3, 4, 5};
    }

    @Override
    public String func_145825_b() {
        return "Evaporator";
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (this.productTank.getFluidType() == resource.getFluid()) {
            return this.productTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.productTank.drain(maxDrain, doDrain);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.productTank.getInfo()};
    }

    @Optional.Method(modid="BuildCraft|Core")
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return type == IPipeTile.PipeType.FLUID ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT;
    }
}

