/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.common.tile.appliance;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.tileentity.IEnergyInfo;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.defeatedcrow.api.charge.ChargeItemManager;
import mods.defeatedcrow.api.charge.IChargeGenerator;
import mods.defeatedcrow.api.charge.IChargeableMachine;
import mods.defeatedcrow.api.energy.IBattery;
import mods.defeatedcrow.common.config.DCsConfig;
import mods.defeatedcrow.common.config.PropertyHandler;
import mods.defeatedcrow.plugin.IC2.EUItemHandler;
import mods.defeatedcrow.plugin.IC2.EUSinkManager;
import mods.defeatedcrow.plugin.IC2.IEUSinkChannel;
import mods.defeatedcrow.plugin.SSector.SS2ItemHandler;
import mods.defeatedcrow.plugin.cofh.RFItemHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.energy.IEnergyHandler", modid="CoFHAPI|energy"), @Optional.Interface(iface="cofh.api.tileentity.IEnergyInfo", modid="CoFHAPI|tileentity")})
public abstract class MachineBase
extends TileEntity
implements ISidedInventory,
IChargeableMachine,
IEnergyHandler,
IEnergyInfo {
    private int chargeAmount = 0;
    private int coolTime = 4;
    public int cookTime = 0;
    protected IEUSinkChannel EUChannel;
    public ItemStack[] itemstacks = new ItemStack[this.func_70302_i_()];

    public MachineBase() {
        if (Loader.isModLoaded((String)"IC2")) {
            this.EUChannel = EUSinkManager.getChannel(this, this.getMaxChargeAmount(), 3);
        }
    }

    private static int exchangeRateRF() {
        return PropertyHandler.rateRF();
    }

    private static int exchangeRateEU() {
        return PropertyHandler.rateEU();
    }

    private static int exchangeRateGF() {
        return PropertyHandler.rateGF();
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        if (this.EUChannel != null) {
            this.EUChannel.readFromNBT2(par1NBTTagCompound);
        }
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("Items", 10);
        this.itemstacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.itemstacks.length) continue;
            this.itemstacks[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.chargeAmount = par1NBTTagCompound.func_74765_d("ChargeAmount");
        this.cookTime = par1NBTTagCompound.func_74765_d("CookTime");
        this.coolTime = par1NBTTagCompound.func_74771_c("CoolTime");
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        if (this.EUChannel != null) {
            this.EUChannel.writeToNBT2(par1NBTTagCompound);
        }
        super.func_145841_b(par1NBTTagCompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.itemstacks.length; ++i) {
            if (this.itemstacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.itemstacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)nbttaglist);
        par1NBTTagCompound.func_74777_a("ChargeAmount", (short)this.chargeAmount);
        par1NBTTagCompound.func_74777_a("CookTime", (short)this.cookTime);
        par1NBTTagCompound.func_74774_a("CoolTime", (byte)this.coolTime);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_145841_b(nbtTagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145843_s() {
        if (this.EUChannel != null) {
            this.EUChannel.invalidate2();
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (this.EUChannel != null) {
            this.EUChannel.onChunkUnload2();
        }
        super.onChunkUnload();
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int par1) {
        return this.cookTime * par1 / 50;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int par1) {
        return this.chargeAmount * par1 / this.getMaxChargeAmount();
    }

    @Override
    public boolean isActive() {
        return this.cookTime > 0;
    }

    public boolean isFullCharged() {
        return this.chargeAmount == this.getMaxChargeAmount();
    }

    public int getDecrementChargePerTick() {
        return 1;
    }

    public void setChargeAmount(int par1) {
        this.chargeAmount = par1;
    }

    @Override
    public int getChargeAmount() {
        return this.chargeAmount;
    }

    public void func_145845_h() {
        boolean flag = this.isFullCharged();
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K && this.EUChannel != null) {
            this.EUChannel.updateEntity2();
        }
        if (this.coolTime > 0) {
            --this.coolTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ForgeDirection[] dirs;
            if (this.coolTime == 0) {
                IBattery bat;
                if (!flag) {
                    if (MachineBase.isItemFuel(this.itemstacks[0])) {
                        int i = this.chargeAmount + MachineBase.getItemBurnTime(this.itemstacks[0]);
                        int j = MachineBase.getItemBurnTime(this.itemstacks[0]);
                        if (i <= this.getMaxChargeAmount()) {
                            this.chargeAmount = i;
                            flag1 = true;
                            if (this.itemstacks[0].func_77973_b() instanceof IBattery) {
                                IBattery bat2 = (IBattery)this.itemstacks[0].func_77973_b();
                                bat2.discharge(this.itemstacks[0], 16, true);
                            } else {
                                int ret = this.discharge(this.itemstacks[0], j, 0);
                                if (ret > 0) {
                                    flag = true;
                                }
                            }
                        }
                        if (this.chargeAmount > this.getMaxChargeAmount()) {
                            this.chargeAmount = this.getMaxChargeAmount();
                        }
                    }
                }
                if (this.itemstacks[0] != null && this.itemstacks[0].func_77973_b() instanceof IBattery && (bat = (IBattery)this.itemstacks[0].func_77973_b()).getChargeAmount(this.itemstacks[0]) == 0 && this.itemstacks[1] == null) {
                    this.func_70299_a(1, this.itemstacks[0].func_77946_l());
                    this.func_70298_a(0, 1);
                }
                this.coolTime = DCsConfig.batteryUpdate;
            }
            for (ForgeDirection dir : dirs = ForgeDirection.VALID_DIRECTIONS) {
                if (this.isFullCharged()) continue;
                int accept = this.acceptChargeFromDir(dir);
                int cap = this.getMaxChargeAmount() - this.getChargeAmount();
                accept = Math.min(accept, cap);
                this.chargeAmount += accept;
            }
            if (this.getChargeAmount() >= this.getDecrementChargePerTick() && this.canSmelt()) {
                ++this.cookTime;
                this.chargeAmount -= this.getDecrementChargePerTick();
                if (this.chargeAmount < 0) {
                    this.chargeAmount = 0;
                }
                if (this.cookTime == 50) {
                    this.cookTime = 0;
                    this.onProgress();
                    flag1 = true;
                }
            } else {
                this.cookTime = 0;
            }
            if (this.getChargeAmount() < 1) {
                flag1 = true;
            }
            this.func_70296_d();
        }
    }

    public abstract boolean canSmelt();

    public abstract void onProgress();

    public static int getItemBurnTime(ItemStack par0ItemStack) {
        int i;
        if (par0ItemStack == null) {
            return 0;
        }
        int ret = 0;
        int inc = 16;
        if (Loader.isModLoaded((String)"SextiarySector") && ret == 0) {
            i = SS2ItemHandler.dischargeAmount(par0ItemStack, inc * MachineBase.exchangeRateGF(), true);
            ret = Math.round(i / MachineBase.exchangeRateGF());
        }
        if (ModAPIManager.INSTANCE.hasAPI("CoFHAPI|energy") && ret == 0) {
            i = RFItemHandler.dischargeAmount(par0ItemStack, inc * MachineBase.exchangeRateRF(), true);
            ret = Math.round(i / MachineBase.exchangeRateRF());
        }
        if (Loader.isModLoaded((String)"IC2") && ret == 0) {
            i = EUItemHandler.dischargeAmount(par0ItemStack, inc * MachineBase.exchangeRateEU(), true);
            ret = Math.round(i / MachineBase.exchangeRateEU());
        }
        if (ret == 0) {
            if (ChargeItemManager.chargeItem.getChargeAmount(par0ItemStack) > 0) {
                ret = ChargeItemManager.chargeItem.getChargeAmount(par0ItemStack);
            } else if (par0ItemStack.func_77973_b() instanceof IBattery) {
                IBattery bat = (IBattery)par0ItemStack.func_77973_b();
                ret = bat.discharge(par0ItemStack, 16, false);
            }
        }
        return ret;
    }

    public static boolean isItemFuel(ItemStack par0ItemStack) {
        return MachineBase.getItemBurnTime(par0ItemStack) > 0;
    }

    public int discharge(ItemStack item, int amount, int slot) {
        int i;
        if (item == null) {
            return 0;
        }
        int ret = 0;
        int inc = amount;
        if (Loader.isModLoaded((String)"SextiarySector") && ret == 0 && (ret = Math.round((i = SS2ItemHandler.dischargeAmount(item, inc * MachineBase.exchangeRateGF(), false)) / MachineBase.exchangeRateGF())) > 0 && SS2ItemHandler.getAmount(item) == 0 && this.itemstacks[1] == null) {
            if (item == null || item.field_77994_a == 0) {
                this.func_70299_a(0, null);
            } else {
                this.func_70299_a(1, item.func_77946_l());
                this.func_70298_a(slot, 1);
            }
        }
        if (ModAPIManager.INSTANCE.hasAPI("CoFHAPI|energy") && ret == 0 && (ret = Math.round((i = RFItemHandler.dischargeAmount(item, inc * MachineBase.exchangeRateRF(), false)) / MachineBase.exchangeRateRF())) > 0 && RFItemHandler.getAmount(item) == 0 && this.itemstacks[1] == null) {
            if (item == null || item.field_77994_a == 0) {
                this.func_70299_a(0, null);
            } else {
                this.func_70299_a(1, item.func_77946_l());
                this.func_70298_a(slot, 1);
            }
        }
        if (Loader.isModLoaded((String)"IC2") && ret == 0 && (ret = Math.round((i = EUItemHandler.dischargeAmount(item, inc * MachineBase.exchangeRateEU(), false)) / MachineBase.exchangeRateEU())) > 0 && EUItemHandler.getAmount(item) == 0 && this.itemstacks[1] == null) {
            if (item == null || item.field_77994_a == 0) {
                this.func_70299_a(0, null);
            } else {
                this.func_70299_a(1, item.func_77946_l());
                this.func_70298_a(slot, 1);
            }
        }
        if (ret == 0) {
            this.func_70298_a(slot, 1);
            ret = amount;
        }
        return ret;
    }

    public int acceptChargeFromDir(ForgeDirection dir) {
        IChargeGenerator device;
        int get;
        int ret = 0;
        ForgeDirection opposite = dir.getOpposite();
        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
        if (tile instanceof IChargeGenerator && (get = (device = (IChargeGenerator)tile).generateCharge(opposite, true)) > 0) {
            device.generateCharge(opposite, false);
            ret = get;
        }
        if (ret == 0 && this.EUChannel != null) {
            int i = this.getChargeAmount();
            double eu = Math.min(this.EUChannel.getEnergyStored2(), 512.0);
            double get2 = eu / (double)this.exchangeRateEU() * 1.0;
            if ((double)(this.getMaxChargeAmount() - i) < get2) {
                return 0;
            }
            if (get2 > 0.0 && this.EUChannel.useEnergy2(eu)) {
                ret = (int)get2;
            }
        }
        return ret;
    }

    @Override
    public int getMaxChargeAmount() {
        return 25600;
    }

    @Override
    public boolean canReceiveChargeItem(ItemStack item) {
        ItemStack current;
        boolean flag = false;
        boolean flag2 = false;
        if (item != null) {
            int i = MachineBase.getItemBurnTime(item);
            boolean bl = flag = i > 0 && this.getChargeAmount() + i <= this.getMaxChargeAmount();
        }
        flag2 = this.func_70301_a(0) == null ? true : item.func_77969_a(current = this.func_70301_a(0)) && current.field_77994_a + item.field_77994_a < current.func_77976_d();
        return flag && flag2;
    }

    @Override
    public int addCharge(int amount, boolean isSimulate) {
        int eng = this.getChargeAmount();
        int get = amount;
        if (this.isFullCharged()) {
            return 0;
        }
        int ret = Math.min(this.getMaxChargeAmount() - eng, get);
        if (!isSimulate) {
            this.setChargeAmount(eng + ret);
        }
        return ret;
    }

    @Override
    public int extractCharge(int amount, boolean isSimulate) {
        int eng = this.getChargeAmount();
        int get = amount;
        int ret = Math.min(eng, get);
        if (!isSimulate) {
            this.setChargeAmount(eng - ret);
        }
        return ret;
    }

    protected abstract int[] slotsTop();

    protected abstract int[] slotsBottom();

    protected abstract int[] slotsSides();

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int par1) {
        return par1 < this.func_70302_i_() ? this.itemstacks[par1] : null;
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.itemstacks[par1] != null) {
            if (this.itemstacks[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.itemstacks[par1];
                this.itemstacks[par1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.itemstacks[par1].func_77979_a(par2);
            if (this.itemstacks[par1].field_77994_a == 0) {
                this.itemstacks[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.itemstacks[par1] != null) {
            ItemStack itemstack = this.itemstacks[par1];
            this.itemstacks[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        if (par1 > this.func_70302_i_()) {
            par1 = 0;
        }
        this.itemstacks[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public abstract String func_145825_b();

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return par1 == 1 || par1 > 10 ? false : (par1 == 0 ? MachineBase.isItemFuel(par2ItemStack) : true);
    }

    public int[] func_94128_d(int par1) {
        return par1 == 0 ? this.slotsBottom() : (par1 == 1 ? this.slotsTop() : this.slotsSides());
    }

    public boolean func_102007_a(int par1, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    public boolean func_102008_b(int par1, ItemStack par2ItemStack, int par3) {
        return true;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public boolean canConnectEnergy(ForgeDirection dir) {
        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
        boolean flag = tile instanceof IEnergyConnection;
        return flag;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int receiveEnergy(ForgeDirection dir, int in, boolean flag) {
        int get;
        int eng;
        block5: {
            block4: {
                eng = this.getChargeAmount();
                get = in;
                if (this.isFullCharged()) break block4;
                if (get >= this.exchangeRateRF()) break block5;
            }
            return 0;
        }
        int ret = Math.min((this.getMaxChargeAmount() - eng) * this.exchangeRateRF(), get);
        if (!flag) {
            int i = Math.round(ret / this.exchangeRateRF());
            this.setChargeAmount(eng + i);
        }
        return ret;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int extractEnergy(ForgeDirection paramForgeDirection, int paramInt, boolean paramBoolean) {
        return 0;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getEnergyStored(ForgeDirection paramForgeDirection) {
        return this.getChargeAmount() * this.exchangeRateRF();
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getMaxEnergyStored(ForgeDirection paramForgeDirection) {
        return this.getMaxChargeAmount() * this.exchangeRateRF();
    }

    @Optional.Method(modid="CoFHAPI|tileentity")
    public int getInfoEnergyPerTick() {
        return 0;
    }

    @Optional.Method(modid="CoFHAPI|tileentity")
    public int getInfoMaxEnergyPerTick() {
        return 0;
    }

    @Optional.Method(modid="CoFHAPI|tileentity")
    public int getInfoEnergyStored() {
        int eng = this.getChargeAmount();
        int get = eng * this.exchangeRateRF();
        return get;
    }

    @Optional.Method(modid="CoFHAPI|tileentity")
    public int getInfoMaxEnergyStored() {
        int eng = this.getMaxChargeAmount();
        int get = eng * this.exchangeRateRF();
        return get;
    }
}

