/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.common.tile;

import mods.defeatedcrow.common.fluid.DCsTank;
import mods.defeatedcrow.recipe.BrewingRecipe;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileBrewingBarrel
extends TileEntity
implements IFluidHandler {
    private int aging = 0;
    private boolean isAged = false;
    public DCsTank productTank = new DCsTank(1000);
    private boolean side = false;

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.aging = par1NBTTagCompound.func_74762_e("Remaining");
        this.isAged = par1NBTTagCompound.func_74767_n("IsAged");
        this.side = par1NBTTagCompound.func_74767_n("Side");
        this.productTank = new DCsTank(1000);
        if (par1NBTTagCompound.func_74764_b("productTank")) {
            this.productTank.readFromNBT(par1NBTTagCompound.func_74775_l("productTank"));
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("Remaining", this.aging);
        par1NBTTagCompound.func_74757_a("IsAged", this.isAged);
        par1NBTTagCompound.func_74757_a("Side", this.side);
        NBTTagCompound tank = new NBTTagCompound();
        this.productTank.writeToNBT(tank);
        par1NBTTagCompound.func_74782_a("productTank", (NBTBase)tank);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_145841_b(nbtTagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public int getAgingTime() {
        return this.aging;
    }

    public void setAgingTime(int par1) {
        this.aging = par1;
    }

    public boolean getAged() {
        return this.isAged;
    }

    public void setAged(boolean par1) {
        this.isAged = par1;
    }

    public boolean getSide() {
        return this.side;
    }

    public void setSide(boolean flag) {
        this.side = flag;
    }

    public int getAgingStage() {
        int i = this.aging / 6000;
        return i;
    }

    public void setAgingStage(int par1) {
        int i;
        this.aging = i = par1 * 6000;
    }

    public boolean isOnNormalCube() {
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        return !block.isAir((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) && block.func_149721_r();
    }

    public void func_145845_h() {
        if (this.field_145850_b != null) {
            if (!this.isAged && this.canBrew() && !this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d, this.field_145849_e) && !this.isDryBiome()) {
                ++this.aging;
                if (this.aging > 24000) {
                    this.aging = 24000;
                    this.onBrewing();
                    this.setAged(true);
                }
            }
            if (this.productTank.isEmpty()) {
                this.setAged(false);
                this.setAgingTime(0);
            }
        }
        super.func_145845_h();
    }

    private boolean canBrew() {
        boolean flag = false;
        Fluid input = this.productTank.getFluidType();
        if (input != null && BrewingRecipe.recipe.containsKey(input)) {
            flag = true;
        }
        return flag;
    }

    private void onBrewing() {
        Fluid input = this.productTank.getFluidType();
        int amount = this.productTank.getFluidAmount();
        if (input != null && amount > 0 && BrewingRecipe.recipe.containsKey(input)) {
            Fluid output = BrewingRecipe.recipe.get(input);
            FluidStack ret = new FluidStack(output, amount);
            this.productTank.setFluid(ret);
        }
        this.func_70296_d();
    }

    public int getMetadata() {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isColdBiome() {
        boolean flag = false;
        BiomeGenBase biome = this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145849_e);
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
            flag = true;
        }
        return flag;
    }

    public boolean isDryBiome() {
        boolean flag = false;
        BiomeGenBase biome = this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145849_e);
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            flag = true;
        }
        return flag;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !this.isAged) {
            return null;
        }
        if (this.productTank.getFluidType() == resource.getFluid()) {
            FluidStack ret = this.productTank.drain(resource.amount, doDrain);
            if (this.productTank.isEmpty()) {
                this.setAged(false);
                this.setAgingStage(0);
            }
            return ret;
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.productTank.drain(maxDrain, doDrain);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() == null || this.isAged) {
            return 0;
        }
        FluidStack current = this.productTank.getFluid();
        FluidStack resourceCopy = resource.copy();
        if (current != null && current.amount > 0 && current.isFluidEqual(resourceCopy)) {
            return 0;
        }
        int i = 0;
        int used = this.productTank.fill(resourceCopy, doFill);
        resourceCopy.amount -= used;
        return i += used;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return !this.isAged && fluid != null && BrewingRecipe.recipe.containsKey(fluid) && this.productTank.isEmpty();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.isAged;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.productTank.getInfo()};
    }
}

