/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.common.item.magic;

import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.defeatedcrow.api.energy.IBattery;
import mods.defeatedcrow.common.DCsAppleMilk;
import mods.defeatedcrow.common.tile.TileBrewingBarrel;
import mods.defeatedcrow.common.tile.appliance.MachineBase;
import mods.defeatedcrow.common.tile.energy.TileChargerDevice;
import mods.defeatedcrow.plugin.cofh.RFDeviceHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemDebugArm
extends Item
implements IBattery {
    public ItemDebugArm() {
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.setNoRepair();
        if (DCsAppleMilk.debugMode) {
            this.func_77637_a(DCsAppleMilk.applemilkMagic);
        }
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        TileBrewingBarrel barrel;
        Block block = par3World.func_147439_a(par4, par5, par6);
        TileEntity tile = par3World.func_147438_o(par4, par5, par6);
        int meta = par3World.func_72805_g(par4, par5, par6);
        if (par2EntityPlayer == null) {
            return false;
        }
        boolean se = false;
        if (tile instanceof MachineBase) {
            MachineBase machine = (MachineBase)tile;
            if (!machine.isFullCharged()) {
                int max = machine.getMaxChargeAmount();
                int ret = machine.getChargeAmount() + 800;
                ret = MathHelper.func_76125_a((int)ret, (int)0, (int)max);
                machine.setChargeAmount(ret);
                se = true;
            }
        } else if (tile instanceof TileChargerDevice) {
            TileChargerDevice device = (TileChargerDevice)tile;
            if (!device.isFullCharged()) {
                int max = device.getMaxChargeAmount();
                int ret = device.getChargeAmount() + 800;
                ret = MathHelper.func_76125_a((int)ret, (int)0, (int)max);
                device.setChargeAmount(ret);
                se = true;
            }
        } else if (ModAPIManager.INSTANCE.hasAPI("CoFHAPI|energy") && RFDeviceHandler.isRFDevice(tile)) {
            boolean bl = se = RFDeviceHandler.inputEnergy(ForgeDirection.UP, tile, 1000, false) > 0;
        }
        if (tile instanceof TileBrewingBarrel && !(barrel = (TileBrewingBarrel)tile).getAged() && !barrel.productTank.isEmpty()) {
            barrel.setAgingStage(4);
            se = true;
        }
        if (ItemDye.applyBonemeal((ItemStack)par1ItemStack, (World)par3World, (int)par4, (int)par5, (int)par6, (EntityPlayer)par2EntityPlayer) && !par3World.field_72995_K) {
            par3World.func_72926_e(2005, par4, par5, par6, 0);
            se = true;
        }
        if (!se && block.canPlaceTorchOnTop(par3World, par4, par5, par6) && par3World.func_147437_c(par4, par5 + 1, par6)) {
            if (!par3World.field_72995_K) {
                par3World.func_147449_b(par4, par5 + 1, par6, Blocks.field_150478_aa);
            }
            se = true;
        }
        if (se) {
            par3World.func_72956_a((Entity)par2EntityPlayer, "random.pop", 0.4f, 1.8f);
        }
        return true;
    }

    public boolean func_111207_a(ItemStack item, EntityPlayer player, EntityLivingBase target) {
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return false;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.none;
    }

    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.rare;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("defeatedcrow:purple_scale");
    }

    @Override
    public int getMaxAmount(ItemStack item) {
        return 51200;
    }

    @Override
    public int getChargeAmount(ItemStack item) {
        NBTTagCompound nbt = item.func_77978_p();
        if (nbt != null && nbt.func_74764_b("charge")) {
            int charge = nbt.func_74762_e("charge");
            return charge;
        }
        return 0;
    }

    @Override
    public boolean isFullCharged(ItemStack item) {
        NBTTagCompound nbt = item.func_77978_p();
        if (nbt != null && nbt.func_74764_b("charge")) {
            int charge = nbt.func_74762_e("charge");
            return charge >= this.getMaxAmount(item);
        }
        return false;
    }

    @Override
    public int charge(ItemStack item, int amount, boolean flag) {
        if (item == null) {
            return 0;
        }
        NBTTagCompound nbt = item.func_77978_p();
        int charge = 0;
        int increase = 0;
        if (nbt != null && nbt.func_74764_b("charge")) {
            charge = nbt.func_74762_e("charge");
        }
        int i = this.getMaxAmount(item) - charge;
        Math.min(i, 0);
        increase = Math.min(amount, i);
        if (flag) {
            if (nbt != null) {
                nbt.func_74768_a("charge", charge + increase);
                item.func_77982_d(nbt);
            } else {
                NBTTagCompound nbt2 = new NBTTagCompound();
                nbt2.func_74768_a("charge", charge + increase);
                item.func_77982_d(nbt2);
            }
        }
        return increase;
    }

    @Override
    public int discharge(ItemStack item, int amount, boolean flag) {
        if (item == null) {
            return 0;
        }
        NBTTagCompound nbt = item.func_77978_p();
        int charge = 0;
        int reduce = 0;
        if (nbt != null && nbt.func_74764_b("charge")) {
            charge = nbt.func_74762_e("charge");
        }
        reduce = Math.min(amount, charge);
        if (flag) {
            if (nbt != null) {
                nbt.func_74768_a("charge", charge - reduce);
                item.func_77982_d(nbt);
            } else {
                NBTTagCompound nbt2 = new NBTTagCompound();
                nbt2.func_74768_a("charge", charge - reduce);
                item.func_77982_d(nbt2);
            }
        }
        return reduce;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        NBTTagCompound nbt = par1ItemStack.func_77978_p();
        int charge = 0;
        int max = this.getMaxAmount(par1ItemStack);
        if (nbt != null && nbt.func_74764_b("charge")) {
            charge = nbt.func_74762_e("charge");
        }
        String s = new String("charge amount : " + charge + "/" + max);
        par3List.add(s);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        int charge = 0;
        int max = this.getMaxAmount(stack);
        if (nbt != null && nbt.func_74764_b("charge")) {
            charge = nbt.func_74762_e("charge");
            charge = MathHelper.func_76125_a((int)charge, (int)0, (int)max);
        }
        int i = max - charge;
        return (double)i / (double)max;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }
}

