/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.common.item.appliance;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.defeatedcrow.api.energy.IBattery;
import mods.defeatedcrow.api.events.ShootingGunEvent;
import mods.defeatedcrow.common.DCsAppleMilk;
import mods.defeatedcrow.common.entity.EntityYuzuBullet;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class ItemYuzuGatling
extends ItemBow
implements IBattery {
    public ItemYuzuGatling() {
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("defeatedcrow:yuzu");
    }

    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.rare;
    }

    @Override
    public int getMaxAmount(ItemStack item) {
        return 6400;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 16;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        boolean creative = par3EntityPlayer.field_71075_bZ.field_75098_d;
        boolean hasYuzu = false;
        boolean inf = EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)par1ItemStack) > 0;
        int power = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)par1ItemStack);
        int fire = EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)par1ItemStack);
        boolean looseCheck = creative || inf;
        boolean chargeCheck = creative;
        EntityYuzuBullet bullet = new EntityYuzuBullet(par2World, (EntityLivingBase)par3EntityPlayer, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        float dam = fire > 0 ? 5.0f : 3.0f;
        int yuzu = 1;
        int charge = 2;
        ShootingGunEvent event = new ShootingGunEvent(par2World, par3EntityPlayer, par1ItemStack, dam += (float)power * 0.5f, 1, 2);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return par1ItemStack;
        }
        if (event.hasResult() && event.getResult() == Event.Result.ALLOW) {
            dam = event.damage;
            yuzu = event.looseBullet;
            charge = event.looseCharge;
            looseCheck = yuzu < 1;
            chargeCheck = charge < 0;
        }
        bullet.setDamage(dam);
        if (fire > 0) {
            bullet.func_70015_d(100);
        }
        if (!looseCheck && this.looseYuzu(par3EntityPlayer, DCsAppleMilk.leafTea, 3, yuzu)) {
            looseCheck = true;
        }
        if (!chargeCheck && this.discharge(par1ItemStack, charge, true) > 0) {
            chargeCheck = true;
        }
        if (dam > 0.0f && looseCheck && chargeCheck && !par2World.field_72995_K) {
            par2World.func_72838_d((Entity)bullet);
        }
        par2World.func_72956_a((Entity)par3EntityPlayer, "random.door_close", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + 1.3f);
        return par1ItemStack;
    }

    public ItemStack func_77654_b(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        return par1ItemStack;
    }

    private boolean looseYuzu(EntityPlayer player, Item item, int meta, int count) {
        if (player == null) {
            return false;
        }
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (player.field_71071_by.field_70462_a[i] == null || player.field_71071_by.field_70462_a[i].func_77973_b() != item || player.field_71071_by.field_70462_a[i].func_77960_j() != meta || player.field_71071_by.field_70462_a[i].field_77994_a < count) continue;
            player.field_71071_by.field_70462_a[i].field_77994_a -= count;
            if (player.field_71071_by.field_70462_a[i].field_77994_a <= 0) {
                player.field_71071_by.field_70462_a[i] = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public int getChargeAmount(ItemStack item) {
        NBTTagCompound nbt = item.func_77978_p();
        if (nbt != null && nbt.func_74764_b("charge")) {
            int charge = nbt.func_74762_e("charge");
            return charge;
        }
        return 0;
    }

    @Override
    public boolean isFullCharged(ItemStack item) {
        NBTTagCompound nbt = item.func_77978_p();
        if (nbt != null && nbt.func_74764_b("charge")) {
            int charge = nbt.func_74762_e("charge");
            return charge >= this.getMaxAmount(item);
        }
        return false;
    }

    @Override
    public int charge(ItemStack item, int amount, boolean flag) {
        if (item == null) {
            return 0;
        }
        NBTTagCompound nbt = item.func_77978_p();
        int charge = 0;
        int increase = 0;
        if (nbt != null && nbt.func_74764_b("charge")) {
            charge = nbt.func_74762_e("charge");
        }
        int i = this.getMaxAmount(item) - charge;
        Math.min(i, 0);
        increase = Math.min(amount, i);
        if (flag) {
            if (nbt != null) {
                nbt.func_74768_a("charge", charge + increase);
                item.func_77982_d(nbt);
            } else {
                NBTTagCompound nbt2 = new NBTTagCompound();
                nbt2.func_74768_a("charge", charge + increase);
                item.func_77982_d(nbt2);
            }
        }
        return increase;
    }

    @Override
    public int discharge(ItemStack item, int amount, boolean flag) {
        if (item == null) {
            return 0;
        }
        NBTTagCompound nbt = item.func_77978_p();
        int charge = 0;
        int reduce = 0;
        if (nbt != null && nbt.func_74764_b("charge")) {
            charge = nbt.func_74762_e("charge");
        }
        reduce = Math.min(amount, charge);
        if (flag) {
            if (nbt != null) {
                nbt.func_74768_a("charge", charge - reduce);
                item.func_77982_d(nbt);
            } else {
                NBTTagCompound nbt2 = new NBTTagCompound();
                nbt2.func_74768_a("charge", charge - reduce);
                item.func_77982_d(nbt2);
            }
        }
        return reduce;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        NBTTagCompound nbt = par1ItemStack.func_77978_p();
        int charge = 0;
        int max = this.getMaxAmount(par1ItemStack);
        if (nbt != null && nbt.func_74764_b("charge")) {
            charge = nbt.func_74762_e("charge");
        }
        String s = new String("charge amount : " + charge + "/" + max);
        par3List.add(s);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        int charge = 0;
        int max = this.getMaxAmount(stack);
        if (nbt != null && nbt.func_74764_b("charge")) {
            charge = nbt.func_74762_e("charge");
            charge = MathHelper.func_76125_a((int)charge, (int)0, (int)max);
        }
        int i = max - charge;
        return (double)i / (double)max;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }
}

