/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.common.block.plants;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.defeatedcrow.api.plants.IRightClickHarvestable;
import mods.defeatedcrow.api.plants.PlantsClickEvent;
import mods.defeatedcrow.common.DCsAppleMilk;
import mods.defeatedcrow.handler.Util;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;

public class BlockCassisTree
extends Block
implements IShearable,
IPlantable,
IRightClickHarvestable {
    @SideOnly(value=Side.CLIENT)
    private IIcon leafIIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] newleafIIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon logIIcon;

    public BlockCassisTree() {
        super(Material.field_151575_d);
        this.func_149672_a(Block.field_149779_h);
        this.func_149675_a(true);
        this.func_149711_c(0.1f);
    }

    public void func_149674_a(World par1World, int par2, int par3, int par4, Random par5Random) {
        int meta;
        int growth;
        if (!par1World.field_72995_K && par1World.field_73012_v.nextInt(8) == 0 && (growth = (meta = par1World.func_72805_g(par2, par3, par4)) & 3) < 3 && par1World.func_72957_l(par2, par3, par4) > 11) {
            par1World.func_72921_c(par2, par3, par4, meta + 1, 3);
        }
    }

    public boolean fertilize(World par1World, int par2, int par3, int par4) {
        int meta = par1World.func_72805_g(par2, par3, par4);
        if (meta < 3) {
            par1World.func_72921_c(par2, par3, par4, 3, 3);
            return true;
        }
        if (meta > 3 && meta < 7) {
            par1World.func_72921_c(par2, par3, par4, 7, 3);
            return true;
        }
        return false;
    }

    public boolean func_149727_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        ItemStack currentItem;
        ItemStack itemstack = par5EntityPlayer.field_71071_by.func_70448_g();
        Block block = par1World.func_147439_a(par2, par3, par4);
        int meta = par1World.func_72805_g(par2, par3, par4);
        PlantsClickEvent event = new PlantsClickEvent(par1World, par5EntityPlayer, itemstack, block, this, meta, par2, par3, par4);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.hasResult() && event.getResult() == Event.Result.ALLOW) {
            par1World.func_72956_a((Entity)par5EntityPlayer, "random.pop", 0.4f, 1.8f);
            return true;
        }
        if (event.isCanceled()) {
            return false;
        }
        InventoryPlayer inventory = par5EntityPlayer.field_71071_by;
        if (inventory != null && this.onHarvest(par1World, par2, par3, par4, (IInventory)inventory, currentItem = inventory.func_70448_g())) {
            par1World.func_72956_a((Entity)par5EntityPlayer, "random.pop", 0.4f, 1.8f);
            return true;
        }
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return DCsAppleMilk.modelCassisTree;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        int i = Math.min(par2, 7);
        if (par1 == 0) {
            return this.logIIcon;
        }
        if (par1 == 1) {
            return this.leafIIcon;
        }
        return this.newleafIIcon[i];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(DCsAppleMilk.cassisTree, 1, 3));
        par3List.add(new ItemStack(DCsAppleMilk.cassisTree, 1, 7));
    }

    public Item func_149650_a(int metadata, Random rand, int fortune) {
        return Item.func_150898_a((Block)DCsAppleMilk.saplingTea);
    }

    public int func_149692_a(int par1) {
        return par1 < 4 ? 1 : 2;
    }

    public int func_149745_a(Random random) {
        return random.nextInt(3) == 0 ? 2 : 1;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int chance = this.getChance(metadata);
        ItemStack crop = this.getCropItem(metadata);
        ret.add(new ItemStack(this.func_149650_a(metadata, world.field_73012_v, fortune), this.func_149745_a(world.field_73012_v), this.func_149692_a(metadata)));
        if (fortune > 0 && (chance -= 10 << fortune) < 2) {
            chance = 2;
        }
        if (crop != null) {
            ret.add(crop);
            if (world.field_73012_v.nextInt(chance) == 0) {
                ret.add(crop);
            }
        }
        return ret;
    }

    protected int getChance(int meta) {
        return meta == 3 ? 2 : 10;
    }

    protected boolean func_149700_E() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IIconRegister) {
        this.leafIIcon = par1IIconRegister.func_94245_a(Util.getTexturePassNoAlt() + "tealeaf");
        this.logIIcon = par1IIconRegister.func_94245_a(Util.getTexturePassNoAlt() + "tealog");
        this.field_149761_L = par1IIconRegister.func_94245_a(Util.getTexturePassNoAlt() + "tealeaf");
        this.newleafIIcon = new IIcon[8];
        for (int i = 0; i < 8; ++i) {
            int j;
            if (i < 4) {
                j = Math.max(i, 1);
                this.newleafIIcon[i] = par1IIconRegister.func_94245_a(Util.getTexturePassNoAlt() + "cassisleaf_" + j);
                continue;
            }
            if (i >= 8) continue;
            j = Math.max(i, 1) - 4;
            this.newleafIIcon[i] = par1IIconRegister.func_94245_a(Util.getTexturePassNoAlt() + "camellialeaf_" + j);
        }
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Plains;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    @Override
    public boolean onHarvest(World world, int x, int y, int z, IInventory inventory, ItemStack currentItem) {
        int meta = world.func_72805_g(x, y, z);
        if (meta != 3 && meta != 7) {
            return false;
        }
        ItemStack ret = this.getCropItem(meta);
        boolean flag = false;
        if (Util.notEmptyItem(ret) && (currentItem == null || currentItem.func_77973_b() == ret.func_77973_b())) {
            if (inventory instanceof InventoryPlayer) {
                InventoryPlayer playerInv = (InventoryPlayer)inventory;
                if (playerInv.func_70441_a(ret)) {
                    world.func_72921_c(x, y, z, meta - 2, 3);
                    playerInv.func_70296_d();
                    return true;
                }
                flag = true;
            } else if (inventory != null) {
                int slot = this.getAddSlot(inventory, ret);
                if (slot > -1) {
                    if (inventory.func_70301_a(slot) == null) {
                        inventory.func_70299_a(slot, ret);
                    } else {
                        ++inventory.func_70301_a((int)slot).field_77994_a;
                    }
                    world.func_72921_c(x, y, z, meta - 2, 3);
                    return true;
                }
                flag = true;
            } else {
                flag = true;
            }
        }
        if (flag) {
            float a = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float a1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float a2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            EntityItem drop = new EntityItem(world, (double)((float)x + a), (double)((float)y + a1), (double)((float)z + a2), ret);
            drop.field_70181_x = 0.25;
            if (!world.field_72995_K && world.func_72838_d((Entity)drop)) {
                world.func_72921_c(x, y, z, meta - 2, 3);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isHarvestable(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return meta == 3 || meta == 7;
    }

    @Override
    public ItemStack getCropItem(int blockMeta) {
        ItemStack ret = null;
        if (blockMeta == 3) {
            ret = new ItemStack(DCsAppleMilk.leafTea, 1, 2);
        } else if (blockMeta == 7) {
            ret = new ItemStack(DCsAppleMilk.leafTea, 1, 4);
        }
        return ret;
    }

    private int getAddSlot(IInventory inventory, ItemStack get) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i) == null) {
                return i;
            }
            if (!Util.notEmptyItem(get)) continue;
            ItemStack cur = inventory.func_70301_a(i);
            if (get.func_77973_b() != cur.func_77973_b() || get.func_77960_j() != cur.func_77960_j() || cur.field_77994_a >= cur.func_77976_d()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getGrownMetadata(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return this.getGrownMetadata(meta);
    }

    @Override
    public int getInitialMetadata(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return this.getInitialMetadata(meta);
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int m = world.func_72805_g(x, y, z);
        m = m < 4 ? 0 : 4;
        ret.add(new ItemStack((Block)this, 1, m));
        return ret;
    }

    @Override
    public int getGrownMetadata(int meta) {
        return meta < 4 ? 3 : 7;
    }

    @Override
    public int getInitialMetadata(int meta) {
        return meta < 4 ? 0 : 4;
    }

    @Override
    public Block getSaplingBlock(int meta) {
        return DCsAppleMilk.saplingTea;
    }

    @Override
    public int getSaplingMeta(int meta) {
        return meta < 4 ? 1 : 2;
    }
}

