/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.common.block.edible;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mods.defeatedcrow.api.edibles.IEdibleItem;
import mods.defeatedcrow.api.events.EatEdiblesEvent;
import mods.defeatedcrow.common.DCsAppleMilk;
import mods.defeatedcrow.common.config.DCsConfig;
import mods.defeatedcrow.plugin.SSector.LoadSSectorPlugin;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public abstract class EdibleEntityItemBlock
extends ItemBlock
implements IEdibleItem {
    public boolean allowChopstacks = true;
    public boolean showTooltip = true;

    public EdibleEntityItemBlock(Block block, boolean chopsticks, boolean tip) {
        super(block);
        this.allowChopstacks = chopsticks;
        this.showTooltip = tip;
    }

    public ItemStack func_77654_b(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        int meta = par1ItemStack.func_77960_j();
        boolean flag = false;
        EatEdiblesEvent event = new EatEdiblesEvent(par2World, par3EntityPlayer, par1ItemStack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.hasResult() && event.getResult() == Event.Result.ALLOW) {
            if (!par3EntityPlayer.field_71075_bZ.field_75098_d) {
                --par1ItemStack.field_77994_a;
                this.returnItemStack(par3EntityPlayer, meta);
            }
            flag = true;
        }
        if (event.isCanceled()) {
            return par1ItemStack;
        }
        if (!flag && !par3EntityPlayer.field_71075_bZ.field_75098_d) {
            --par1ItemStack.field_77994_a;
            this.returnItemStack(par3EntityPlayer, meta);
        }
        if (!par2World.field_72995_K) {
            ArrayList<PotionEffect> potion;
            if (this.effectOnEaten(par3EntityPlayer, meta) != null && (potion = this.effectOnEaten(par3EntityPlayer, meta)) != null && !potion.isEmpty()) {
                for (PotionEffect ret : potion) {
                    par3EntityPlayer.func_70690_d(ret);
                }
            }
            if (this.hungerOnEaten(meta) != null) {
                int[] h = this.hungerOnEaten(meta);
                par3EntityPlayer.func_71024_bL().func_75122_a(h[0], (float)h[1] * 0.1f);
            }
        }
        return par1ItemStack;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.eat;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        par3EntityPlayer.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
        return par1ItemStack;
    }

    protected boolean returnItemStack(EntityPlayer player, int meta) {
        ItemStack ret = this.getReturnContainer(meta);
        if (ret != null && !player.field_70170_p.field_72995_K) {
            EntityItem drop = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, ret);
            player.field_70170_p.func_72838_d((Entity)drop);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getReturnContainer(int meta) {
        return null;
    }

    @Override
    public ArrayList<PotionEffect> effectOnEaten(EntityPlayer player, int meta) {
        ArrayList<PotionEffect> ret = new ArrayList<PotionEffect>();
        return ret;
    }

    @Override
    public int[] hungerOnEaten(int meta) {
        return new int[]{4, 2};
    }

    protected void addSSMoisture(int i, float f, EntityPlayer par3EntityPlayer) {
        if (DCsAppleMilk.SuccessLoadSSector) {
            LoadSSectorPlugin.addStatus(i, f, 0, 0.0f, par3EntityPlayer);
        }
    }

    protected void addSSStamina(int i, float f, EntityPlayer par3EntityPlayer) {
        if (DCsAppleMilk.SuccessLoadSSector) {
            LoadSSectorPlugin.addStatus(0, 0.0f, i, f, par3EntityPlayer);
        }
    }

    public boolean func_111207_a(ItemStack itemstack, EntityPlayer player, EntityLivingBase entity) {
        if (entity.field_70170_p.field_72995_K || entity == null) {
            return false;
        }
        ArrayList<PotionEffect> effect = this.effectOnEaten(player, itemstack.func_77960_j());
        ItemStack ret = this.getReturnContainer(itemstack.func_77960_j());
        if (effect != null) {
            for (PotionEffect p : effect) {
                entity.func_70690_d(p);
            }
        }
        entity.field_70170_p.func_72956_a((Entity)entity, "random.pop", 0.4f, 1.8f);
        if (!player.field_71075_bZ.field_75098_d) {
            --itemstack.field_77994_a;
        }
        if (ret != null && !player.field_71071_by.func_70441_a(ret)) {
            player.func_70099_a(ret, 1.0f);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        int l = par1ItemStack.func_77960_j();
        ArrayList<PotionEffect> effect = this.effectOnEaten(par2EntityPlayer, l);
        if (effect != null && this.showTooltip) {
            for (PotionEffect p : effect) {
                String s = StatCollector.func_74838_a((String)p.func_76453_d()).trim();
                if (p.func_76458_c() > 0) {
                    s = p.func_76458_c() < 4 ? s + " " + StatCollector.func_74838_a((String)("potion.potency." + p.func_76458_c())).trim() : s + " " + p.func_76458_c();
                }
                if (p.func_76459_b() > 20) {
                    s = s + " (" + Potion.func_76389_a((PotionEffect)p) + ")";
                }
                par3List.add(s);
            }
        }
    }

    public boolean func_77648_a(ItemStack item, EntityPlayer player, World world, int x, int y, int z, int side, float p_77648_8_, float p_77648_9_, float p_77648_10_) {
        if (player != null && player.func_70093_af()) {
            this.func_77659_a(item, world, player);
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150431_aC && (world.func_72805_g(x, y, z) & 7) < 1) {
            side = 1;
        } else if (block != Blocks.field_150395_bd && block != Blocks.field_150329_H && block != Blocks.field_150330_I && !block.isReplaceable((IBlockAccess)world, x, y, z)) {
            if (side == 0) {
                --y;
            }
            if (side == 1) {
                ++y;
            }
            if (side == 2) {
                --z;
            }
            if (side == 3) {
                ++z;
            }
            if (side == 4) {
                --x;
            }
            if (side == 5) {
                ++x;
            }
        }
        if (item.field_77994_a == 0) {
            return false;
        }
        if (!player.func_82247_a(x, y, z, side, item)) {
            return false;
        }
        if (y == 255 && this.field_150939_a.func_149688_o().func_76220_a()) {
            return false;
        }
        if (world.func_147472_a(this.field_150939_a, x, y, z, false, side, (Entity)player, item)) {
            if (DCsConfig.allowEdibleEntities) {
                int m = this.func_77647_b(item.func_77960_j());
                if (!world.field_72995_K && this.spownEntityFoods(world, player, new ItemStack((Item)this, 1, m), (float)x + 0.5f, (float)y + 0.0f, (float)z + 0.5f)) {
                    world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), this.field_150939_a.field_149762_H.func_150496_b(), (this.field_150939_a.field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.field_150939_a.field_149762_H.func_150494_d() * 0.8f);
                    --item.field_77994_a;
                }
                return true;
            }
            int i1 = this.func_77647_b(item.func_77960_j());
            int j1 = this.field_150939_a.func_149660_a(world, x, y, z, side, p_77648_8_, p_77648_9_, p_77648_10_, i1);
            if (this.placeBlockAt(item, player, world, x, y, z, side, p_77648_8_, p_77648_9_, p_77648_10_, j1)) {
                world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), this.field_150939_a.field_149762_H.func_150496_b(), (this.field_150939_a.field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.field_150939_a.field_149762_H.func_150494_d() * 0.8f);
                --item.field_77994_a;
            }
            return true;
        }
        return false;
    }

    protected boolean spownEntityFoods(World world, EntityPlayer player, ItemStack item, double x, double y, double z) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_150936_a(World world, int x, int y, int z, int side, EntityPlayer player, ItemStack item) {
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150431_aC) {
            side = 1;
        } else if (block != Blocks.field_150395_bd && block != Blocks.field_150329_H && block != Blocks.field_150330_I && !block.isReplaceable((IBlockAccess)world, x, y, z)) {
            if (side == 0) {
                --y;
            }
            if (side == 1) {
                ++y;
            }
            if (side == 2) {
                --z;
            }
            if (side == 3) {
                ++z;
            }
            if (side == 4) {
                --x;
            }
            if (side == 5) {
                ++x;
            }
        }
        return world.func_147472_a(this.field_150939_a, x, y, z, false, side, (Entity)null, item);
    }
}

