/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.common.block.appliance;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mods.defeatedcrow.api.appliance.SoupType;
import mods.defeatedcrow.api.recipe.IFondueRecipe;
import mods.defeatedcrow.api.recipe.IFondueSource;
import mods.defeatedcrow.api.recipe.RecipeRegisterManager;
import mods.defeatedcrow.client.particle.EntityDCCloudFX;
import mods.defeatedcrow.client.particle.ParticleTex;
import mods.defeatedcrow.common.DCsAppleMilk;
import mods.defeatedcrow.common.config.DCsConfig;
import mods.defeatedcrow.common.tile.appliance.TileFilledSoupPan;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;

public class BlockFilledSoupPan
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] contentsTex;

    public BlockFilledSoupPan() {
        super(Material.field_151578_c);
        this.func_149672_a(Block.field_149769_e);
        this.func_149711_c(0.2f);
        this.func_149752_b(1.0f);
        this.func_149675_a(true);
    }

    public boolean func_149727_a(World world, int par2, int par3, int par4, EntityPlayer player, int par6, float par7, float par8, float par9) {
        ItemStack hold = player.field_71071_by.func_70448_g();
        int currentMeta = world.func_72805_g(par2, par3, par4);
        Block bottomBlock = world.func_147439_a(par2, par3 - 1, par4);
        TileEntity tile = world.func_147438_o(par2, par3, par4);
        TileFilledSoupPan pan = null;
        if (tile == null || !(tile instanceof TileFilledSoupPan)) {
            return false;
        }
        pan = (TileFilledSoupPan)tile;
        if (hold == null) {
            return false;
        }
        ItemStack chocolate = RecipeRegisterManager.chocoRecipe.getOutput(hold);
        IFondueRecipe food = RecipeRegisterManager.fondueRecipe.getRecipe(hold, pan.getType());
        if (pan.getType() == SoupType.CHOCO && chocolate != null && chocolate.func_77973_b() != null) {
            this.getRecipeFood(world, par2, par3, par4, player, hold, chocolate);
            this.reduceRemain(world, par2, par3, par4, pan);
            return true;
        }
        if (food != null && food.getOutput() != null && food.getType() == pan.getType()) {
            this.getRecipeFood(world, par2, par3, par4, player, hold, food.getOutput());
            this.reduceRemain(world, par2, par3, par4, pan);
            return true;
        }
        if (world.field_72995_K) {
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"dc.panMessage.noFondueRecipe")));
        }
        return true;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        ItemStack input;
        IFondueSource recipe;
        if (world.field_72995_K || !this.onFurnace(world, x, y, z) || entity == null) {
            return;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null || !(tile instanceof TileFilledSoupPan)) {
            return;
        }
        TileFilledSoupPan pan = (TileFilledSoupPan)tile;
        boolean flag = false;
        if (entity instanceof EntityItem && (recipe = RecipeRegisterManager.fondueRecipe.getType(input = ((EntityItem)entity).func_92059_d())) != null && recipe.beforeType() == pan.getType() && recipe.matches(input)) {
            this.setSoupType(world, x, y, z, pan, recipe.afterType());
            world.func_72956_a(entity, "random.pop", 0.4f, 1.8f);
            ItemStack container = null;
            container = FluidContainerRegistry.isFilledContainer((ItemStack)input) ? FluidContainerRegistry.drainFluidContainer((ItemStack)input) : input.func_77973_b().getContainerItem(input);
            if (container != null) {
                EntityItem cont = new EntityItem(world, (double)x, (double)y + 1.0, (double)z, container);
                world.func_72838_d((Entity)cont);
            }
            if (input.field_77994_a > 1) {
                --((EntityItem)entity).func_92059_d().field_77994_a;
            } else {
                entity.func_70106_y();
            }
        }
    }

    public void setSoupType(World world, int x, int y, int z, TileFilledSoupPan pan, SoupType type) {
        if (pan == null) {
            return;
        }
        pan.setType(type);
        pan.setRemainByte((byte)8);
        world.func_72926_e(2005, x, y, z, 0);
        world.func_147471_g(x, y, z);
    }

    private void getRecipeFood(World world, int x, int y, int z, EntityPlayer player, ItemStack input, ItemStack result) {
        EntityItem entity;
        if (input == null || input.func_77973_b() == null) {
            return;
        }
        ItemStack container = null;
        container = FluidContainerRegistry.isFilledContainer((ItemStack)input) ? FluidContainerRegistry.drainFluidContainer((ItemStack)input) : input.func_77973_b().getContainerItem(input);
        if (!player.field_71075_bZ.field_75098_d && --input.field_77994_a <= 0) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
        }
        if (!world.field_72995_K) {
            entity = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, result);
            world.func_72838_d((Entity)entity);
        }
        if (container != null && !world.field_72995_K) {
            entity = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, container);
            world.func_72838_d((Entity)entity);
        }
        world.func_72956_a((Entity)player, "random.pop", 0.4f, 1.8f);
    }

    public void reduceRemain(World world, int x, int y, int z, TileFilledSoupPan pan) {
        if (!world.field_72995_K && pan != null) {
            byte rem = pan.getRemainByte();
            if (rem > 1) {
                pan.setRemainByte((byte)(rem - 1));
            } else {
                world.func_147475_p(x, y, z);
                world.func_147465_d(x, y, z, DCsAppleMilk.emptyPanGaiden, 0, 2);
            }
            world.func_147471_g(x, y, z);
        }
    }

    public boolean onFurnace(World world, int x, int y, int z) {
        int meta;
        Block block = world.func_147439_a(x, y - 1, z);
        return RecipeRegisterManager.panRecipe.isHeatSource(block, meta = world.func_72805_g(x, y - 1, z));
    }

    public int func_149692_a(int par1) {
        return 0;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return DCsAppleMilk.modelSoupPan;
    }

    public TileEntity func_149915_a(World world, int a) {
        return new TileFilledSoupPan();
    }

    public void func_149689_a(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        TileEntity tile;
        int playerFacing = MathHelper.func_76128_c((double)((double)(par5EntityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        boolean facing = false;
        if (playerFacing == 1 || playerFacing == 3) {
            facing = true;
        }
        if ((tile = par1World.func_147438_o(par2, par3, par4)) instanceof TileFilledSoupPan && par6ItemStack != null && par6ItemStack.func_77973_b() == Item.func_150898_a((Block)DCsAppleMilk.filledSoupPan)) {
            ((TileFilledSoupPan)tile).setDirection(facing);
        }
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        this.func_149719_a((IBlockAccess)par1World, par2, par3, par4);
        return super.func_149668_a(par1World, par2, par3, par4);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World par1World, int par2, int par3, int par4) {
        this.func_149719_a((IBlockAccess)par1World, par2, par3, par4);
        return super.func_149633_g(par1World, par2, par3, par4);
    }

    public void func_149719_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        this.thisBoundingBox(par1IBlockAccess.func_72805_g(par2, par3, par4));
    }

    public void thisBoundingBox(int par1) {
        float f = 0.125f;
        this.func_149676_a(0.0f + f, 0.0f, 0.0f + f, 1.0f - f, 0.5f, 1.0f - f);
    }

    public Item func_149650_a(int metadata, Random rand, int fortune) {
        return Item.func_150898_a((Block)DCsAppleMilk.emptyPanGaiden);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        int i = Math.min(meta, this.contentsTex.length - 1);
        if (side == 1) {
            return this.contentsTex[i];
        }
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = Blocks.field_150405_ch.func_149733_h(1);
        int lim = SoupType.types.length;
        this.contentsTex = new IIcon[lim];
        for (int i = 0; i < lim; ++i) {
            this.contentsTex[i] = par1IconRegister.func_94245_a(SoupType.getType((int)i).blockTexture);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World par1World, int par2, int par3, int par4, Random par5Random) {
        int l = par1World.func_72805_g(par2, par3, par4);
        Block i = par1World.func_147439_a(par2, par3 - 1, par2);
        double d0 = (float)par2 + 0.25f + par5Random.nextFloat() / 2.0f;
        double d1 = (float)par3 + par5Random.nextFloat();
        double d2 = (float)par4 + 0.25f + par5Random.nextFloat() / 2.0f;
        double d3 = 0.0199999988079071;
        double d4 = 0.27f;
        if (!DCsConfig.noRenderFoodsSteam) {
            EntityDCCloudFX cloud = new EntityDCCloudFX(par1World, d0, d1, d2, 0.0, d3, 0.0);
            cloud.func_110125_a(ParticleTex.getInstance().getIcon("cloud"));
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)cloud);
        }
    }
}

