/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.asm;

import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import mods.defeatedcrow.asm.AppleMilkCorePlugin;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class PotionEffectTransformer
implements IClassTransformer,
Opcodes {
    private static final String TARGET_CLASS_NAME = "net.minecraft.potion.PotionEffect";

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!AppleMilkCorePlugin.allowLoad || AppleMilkCorePlugin.forcedDisable) {
            return basicClass;
        }
        if (!transformedName.equals(TARGET_CLASS_NAME)) {
            return basicClass;
        }
        try {
            AppleMilkCorePlugin.logger.info("Start transforming PotionEffect Class");
            ClassReader classReader = new ClassReader(basicClass);
            ClassWriter classWriter = new ClassWriter(1);
            classReader.accept((ClassVisitor)new CustomVisitor(name, (ClassVisitor)classWriter), 8);
            AppleMilkCorePlugin.logger.info("Finish transforming PotionEffect Class");
            return classWriter.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("failed : PotionEffectTransformer loading", e);
        }
    }

    class CustomMethodVisitor3
    extends MethodVisitor {
        public CustomMethodVisitor3(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            AppleMilkCorePlugin.logger.info("getPotionID:change id in [0 - 255]");
            super.visitFieldInsn(opcode, owner, name, desc);
            super.visitIntInsn(17, 256);
            super.visitInsn(96);
            super.visitIntInsn(17, 256);
            super.visitInsn(112);
        }
    }

    class CustomMethodVisitor2
    extends MethodVisitor {
        String fieldName;
        static final String TARGET_DESC = "(Ljava/lang/String;)B";

        public CustomMethodVisitor2(int api, MethodVisitor mv) {
            super(api, mv);
            this.fieldName = "";
        }

        public void visitLdcInsn(Object cst) {
            if (cst.equals("Id")) {
                this.fieldName = (String)cst;
            }
            super.visitLdcInsn(cst);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            super.visitMethodInsn(opcode, owner, name, desc);
            if (opcode == 182 && TARGET_DESC.equals(desc) && this.fieldName.equals("Id")) {
                AppleMilkCorePlugin.logger.info("readCustomPotionEffectFromNBT:change id in [0 - 255]");
                super.visitIntInsn(17, 256);
                super.visitInsn(96);
                super.visitIntInsn(17, 256);
                super.visitInsn(112);
            }
        }
    }

    class CustomMethodVisitor1
    extends MethodVisitor {
        boolean check;

        public CustomMethodVisitor1(int api, MethodVisitor mv) {
            super(api, mv);
            this.check = false;
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (opcode == 180 && desc.equals("I") && !this.check) {
                this.check = true;
                AppleMilkCorePlugin.logger.info("onUpdate:change id in [0 - 255]");
                super.visitVarInsn(25, 0);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/potion/PotionEffect", "field_76462_a", "I");
                super.visitIntInsn(17, 256);
                super.visitInsn(96);
                super.visitIntInsn(17, 256);
                super.visitInsn(112);
                super.visitFieldInsn(181, "net/minecraft/potion/PotionEffect", "field_76462_a", "I");
            }
            super.visitFieldInsn(opcode, owner, name, desc);
        }
    }

    class CustomVisitor
    extends ClassVisitor {
        String owner;
        static final String TARGET_METHOD_NAME1 = "func_76455_a";
        static final String TARGET_METHOD_NAME_DEBUG1 = "onUpdate";
        static final String TARGET_METHOD_DESC1 = "(Lnet/minecraft/entity/EntityLivingBase;)Z";
        static final String TARGET_METHOD_NAME2 = "func_82722_b";
        static final String TARGET_METHOD_NAME_DEBUG2 = "readCustomPotionEffectFromNBT";
        static final String TARGET_METHOD_DESC2 = "(Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/potion/PotionEffect;";
        static final String TARGET_METHOD_NAME3 = "func_76456_a";
        static final String TARGET_METHOD_NAME_DEBUG3 = "getPotionID";
        static final String TARGET_METHOD_DESC3 = "()I";

        public CustomVisitor(String owner, ClassVisitor cv) {
            super(262144, cv);
            this.owner = owner;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (TARGET_METHOD_NAME1.equals(FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(this.owner, name, desc)) && TARGET_METHOD_DESC1.equals(FMLDeobfuscatingRemapper.INSTANCE.mapMethodDesc(desc))) {
                AppleMilkCorePlugin.logger.info("Transforming onUpdate method");
                return new CustomMethodVisitor1(this.api, super.visitMethod(access, name, desc, signature, exceptions));
            }
            if (TARGET_METHOD_NAME2.equals(FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(this.owner, name, desc)) && TARGET_METHOD_DESC2.equals(FMLDeobfuscatingRemapper.INSTANCE.mapMethodDesc(desc))) {
                AppleMilkCorePlugin.logger.info("Transforming readCustomPotionEffectFromNBT method");
                return new CustomMethodVisitor2(this.api, super.visitMethod(access, name, desc, signature, exceptions));
            }
            if (TARGET_METHOD_NAME3.equals(FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(this.owner, name, desc)) && TARGET_METHOD_DESC3.equals(FMLDeobfuscatingRemapper.INSTANCE.mapMethodDesc(desc))) {
                AppleMilkCorePlugin.logger.info("Transforming getPotionID method");
                return new CustomMethodVisitor3(this.api, super.visitMethod(access, name, desc, signature, exceptions));
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

