/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.api.energy;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.defeatedcrow.api.energy.IBattery;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;

public abstract class BatteryItemBase
extends Item
implements IBattery {
    @Override
    public int getChargeAmount(ItemStack item) {
        NBTTagCompound nbt = item.func_77978_p();
        if (nbt != null && nbt.func_74764_b("charge")) {
            int charge = nbt.func_74762_e("charge");
            return charge;
        }
        return 0;
    }

    @Override
    public abstract int getMaxAmount(ItemStack var1);

    @Override
    public boolean isFullCharged(ItemStack item) {
        NBTTagCompound nbt = item.func_77978_p();
        if (nbt != null && nbt.func_74764_b("charge")) {
            int charge = nbt.func_74762_e("charge");
            return charge >= this.getMaxAmount(item);
        }
        return false;
    }

    @Override
    public int charge(ItemStack item, int amount, boolean flag) {
        if (item == null) {
            return 0;
        }
        NBTTagCompound nbt = item.func_77978_p();
        int charge = 0;
        int increase = 0;
        if (nbt != null && nbt.func_74764_b("charge")) {
            charge = nbt.func_74762_e("charge");
        }
        int i = this.getMaxAmount(item) - charge;
        Math.min(i, 0);
        increase = Math.min(amount, i);
        if (flag) {
            if (nbt != null) {
                nbt.func_74768_a("charge", charge + increase);
                item.func_77982_d(nbt);
            } else {
                NBTTagCompound nbt2 = new NBTTagCompound();
                nbt2.func_74768_a("charge", charge + increase);
                item.func_77982_d(nbt2);
            }
        }
        return increase;
    }

    @Override
    public int discharge(ItemStack item, int amount, boolean flag) {
        if (item == null) {
            return 0;
        }
        NBTTagCompound nbt = item.func_77978_p();
        int charge = 0;
        int reduce = 0;
        if (nbt != null && nbt.func_74764_b("charge")) {
            charge = nbt.func_74762_e("charge");
        }
        reduce = Math.min(amount, charge);
        if (flag) {
            if (nbt != null) {
                nbt.func_74768_a("charge", charge - reduce);
                item.func_77982_d(nbt);
            } else {
                NBTTagCompound nbt2 = new NBTTagCompound();
                nbt2.func_74768_a("charge", charge - reduce);
                item.func_77982_d(nbt2);
            }
        }
        return reduce;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        NBTTagCompound nbt = par1ItemStack.func_77978_p();
        int charge = 0;
        int max = this.getMaxAmount(par1ItemStack);
        if (nbt != null && nbt.func_74764_b("charge")) {
            charge = nbt.func_74762_e("charge");
        }
        String s = new String("charge amount : " + charge + "/" + max);
        par3List.add(s);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        int charge = 0;
        int max = this.getMaxAmount(stack);
        if (nbt != null && nbt.func_74764_b("charge")) {
            charge = nbt.func_74762_e("charge");
            charge = MathHelper.func_76125_a((int)charge, (int)0, (int)max);
        }
        int i = max - charge;
        return (double)i / (double)max;
    }
}

