/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.util;

import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.util.ForgeDirection;

public class MotorPlacement {
    public static int getPlacementRotation(MovingObjectPosition mop) {
        ForgeDirection faceHit = ForgeDirection.getOrientation((int)mop.field_72310_e);
        double x = 0.0;
        double z = 0.0;
        switch (faceHit) {
            case UP: 
            case DOWN: {
                x = mop.field_72307_f.field_72450_a % 1.0;
                z = mop.field_72307_f.field_72449_c % 1.0;
                break;
            }
            case EAST: 
            case WEST: {
                x = mop.field_72307_f.field_72448_b % 1.0;
                z = mop.field_72307_f.field_72449_c % 1.0;
                break;
            }
            case NORTH: 
            case SOUTH: {
                x = mop.field_72307_f.field_72450_a % 1.0;
                z = mop.field_72307_f.field_72448_b % 1.0;
                break;
            }
        }
        if (x < 0.0) {
            x = 1.0 + x;
        }
        if (z < 0.0) {
            z = 1.0 + z;
        }
        x -= 0.5;
        if ((z -= 0.5) > 0.0 && z > Math.abs(x)) {
            return 0;
        }
        if (x > 0.0 && x > Math.abs(z)) {
            return 3;
        }
        if (z < 0.0 && Math.abs(z) > Math.abs(x)) {
            return 2;
        }
        return 1;
    }

    public static ForgeDirection getPlacementDirection(MovingObjectPosition mop, ForgeDirection face) {
        int r = MotorPlacement.getPlacementRotation(mop);
        ForgeDirection d = null;
        switch (face) {
            case UP: 
            case DOWN: {
                d = ForgeDirection.SOUTH;
                break;
            }
            case EAST: 
            case WEST: {
                r = (r + 1) % 4;
            }
            case NORTH: 
            case SOUTH: {
                d = ForgeDirection.UP;
                if (r != 1 && r != 3) break;
                r = (r + 2) % 4;
                break;
            }
        }
        ForgeDirection faceAbs = face;
        if (faceAbs.offsetX + faceAbs.offsetY + faceAbs.offsetZ < 0) {
            faceAbs = faceAbs.getOpposite();
        }
        for (int i = 0; i < r; ++i) {
            d = d.getRotation(faceAbs);
        }
        return d;
    }
}

