/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.tile;

import codechicken.lib.raytracer.RayTracer;
import com.amadornes.framez.Framez;
import com.amadornes.framez.init.FramezBlocks;
import com.amadornes.framez.movement.MovingBlock;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileMoving
extends TileEntity {
    private MovingBlock blockA;
    private MovingBlock blockB;
    private UpdateType type;
    private boolean needsUpdate = false;

    public void func_145845_h() {
        if (this.blockA != null) {
            if (this.blockA.getTileEntity() != null) {
                this.blockA.getTileEntity().func_145845_h();
            }
            if (this.blockA.getMoved() >= 1.0) {
                this.blockA = null;
            }
        }
        if (this.blockB != null && this.blockB.getMoved() >= 1.0) {
            this.blockB = null;
        }
        if (this.blockA == null && this.blockB == null) {
            if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) == FramezBlocks.moving) {
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150350_a, 0, 0);
            }
            this.func_145843_s();
        }
        if (this.needsUpdate) {
            this.sendUpdatePacket(UpdateType.ALL);
            this.needsUpdate = false;
        }
    }

    public void setBlockA(MovingBlock blockA) {
        this.blockA = blockA;
        this.needsUpdate = true;
    }

    public void setBlockB(MovingBlock blockB) {
        this.blockB = blockB;
    }

    public MovingBlock getBlockA() {
        return this.blockA;
    }

    public MovingBlock getBlockB() {
        return this.blockB;
    }

    public void addCollisionBoxesToList(AxisAlignedBB aabb, List l, Entity e) {
        if (this.blockA != null) {
            ArrayList lA = new ArrayList();
            this.blockA.getBlock().func_149743_a(this.blockA.getWorldWrapper(), this.blockA.getLocation().x, this.blockA.getLocation().y, this.blockA.getLocation().z, aabb, lA, e);
            for (Object o : lA) {
                AxisAlignedBB b = ((AxisAlignedBB)o).func_72329_c();
                b.field_72340_a += (double)this.blockA.getDirection().offsetX * this.blockA.getMoved();
                b.field_72338_b += (double)this.blockA.getDirection().offsetY * this.blockA.getMoved();
                b.field_72339_c += (double)this.blockA.getDirection().offsetZ * this.blockA.getMoved();
                b.field_72336_d += (double)this.blockA.getDirection().offsetX * this.blockA.getMoved();
                b.field_72337_e += (double)this.blockA.getDirection().offsetY * this.blockA.getMoved();
                b.field_72334_f += (double)this.blockA.getDirection().offsetZ * this.blockA.getMoved();
                if (!aabb.func_72326_a(b)) continue;
                l.add(b);
            }
        }
        if (this.blockB != null) {
            AxisAlignedBB aabb2 = aabb.func_72329_c();
            aabb2.field_72340_a -= (double)this.blockB.getDirection().offsetX;
            aabb2.field_72338_b -= (double)this.blockB.getDirection().offsetY;
            aabb2.field_72339_c -= (double)this.blockB.getDirection().offsetZ;
            aabb2.field_72336_d -= (double)this.blockB.getDirection().offsetX;
            aabb2.field_72337_e -= (double)this.blockB.getDirection().offsetY;
            aabb2.field_72334_f -= (double)this.blockB.getDirection().offsetZ;
            ArrayList lB = new ArrayList();
            this.blockB.getBlock().func_149743_a(this.blockB.getWorldWrapper(), this.blockB.getLocation().x, this.blockB.getLocation().y, this.blockB.getLocation().z, aabb2, lB, e);
            for (Object o : lB) {
                AxisAlignedBB b = ((AxisAlignedBB)o).func_72329_c();
                b.field_72340_a -= -this.blockB.getMoved() * (double)this.blockB.getDirection().offsetX;
                b.field_72338_b -= -this.blockB.getMoved() * (double)this.blockB.getDirection().offsetY;
                b.field_72339_c -= -this.blockB.getMoved() * (double)this.blockB.getDirection().offsetZ;
                b.field_72336_d -= -this.blockB.getMoved() * (double)this.blockB.getDirection().offsetX;
                b.field_72337_e -= -this.blockB.getMoved() * (double)this.blockB.getDirection().offsetY;
                b.field_72334_f -= -this.blockB.getMoved() * (double)this.blockB.getDirection().offsetZ;
                if (!aabb.func_72326_a(b)) continue;
                l.add(b);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getSelectedBoundingBox() {
        AxisAlignedBB b;
        World w;
        if (this.blockA != null) {
            MovingBlock blockA = this.blockA;
            if (blockA.getTileEntity() != null) {
                blockA.getTileEntity().func_145834_a(this.field_145850_b);
            }
            w = Framez.proxy.getWorld();
            Framez.proxy.getPlayer().field_70170_p = blockA.getWorldWrapper();
            b = blockA.getBlock().func_149633_g(blockA.getWorldWrapper(), blockA.getLocation().x, blockA.getLocation().y, blockA.getLocation().z);
            Framez.proxy.getPlayer().field_70170_p = w;
            if (b != null) {
                b = b.func_72329_c();
                b.field_72340_a += (double)blockA.getDirection().offsetX * (blockA.getMoved() - blockA.getSpeed() * (1.0 - Framez.proxy.getFrame()));
                b.field_72338_b += (double)blockA.getDirection().offsetY * (blockA.getMoved() - blockA.getSpeed() * (1.0 - Framez.proxy.getFrame()));
                b.field_72339_c += (double)blockA.getDirection().offsetZ * (blockA.getMoved() - blockA.getSpeed() * (1.0 - Framez.proxy.getFrame()));
                b.field_72336_d += (double)blockA.getDirection().offsetX * (blockA.getMoved() - blockA.getSpeed() * (1.0 - Framez.proxy.getFrame()));
                b.field_72337_e += (double)blockA.getDirection().offsetY * (blockA.getMoved() - blockA.getSpeed() * (1.0 - Framez.proxy.getFrame()));
                b.field_72334_f += (double)blockA.getDirection().offsetZ * (blockA.getMoved() - blockA.getSpeed() * (1.0 - Framez.proxy.getFrame()));
                if (blockA.getTileEntity() != null) {
                    blockA.getTileEntity().func_145834_a(blockA.getWorldWrapper());
                }
                return b;
            }
            if (blockA.getTileEntity() != null) {
                blockA.getTileEntity().func_145834_a(blockA.getWorldWrapper());
            }
        }
        if (this.blockB != null) {
            MovingBlock blockB = this.blockB;
            if (blockB.getTileEntity() != null) {
                blockB.getTileEntity().func_145834_a(this.field_145850_b);
            }
            w = Framez.proxy.getWorld();
            Framez.proxy.getPlayer().field_70170_p = blockB.getWorldWrapper();
            b = blockB.getBlock().func_149633_g(blockB.getWorldWrapper(), blockB.getLocation().x, blockB.getLocation().y, blockB.getLocation().z);
            Framez.proxy.getPlayer().field_70170_p = w;
            if (b != null) {
                b = b.func_72329_c();
                b.field_72340_a += (double)blockB.getDirection().offsetX * (blockB.getMoved() - blockB.getSpeed() * (1.0 - Framez.proxy.getFrame()));
                b.field_72338_b += (double)blockB.getDirection().offsetY * (blockB.getMoved() - blockB.getSpeed() * (1.0 - Framez.proxy.getFrame()));
                b.field_72339_c += (double)blockB.getDirection().offsetZ * (blockB.getMoved() - blockB.getSpeed() * (1.0 - Framez.proxy.getFrame()));
                b.field_72336_d += (double)blockB.getDirection().offsetX * (blockB.getMoved() - blockB.getSpeed() * (1.0 - Framez.proxy.getFrame()));
                b.field_72337_e += (double)blockB.getDirection().offsetY * (blockB.getMoved() - blockB.getSpeed() * (1.0 - Framez.proxy.getFrame()));
                b.field_72334_f += (double)blockB.getDirection().offsetZ * (blockB.getMoved() - blockB.getSpeed() * (1.0 - Framez.proxy.getFrame()));
                if (blockB.getTileEntity() != null) {
                    blockB.getTileEntity().func_145834_a(blockB.getWorldWrapper());
                }
                return b;
            }
            if (blockB.getTileEntity() != null) {
                blockB.getTileEntity().func_145834_a(blockB.getWorldWrapper());
            }
        }
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public MovingObjectPosition rayTrace(Vec3 start, Vec3 end) {
        Vec3 end2;
        Vec3 start2;
        MovingObjectPosition mopA = null;
        MovingObjectPosition mopB = null;
        if (this.blockA != null) {
            MovingBlock blockA = this.blockA;
            start2 = start.func_72441_c((double)blockA.getDirection().offsetX * -blockA.getMoved(), (double)blockA.getDirection().offsetY * -blockA.getMoved(), (double)blockA.getDirection().offsetZ * -blockA.getMoved());
            end2 = end.func_72441_c((double)blockA.getDirection().offsetX * -blockA.getMoved(), (double)blockA.getDirection().offsetY * -blockA.getMoved(), (double)blockA.getDirection().offsetZ * -blockA.getMoved());
            mopA = blockA.getBlock().func_149731_a(blockA.getWorldWrapper(), blockA.getLocation().x, blockA.getLocation().y, blockA.getLocation().z, start2, end2);
            if (mopA != null) {
                mopA.hitInfo = blockA;
            }
        }
        if (this.blockB != null) {
            MovingBlock blockB = this.blockB;
            start2 = start.func_72441_c((double)blockB.getDirection().offsetX * -blockB.getMoved(), (double)blockB.getDirection().offsetY * -blockB.getMoved(), (double)blockB.getDirection().offsetZ * -blockB.getMoved());
            end2 = end.func_72441_c((double)blockB.getDirection().offsetX * -blockB.getMoved(), (double)blockB.getDirection().offsetY * -blockB.getMoved(), (double)blockB.getDirection().offsetZ * -blockB.getMoved());
            mopB = blockB.getBlock().func_149731_a(blockB.getWorldWrapper(), blockB.getLocation().x, blockB.getLocation().y, blockB.getLocation().z, start2, end2);
            if (mopB != null) {
                mopB.hitInfo = blockB;
            }
        }
        if (mopA == null && mopB == null) {
            return null;
        }
        if (mopA != null && mopB == null) {
            return mopA;
        }
        if (mopB != null && mopA == null) {
            return mopB;
        }
        if (mopA.field_72307_f.func_72438_d(start) < mopB.field_72307_f.func_72438_d(start)) {
            return mopA;
        }
        return mopB;
    }

    public MovingObjectPosition rayTrace(EntityPlayer player) {
        return this.rayTrace(RayTracer.getStartVec((EntityPlayer)player), RayTracer.getEndVec((EntityPlayer)player));
    }

    public MovingBlock getSelected(MovingObjectPosition mop) {
        if (mop == null) {
            return null;
        }
        if (mop.hitInfo != null && mop.hitInfo instanceof MovingBlock) {
            return (MovingBlock)mop.hitInfo;
        }
        return null;
    }

    public MovingBlock getSelected(EntityPlayer player) {
        return this.getSelected(this.rayTrace(player));
    }

    public boolean onBlockActivated(EntityPlayer player) {
        MovingObjectPosition mop = this.rayTrace(player);
        MovingBlock b = this.getSelected(mop);
        if (b == null) {
            return false;
        }
        boolean result = b.getBlock().func_149727_a(b.getWorldWrapper(), b.getLocation().x, b.getLocation().y, b.getLocation().z, player, mop.field_72310_e, (float)mop.field_72307_f.field_72450_a - (float)mop.field_72311_b, (float)mop.field_72307_f.field_72448_b - (float)mop.field_72312_c, (float)mop.field_72307_f.field_72449_c - (float)mop.field_72309_d);
        this.sendUpdatePacket(UpdateType.ALL);
        return result;
    }

    public int getLightValue() {
        int a = 0;
        int b = 0;
        if (this.blockA != null) {
            a = this.blockA.getBlock().getLightValue((IBlockAccess)this.blockA.getWorldWrapper(), this.blockA.getLocation().x, this.blockA.getLocation().y, this.blockA.getLocation().z);
        }
        if (this.blockB != null) {
            b = this.blockB.getBlock().getLightValue((IBlockAccess)this.blockB.getWorldWrapper(), this.blockB.getLocation().x, this.blockB.getLocation().y, this.blockB.getLocation().z);
        }
        return Math.max(a, b);
    }

    public int getLightOpacity() {
        return 0;
    }

    public void randomDisplayTick(Random rnd) {
        if (this.blockA != null) {
            this.blockA.getBlock().func_149734_b(this.blockA.getWorldWrapper(), this.blockA.getLocation().x, this.blockA.getLocation().y, this.blockA.getLocation().z, rnd);
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target) {
        MovingObjectPosition mop = this.rayTrace(Framez.proxy.getPlayer());
        if (mop == null) {
            return null;
        }
        MovingBlock block = this.getSelected(mop);
        if (block == null) {
            return null;
        }
        return block.getBlock().getPickBlock(mop, block.getWorldWrapper(), block.getX(), block.getY(), block.getZ());
    }

    public void sendUpdatePacket(UpdateType type) {
        this.type = type;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.blockA != null && this.type != null && this.type.isBlock()) {
            GameRegistry.UniqueIdentifier ui = GameRegistry.findUniqueIdentifierFor((Block)this.blockA.getBlock());
            tag.func_74778_a("mod", ui.modId);
            tag.func_74778_a("block", ui.name);
            tag.func_74768_a("meta", this.blockA.getMetadata());
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        if (this.blockA == null) {
            return;
        }
        if (tag.func_74764_b("block")) {
            Block bl = GameRegistry.findBlock((String)tag.func_74779_i("mod"), (String)tag.func_74779_i("block"));
            if (this.blockA.getBlock() != bl) {
                this.blockA.setBlock(bl);
            }
            int meta = tag.func_74762_e("meta");
            if (this.blockA.getMetadata() != meta) {
                this.blockA.setMetadata(meta);
            }
            this.blockA.setRenderList(-1);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.blockA != null) {
            TileEntity te = this.blockA.getTileEntity();
            if (te != null) {
                return te.getRenderBoundingBox().func_72329_c().func_72317_d((double)this.blockA.getDirection().offsetX * this.blockA.getMoved(), (double)this.blockA.getDirection().offsetY * this.blockA.getMoved(), (double)this.blockA.getDirection().offsetZ * this.blockA.getMoved());
            }
            return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72317_d((double)this.blockA.getDirection().offsetX * this.blockA.getMoved(), (double)this.blockA.getDirection().offsetY * this.blockA.getMoved(), (double)this.blockA.getDirection().offsetZ * this.blockA.getMoved());
        }
        return super.getRenderBoundingBox();
    }

    public static enum UpdateType {
        BLOCK(true, false),
        TILE(false, true),
        ALL(true, true);

        private boolean block;
        private boolean tile;

        private UpdateType(boolean block, boolean tile) {
            this.block = block;
            this.tile = tile;
        }

        public boolean isBlock() {
            return this.block;
        }

        public boolean isTile() {
            return this.tile;
        }
    }
}

