/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.tile;

import codechicken.lib.vec.BlockCoord;
import com.amadornes.framez.api.movement.IFrameMove;
import com.amadornes.framez.config.Config;
import com.amadornes.framez.movement.MotorCache;
import com.amadornes.framez.movement.MovementUtils;
import com.amadornes.framez.movement.MovingStructure;
import com.amadornes.framez.movement.StructureTickHandler;
import com.amadornes.framez.network.NetworkHandler;
import com.amadornes.framez.network.packet.PacketStartMoving;
import com.amadornes.framez.world.WorldWrapperProvider;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileMotor
extends TileEntity
implements IFrameMove {
    public static TileMotor active = null;
    private ForgeDirection face = ForgeDirection.DOWN;
    private ForgeDirection direction = ForgeDirection.SOUTH;
    private MovingStructure structure = null;
    private String placer = "";
    private boolean canMove = false;
    private List<BlockCoord> movedBlocks = null;
    private int lastCheck = 0;
    protected double stored = 0.0;
    protected double maxStored = 100000.0;
    private BlockCoord blockingCoord = null;

    public abstract boolean shouldMove();

    public abstract double getMovementSpeed();

    public void consumeFramezPower(double power) {
        this.stored -= power;
    }

    public boolean hasEnoughFramezPower(double power) {
        return this.stored >= power;
    }

    public Object getExtraInfo() {
        return null;
    }

    public ForgeDirection getFace() {
        return this.face;
    }

    public ForgeDirection getDirection() {
        return this.direction;
    }

    public boolean setFace(ForgeDirection face) {
        return this.setFace(face, false);
    }

    public boolean setFace(ForgeDirection face, boolean force) {
        if (this.structure != null) {
            return false;
        }
        if (face == null) {
            return false;
        }
        if (!(face != this.direction && face != this.direction.getOpposite() || force)) {
            return false;
        }
        this.face = face;
        this.sendUpdatePacket();
        return true;
    }

    public boolean setDirection(ForgeDirection direction) {
        return this.setDirection(direction, false);
    }

    public boolean setDirection(ForgeDirection direction, boolean force) {
        if (this.structure != null) {
            return false;
        }
        if (direction == null) {
            return false;
        }
        if (!(direction != this.face && direction != this.face.getOpposite() || force)) {
            return false;
        }
        this.direction = direction;
        this.sendUpdatePacket();
        return true;
    }

    public double getMoved() {
        return this.structure == null ? 0.0 : this.structure.getMoved();
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.writeUpdatePacket(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readUpdatePacket(tag);
    }

    public void writeUpdatePacket(NBTTagCompound tag) {
        tag.func_74768_a("face", this.getFace().ordinal());
        tag.func_74768_a("direction", this.getDirection().ordinal());
        tag.func_74778_a("placer", this.placer);
        tag.func_74780_a("stored", this.stored);
        if (this.blockingCoord != null) {
            tag.func_74768_a("blockingX", this.blockingCoord.x);
            tag.func_74768_a("blockingY", this.blockingCoord.y);
            tag.func_74768_a("blockingZ", this.blockingCoord.z);
        }
    }

    public void readUpdatePacket(NBTTagCompound tag) {
        this.face = ForgeDirection.getOrientation((int)tag.func_74762_e("face"));
        this.direction = ForgeDirection.getOrientation((int)tag.func_74762_e("direction"));
        this.placer = tag.func_74779_i("placer");
        this.stored = tag.func_74769_h("stored");
        this.blockingCoord = tag.func_74764_b("blockingX") ? new BlockCoord(tag.func_74762_e("blockingX"), tag.func_74762_e("blockingY"), tag.func_74762_e("blockingZ")) : null;
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeUpdatePacket(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readUpdatePacket(pkt.func_148857_g());
        this.func_145831_w().func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void sendUpdatePacket() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        MotorCache.loadMotor(this);
        if (!this.field_145850_b.field_72995_K) {
            ++this.lastCheck;
            if (this.lastCheck == 10) {
                this.lastCheck = 0;
                this.checkIfCanMove();
            }
        }
        if (this.shouldMove()) {
            this.move();
        }
        if (this.structure != null && this.structure.getMoved() >= 1.0) {
            this.structure = null;
        }
    }

    public MovingStructure getStructure() {
        return this.structure;
    }

    public void setStructure(MovingStructure structure) {
        this.structure = structure;
    }

    @Override
    public boolean canBeMoved(ForgeDirection face, ForgeDirection direction) {
        return this.structure == null && face != this.getFace();
    }

    public boolean move() {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        if (this.structure != null) {
            return false;
        }
        if (this.lastCheck > 0) {
            this.checkIfCanMove();
        }
        if (this.canMove) {
            List<BlockCoord> blocks = this.movedBlocks;
            double power = 0.0;
            power += Config.PowerUsage.getPowerUsedPerMove;
            for (BlockCoord b : blocks) {
                power += Config.PowerUsage.getPowerUsedPerBlock;
                if (this.func_145831_w().func_147438_o(b.x, b.y, b.z) == null) continue;
                power += Config.PowerUsage.getPowerUsedPerTileEntity;
            }
            if (this.hasEnoughFramezPower(power)) {
                MovingStructure structure = new MovingStructure(this.field_145850_b, this.direction, this.getMovementSpeed() / 20.0);
                structure.addBlocks(blocks);
                this.structure = structure;
                StructureTickHandler.INST.addStructure(structure);
                NetworkHandler.sendToDimension(new PacketStartMoving(this), this.field_145850_b.field_73011_w.field_76574_g);
                this.consumeFramezPower(power);
                this.sendUpdatePacket();
                return true;
            }
        }
        return false;
    }

    private void checkIfCanMove() {
        List<BlockCoord> blocks;
        active = this;
        this.setBlockingCoord(null);
        this.canMove = false;
        this.movedBlocks = null;
        if (this.field_145850_b == WorldWrapperProvider.getWrapper(this.field_145850_b.field_73011_w.field_76574_g)) {
            return;
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c + this.face.offsetX, this.field_145848_d + this.face.offsetY, this.field_145849_e + this.face.offsetZ) != Blocks.field_150350_a && (blocks = (this.movedBlocks = MovementUtils.getMovedBlocks(this))).size() > 0 && MovementUtils.canMove(blocks, this.func_145831_w(), this.direction)) {
            this.canMove = true;
            return;
        }
        this.movedBlocks = null;
        active = null;
    }

    public boolean canMove() {
        return this.canMove;
    }

    public final int getColorMultiplier() {
        return TileMotor.getColorMultiplierForPlayer(this.placer);
    }

    public static final int getColorMultiplierForPlayer(String placer) {
        if (placer.equals("amadornes")) {
            return 0xCC0000;
        }
        if (placer.equals("KrystalRaven")) {
            return 5308595;
        }
        if (placer.equals("Quetzz")) {
            return 4464276;
        }
        if (placer.equals("PurpleMentat")) {
            return 0xAA00AA;
        }
        if (placer.equals("Aureylian")) {
            return 0xEEAAAA;
        }
        if (placer.equals("Loneztar")) {
            return 0xEEAAAA;
        }
        return 0xAA0000;
    }

    public void setPlacer(String placer) {
        this.placer = placer;
    }

    public String getPlacer() {
        return this.placer;
    }

    protected boolean isBeingPowered() {
        return this.field_145850_b.func_94577_B(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0 || this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onUnload();
        MotorCache.unloadMotor(this);
    }

    public void onUnload() {
        if (this.structure != null) {
            this.structure.finishMoving();
            StructureTickHandler.INST.removeStructure(this.structure);
            this.structure = null;
        }
    }

    public BlockCoord getBlockingCoord() {
        return this.blockingCoord;
    }

    public void setBlockingCoord(BlockCoord blockingCoord) {
        this.blockingCoord = blockingCoord;
        this.sendUpdatePacket();
    }
}

