/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.network.packet;

import codechicken.lib.vec.BlockCoord;
import com.amadornes.framez.movement.MovingBlock;
import com.amadornes.framez.movement.MovingStructure;
import com.amadornes.framez.movement.StructureTickHandler;
import com.amadornes.framez.network.LocatedPacket;
import com.amadornes.framez.tile.TileMotor;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketStartMoving
extends LocatedPacket<PacketStartMoving> {
    private List<BlockCoord> blocks = new ArrayList<BlockCoord>();
    private double speed = 0.0;
    private ForgeDirection direction = ForgeDirection.SOUTH;

    public PacketStartMoving(TileMotor motor) {
        super(motor.field_145851_c, motor.field_145848_d, motor.field_145849_e);
        for (MovingBlock b : motor.getStructure().getBlocks()) {
            this.blocks.add(b.getLocation());
        }
        this.speed = motor.getStructure().getSpeed();
        this.direction = motor.getDirection();
    }

    public PacketStartMoving() {
    }

    @Override
    public void handleClientSide(PacketStartMoving message, EntityPlayer player) {
        TileEntity te = player.field_70170_p.func_147438_o(this.x, this.y, this.z);
        if (te != null && te instanceof TileMotor) {
            TileMotor motor = (TileMotor)te;
            MovingStructure structure = new MovingStructure(player.field_70170_p, this.direction, this.speed);
            structure.addBlocks(this.blocks);
            if (motor != null) {
                motor.setStructure(structure);
            }
            StructureTickHandler.INST.addStructure(structure);
            structure.tick(TickEvent.Phase.START);
        }
    }

    @Override
    public void handleServerSide(PacketStartMoving message, EntityPlayer player) {
    }

    @Override
    public void write(NBTTagCompound tag) {
        super.write(tag);
        NBTTagList list = new NBTTagList();
        for (BlockCoord b : this.blocks) {
            NBTTagCompound block = new NBTTagCompound();
            block.func_74768_a("x", b.x);
            block.func_74768_a("y", b.y);
            block.func_74768_a("z", b.z);
            list.func_74742_a((NBTBase)block);
        }
        tag.func_74782_a("blocks", (NBTBase)list);
        tag.func_74780_a("speed", this.speed);
        tag.func_74768_a("direction", this.direction.ordinal());
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        NBTTagList list = tag.func_150295_c("blocks", (int)new NBTTagCompound().func_74732_a());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound t = list.func_150305_b(i);
            this.blocks.add(new BlockCoord(t.func_74762_e("x"), t.func_74762_e("y"), t.func_74762_e("z")));
        }
        this.speed = tag.func_74769_h("speed");
        this.direction = ForgeDirection.getOrientation((int)tag.func_74762_e("direction"));
    }
}

