/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.movement;

import com.amadornes.framez.Framez;
import com.amadornes.framez.movement.MovedBlockHandler;
import com.amadornes.framez.movement.MovingStructure;
import com.amadornes.framez.tile.TileMotor;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class StructureTickHandler {
    public static StructureTickHandler INST = new StructureTickHandler();
    private List<MovingStructure> structures = new ArrayList<MovingStructure>();
    public MovingStructure tickingStructure = null;

    private StructureTickHandler() {
    }

    public void addStructure(MovingStructure structure) {
        this.structures.add(structure);
    }

    public void removeStructure(MovingStructure structure) {
        this.structures.remove(structure);
    }

    public List<MovingStructure> getStructures() {
        return this.structures;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (Framez.proxy.isGamePaused()) {
            return;
        }
        for (WorldServer w : MinecraftServer.func_71276_C().field_71305_c) {
            this.tick((World)w, event.phase);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (Framez.proxy.isGamePaused()) {
            return;
        }
        this.tick(Framez.proxy.getWorld(), event.phase);
    }

    private void tick(World world, TickEvent.Phase phase) {
        if (world == null) {
            return;
        }
        if (phase == TickEvent.Phase.START) {
            MovedBlockHandler.worldTick(world);
        }
        ArrayList<MovingStructure> invalid = new ArrayList<MovingStructure>();
        for (MovingStructure s : new ArrayList<MovingStructure>(this.structures)) {
            if (s.getWorld() != world) continue;
            this.tickingStructure = s;
            s.tick(phase);
            this.tickingStructure = null;
            if (!(s.getMoved() >= 1.0)) continue;
            invalid.add(s);
        }
        for (MovingStructure s : invalid) {
            this.structures.remove(s);
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        if (event.world.field_72995_K) {
            return;
        }
        for (Object o : event.getChunk().field_150816_i.values()) {
            TileEntity te = (TileEntity)o;
            if (!(te instanceof TileMotor)) continue;
            ((TileMotor)te).onUnload();
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (!(event.world instanceof WorldServer)) {
            return;
        }
        WorldServer world = (WorldServer)event.world;
        boolean found = false;
        ArrayList<TileMotor> unloaded = new ArrayList<TileMotor>();
        for (Object o : new ArrayList(world.field_147482_g)) {
            TileEntity te = (TileEntity)o;
            if (!(te instanceof TileMotor) || unloaded.contains(te)) continue;
            ((TileMotor)te).onUnload();
            found = true;
            unloaded.add((TileMotor)te);
        }
        if (found) {
            Framez.log.info("Saving moving structures in dimension " + world.field_73011_w.field_76574_g + " (" + world.field_73011_w.func_80007_l() + ")");
            try {
                world.func_73044_a(true, new IProgressUpdate(){

                    public void func_73718_a(int p_73718_1_) {
                    }

                    public void func_73721_b(String p_73721_1_) {
                    }

                    public void func_73719_c(String p_73719_1_) {
                    }

                    public void func_146586_a() {
                    }

                    public void func_73720_a(String p_73720_1_) {
                    }
                });
                Framez.log.info("Saved moving structures in dimension " + world.field_73011_w.field_76574_g + "!");
            }
            catch (MinecraftException e) {
                Framez.log.info("Could not save moving structures in dimension " + world.field_73011_w.field_76574_g + "!");
                e.printStackTrace();
            }
        }
    }
}

