/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.movement;

import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import com.amadornes.framez.api.movement.IMovingBlock;
import com.amadornes.framez.init.FramezBlocks;
import com.amadornes.framez.movement.MovementApi;
import com.amadornes.framez.movement.MovingStructure;
import com.amadornes.framez.tile.TileMoving;
import com.amadornes.framez.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MovingBlock
implements IMovingBlock {
    private World world;
    private BlockCoord loc;
    private Block block;
    private int meta;
    private TileEntity te;
    private MovingStructure structure;
    private TileMoving placeholder = null;
    private boolean isStored = false;
    private int renderList = -1;

    public MovingBlock(BlockCoord location, World world, MovingStructure structure) {
        this.loc = location;
        this.world = world;
        this.structure = structure;
    }

    public MovingBlock(int x, int y, int z, World world, MovingStructure structure) {
        this.loc = new BlockCoord(x, y, z);
        this.world = world;
        this.structure = structure;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public int getX() {
        return this.getLocation().x;
    }

    @Override
    public int getY() {
        return this.getLocation().y;
    }

    @Override
    public int getZ() {
        return this.getLocation().z;
    }

    public BlockCoord getLocation() {
        return this.loc;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public int getMetadata() {
        return this.meta;
    }

    @Override
    public TileEntity getTileEntity() {
        return this.te;
    }

    @Override
    public ForgeDirection getDirection() {
        return this.structure.getDirection();
    }

    @Override
    public double getMoved() {
        return this.structure.getMoved();
    }

    @Override
    public double getSpeed() {
        return this.structure.getSpeed();
    }

    @Override
    public World getWorldWrapper() {
        return this.structure.getWorldWrapper();
    }

    public MovingStructure getStructure() {
        return this.structure;
    }

    @Override
    public void setBlock(Block block) {
        this.block = block;
    }

    @Override
    public void setMetadata(int meta) {
        this.meta = meta;
    }

    @Override
    public void setTileEntity(TileEntity te) {
        this.te = te;
    }

    public void storeData() {
        this.te = this.world.func_147438_o(this.loc.x, this.loc.y, this.loc.z);
        this.block = this.world.func_147439_a(this.loc.x, this.loc.y, this.loc.z);
        this.meta = this.world.func_72805_g(this.loc.x, this.loc.y, this.loc.z);
    }

    public void remove() {
        if (!MovementApi.INST.handleRemoval(this)) {
            this.remove_do(true, true);
        }
        this.isStored = true;
    }

    public void place() {
        if (!MovementApi.INST.handlePlacement(this)) {
            this.place_do(true, true);
        }
        this.isStored = false;
    }

    @Override
    public void remove_do(boolean invalidate, boolean validate) {
        int x = this.getX();
        int y = this.getY();
        int z = this.getZ();
        TileEntity te = this.getTileEntity();
        if (te != null) {
            if (te instanceof TileMultipart && !this.getWorld().field_72995_K) {
                for (TMultiPart p : ((TileMultipart)te).jPartList()) {
                    p.onWorldSeparate();
                }
            }
            if (invalidate) {
                te.func_145843_s();
            }
        }
        BlockUtils.setBlockSneaky(this.getWorld(), x, y, z, Blocks.field_150350_a);
        if (te != null) {
            BlockUtils.removeTileEntity(this.getWorld(), x, y, z);
            te.func_145834_a(this.getWorldWrapper());
            if (validate && !(te instanceof TileMultipart)) {
                te.func_145829_t();
            }
            if (te instanceof TileMultipart && !this.getWorld().field_72995_K) {
                for (TMultiPart p : ((TileMultipart)te).jPartList()) {
                    p.onMoved();
                }
            }
        }
    }

    @Override
    public void place_do(boolean invalidate, boolean validate) {
        int x = this.getX() + this.getDirection().offsetX;
        int y = this.getY() + this.getDirection().offsetY;
        int z = this.getZ() + this.getDirection().offsetZ;
        TileEntity te = this.getTileEntity();
        BlockUtils.setBlockSneaky(this.world, x, y, z, this.getBlock());
        BlockUtils.setBlockMetadataSneaky(this.world, x, y, z, this.getMetadata());
        if (te != null) {
            if (te instanceof TileMultipart) {
                if (!this.getWorld().field_72995_K) {
                    TileMultipart tmp = TileMultipart.getTile((World)this.getWorld(), (BlockCoord)new BlockCoord(x, y, z));
                    if (tmp != null) {
                        tmp.clearParts();
                    }
                    for (TMultiPart p : ((TileMultipart)te).jPartList()) {
                        p.onWorldSeparate();
                        TileMultipart.addPart((World)this.getWorld(), (BlockCoord)new BlockCoord(x, y, z), (TMultiPart)p);
                        p.onMoved();
                    }
                }
            } else {
                if (invalidate && !(te instanceof TileMultipart)) {
                    te.func_145843_s();
                }
                te.field_145851_c = x;
                te.field_145848_d = y;
                te.field_145849_e = z;
                te.func_145834_a(this.getWorldWrapper());
                if (validate) {
                    te.func_145829_t();
                }
                if (this.getWorld().func_147438_o(x, y, z) != te) {
                    this.getWorld().func_147455_a(x, y, z, te);
                }
            }
        }
    }

    public void removePlaceholder() {
        if (this.placeholder == null) {
            return;
        }
        this.placeholder.setBlockA(null);
        MovingBlock b = this.structure.getBlock(this.loc.x + this.getDirection().offsetX, this.loc.y + this.getDirection().offsetY, this.loc.z + this.getDirection().offsetZ);
        if (b != null) {
            b.placeholder.setBlockB(null);
        }
    }

    public void placePlaceholder() {
        this.world.func_147465_d(this.loc.x, this.loc.y, this.loc.z, FramezBlocks.moving, 0, 0);
        TileMoving te = null;
        te = this.placeholder != null ? this.placeholder : (this.placeholder = new TileMoving());
        te.setBlockA(this);
        this.world.func_147455_a(this.loc.x, this.loc.y, this.loc.z, (TileEntity)te);
        TileMoving te2 = null;
        MovingBlock b = this.structure.getBlock(this.loc.x + this.getDirection().offsetX, this.loc.y + this.getDirection().offsetY, this.loc.z + this.getDirection().offsetZ);
        if (b != null) {
            te2 = b.placeholder == null ? (b.placeholder = new TileMoving()) : b.placeholder;
        } else {
            this.world.func_147465_d(this.loc.x + this.getDirection().offsetX, this.loc.y + this.getDirection().offsetY, this.loc.z + this.getDirection().offsetZ, FramezBlocks.moving, 0, 0);
            te2 = new TileMoving();
            this.world.func_147455_a(this.loc.x + this.getDirection().offsetX, this.loc.y + this.getDirection().offsetY, this.loc.z + this.getDirection().offsetZ, (TileEntity)te2);
        }
        te2.setBlockB(this);
    }

    public TileMoving getPlaceholder() {
        return this.placeholder;
    }

    public boolean isStored() {
        return this.isStored;
    }

    public int getRenderList() {
        return this.renderList;
    }

    public void setRenderList(int renderList) {
        this.renderList = renderList;
    }
}

