/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.modifier;

import com.amadornes.framez.api.IFrameModifier;
import com.amadornes.framez.api.IFrameModifierProvider;
import com.amadornes.framez.api.IModifierRegistry;
import com.amadornes.framez.client.IconProvider;
import com.amadornes.framez.init.FramezItems;
import com.amadornes.framez.util.SorterElementCount;
import com.amadornes.framez.util.SorterModifierProvider;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class ModifierRegistry
implements IModifierRegistry {
    public static final ModifierRegistry INST = new ModifierRegistry();
    private List<IFrameModifierProvider> providers = new ArrayList<IFrameModifierProvider>();
    private List<ItemStack> combinations = null;

    private ModifierRegistry() {
    }

    @Override
    public void registerModifierProvider(IFrameModifierProvider provider) {
        if (provider == null) {
            return;
        }
        if (this.getModifierProvider(provider.getIdentifier()) != null) {
            return;
        }
        this.providers.add(provider);
    }

    @Override
    public IFrameModifierProvider[] getProviders() {
        return this.providers.toArray(new IFrameModifierProvider[0]);
    }

    @Override
    public IFrameModifierProvider getModifierProvider(String modifier) {
        for (IFrameModifierProvider p : this.getProviders()) {
            if (!p.getIdentifier().equals(modifier)) continue;
            return p;
        }
        return null;
    }

    @Override
    public ItemStack getFrameStack(int amount, String ... modifiers) {
        ItemStack item = new ItemStack(FramezItems.frame, amount);
        NBTTagCompound tag = item.field_77990_d = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (String s : modifiers) {
            boolean valid = false;
            for (IFrameModifierProvider p : this.providers) {
                if (!p.getIdentifier().equals(s)) continue;
                valid = true;
                break;
            }
            if (!valid) continue;
            list.func_74742_a((NBTBase)new NBTTagString(s));
        }
        tag.func_74782_a("modifiers", (NBTBase)list);
        item.func_77964_b(item.func_77973_b().getDamage(item));
        return item;
    }

    @Override
    public ItemStack getFrameStack(String ... modifiers) {
        return this.getFrameStack(1, modifiers);
    }

    @Override
    public IFrameModifierProvider[] getModifiers(ItemStack item) {
        ArrayList<IFrameModifierProvider> modifiers = new ArrayList<IFrameModifierProvider>();
        if (item.field_77990_d != null) {
            NBTTagCompound tag = item.field_77990_d;
            NBTTagList list = tag.func_150295_c("modifiers", 8);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                modifiers.add(this.getModifierProvider(list.func_150307_f(i)));
            }
        }
        return modifiers.toArray(new IFrameModifierProvider[0]);
    }

    @Override
    public List<ItemStack> getAllPossibleCombinations() {
        if (this.combinations == null) {
            this.combinations = new ArrayList<ItemStack>();
            ArrayList<List> possibilities = new ArrayList<List>();
            for (IFrameModifierProvider p : this.providers) {
                ArrayList<List<IFrameModifierProvider>> pos = new ArrayList<List<IFrameModifierProvider>>();
                pos.add(Arrays.asList(p));
                this.addModifiers(pos, Arrays.asList(p));
                for (List list : pos) {
                    boolean found = false;
                    for (List l2 : possibilities) {
                        Collections.sort(list, new SorterModifierProvider());
                        Collections.sort(l2, new SorterModifierProvider());
                        found = list.equals(l2);
                        if (!found) continue;
                        break;
                    }
                    if (found) continue;
                    possibilities.add(list);
                }
            }
            Collections.sort(possibilities, new SorterElementCount());
            for (List possibility : possibilities) {
                this.combinations.add(this.getFrameStack(this.getIdentifiers(possibility)));
            }
        }
        return this.combinations;
    }

    private void addModifiers(List<List<IFrameModifierProvider>> possibilities, List<IFrameModifierProvider> current) {
        for (IFrameModifierProvider p : this.providers) {
            if (current.contains(p) || !this.areCompatible(current, p)) continue;
            ArrayList<IFrameModifierProvider> l = new ArrayList<IFrameModifierProvider>();
            l.addAll(current);
            l.add(p);
            possibilities.add(l);
            this.addModifiers(possibilities, l);
        }
    }

    private boolean areCompatible(List<IFrameModifierProvider> mods, IFrameModifierProvider m) {
        if (!m.isCompatibleWith(this.getIdentifiers(mods))) {
            return false;
        }
        if (m.overridesBorderTexture()) {
            for (IFrameModifierProvider mod : mods) {
                if (!mod.overridesBorderTexture() || mod.overridePriorityBorder() != m.overridePriorityBorder()) continue;
                return false;
            }
        }
        if (m.overridesCrossTexture()) {
            for (IFrameModifierProvider mod : mods) {
                if (!mod.overridesCrossTexture() || mod.overridePriorityCross() != m.overridePriorityCross()) continue;
                return false;
            }
        }
        return true;
    }

    private String[] getIdentifiers(List<IFrameModifierProvider> modifiers) {
        ArrayList<String> identifiers = new ArrayList<String>();
        for (IFrameModifierProvider p : modifiers) {
            identifiers.add(p.getIdentifier());
        }
        return identifiers.toArray(new String[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getBorderTexture(List<IFrameModifier> modifiers, ForgeDirection face) {
        IIcon icon = null;
        int priority = Integer.MIN_VALUE;
        for (IFrameModifier m : modifiers) {
            if (!m.getProvider().overridesBorderTexture() || m.getProvider().overridePriorityBorder() <= priority) continue;
            icon = m.getBorderTexture(face);
            if (icon == null) {
                icon = IconProvider.iconNothing;
            }
            priority = m.getProvider().overridePriorityBorder();
        }
        return icon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getCrossTexture(List<IFrameModifier> modifiers, ForgeDirection face) {
        IIcon icon = null;
        int priority = Integer.MIN_VALUE;
        for (IFrameModifier m : modifiers) {
            if (!m.getProvider().overridesCrossTexture() || m.getProvider().overridePriorityCross() <= priority) continue;
            icon = m.getCrossTexture(face);
            if (icon == null) {
                icon = IconProvider.iconNothing;
            }
            priority = m.getProvider().overridePriorityCross();
        }
        return icon;
    }
}

