/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.compat.ic2;

import com.amadornes.framez.config.Config;
import com.amadornes.framez.tile.TileMotor;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import java.util.AbstractMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileMotorEU
extends TileMotor
implements IEnergySink {
    private int tick = 0;

    @Override
    public boolean shouldMove() {
        return this.isBeingPowered();
    }

    @Override
    public boolean hasEnoughFramezPower(double power) {
        return this.stored >= power;
    }

    @Override
    public double getMovementSpeed() {
        return 1.0;
    }

    @Override
    public Map.Entry<Double, Double> getExtraInfo() {
        return new AbstractMap.SimpleEntry<Double, Double>(this.maxStored, this.stored);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.tick == 0 && !this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
        }
        ++this.tick;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (!this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.tick = 0;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        }
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return direction != this.getFace();
    }

    public double getDemandedEnergy() {
        return (this.maxStored - this.stored) * Config.PowerRatios.eu;
    }

    public int getSinkTier() {
        return 3;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        double injected = Math.min(this.getDemandedEnergy(), amount);
        this.stored += injected / Config.PowerRatios.eu;
        this.sendUpdatePacket();
        return amount - injected;
    }
}

