/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.compat.hc;

import com.amadornes.framez.config.Config;
import com.amadornes.framez.tile.TileMotor;
import java.util.AbstractMap;
import java.util.Map;
import k4unl.minecraft.Hydraulicraft.api.HydraulicBaseClassSupplier;
import k4unl.minecraft.Hydraulicraft.api.IBaseClass;
import k4unl.minecraft.Hydraulicraft.api.IHydraulicConsumer;
import k4unl.minecraft.Hydraulicraft.api.PressureTier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileMotorHC
extends TileMotor
implements IHydraulicConsumer {
    private IBaseClass c = HydraulicBaseClassSupplier.getBaseClass((TileEntity)this, (PressureTier)PressureTier.HIGHPRESSURE, (int)250);
    private double oldPower = 0.0;

    @Override
    public boolean shouldMove() {
        return this.isBeingPowered();
    }

    @Override
    public boolean hasEnoughFramezPower(double power) {
        return (double)this.c.getPressure(ForgeDirection.UP) >= power;
    }

    @Override
    public double getMovementSpeed() {
        return 1.0;
    }

    @Override
    public void consumeFramezPower(double power) {
        int pow = this.c.getStored() - (int)(power * Config.PowerRatios.hcPressure);
        this.c.setPressure((float)pow, ForgeDirection.UP);
        this.stored = (double)pow / (double)this.c.getMaxStorage() * this.maxStored;
    }

    @Override
    public Map.Entry<Double, Double> getExtraInfo() {
        return new AbstractMap.SimpleEntry<Double, Double>(this.maxStored, this.stored);
    }

    public boolean canConnectTo(ForgeDirection face) {
        return true;
    }

    public IBaseClass getHandler() {
        return this.c;
    }

    public void onFluidLevelChanged(int lvl) {
        this.c.updateFluidOnNextTick();
    }

    public boolean canWork(ForgeDirection face) {
        return false;
    }

    public float workFunction(boolean simulate, ForgeDirection face) {
        return 0.0f;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.c.updateEntityI();
        this.oldPower = this.stored;
        this.stored = (double)this.c.getPressure(ForgeDirection.UP) / (double)this.c.getMaxPressure(true, ForgeDirection.UP) * this.maxStored;
        if (this.stored != this.oldPower) {
            this.sendUpdatePacket();
        }
    }

    @Override
    public void writeUpdatePacket(NBTTagCompound tag) {
        super.writeUpdatePacket(tag);
        this.c.writeToNBTI(tag);
    }

    @Override
    public void readUpdatePacket(NBTTagCompound tag) {
        super.readUpdatePacket(tag);
        this.c.readFromNBTI(tag);
    }
}

