/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez.compat;

import com.amadornes.framez.compat.CompatModule;
import com.amadornes.framez.compat.NoCompatModule;
import com.amadornes.framez.compat.ae2.CompatModuleAE2;
import com.amadornes.framez.compat.bc.CompatModuleBC;
import com.amadornes.framez.compat.bm.CompatModuleBM;
import com.amadornes.framez.compat.cc.CompatModuleCC;
import com.amadornes.framez.compat.da.CompatModuleDA;
import com.amadornes.framez.compat.eio.CompatModuleEIO;
import com.amadornes.framez.compat.fl.CompatModuleFL;
import com.amadornes.framez.compat.hc.CompatModuleHC;
import com.amadornes.framez.compat.ic2.CompatModuleIC2;
import com.amadornes.framez.compat.nei.CompatModuleNEI;
import com.amadornes.framez.compat.oc.CompatModuleOC;
import com.amadornes.framez.compat.pc.CompatModulePC;
import com.amadornes.framez.compat.rc.CompatModuleRC;
import com.amadornes.framez.compat.rf.CompatModuleRF;
import com.amadornes.framez.compat.rf.RFUtils;
import com.amadornes.framez.compat.vanilla.CompatModuleVanilla;
import com.amadornes.framez.compat.waila.CompatModuleWaila;
import com.amadornes.framez.config.Config;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class CompatibilityUtils {
    private static Map<String, CompatModule> modules = new HashMap<String, CompatModule>();

    private CompatibilityUtils() {
    }

    public static void registerModule(String modid, Class<? extends CompatModule> module, Class<? extends CompatModule> alternate) {
        CompatibilityUtils.registerModule(modid, module.getName(), alternate == null ? null : alternate.getName());
    }

    public static void registerModule(String modid, String module, String alternate) {
        if (modid == null || modid.trim().isEmpty()) {
            return;
        }
        if (module == null) {
            return;
        }
        if (modules.containsKey(module)) {
            return;
        }
        if (Loader.isModLoaded((String)modid)) {
            try {
                Class<?> c = Class.forName(module);
                if (!CompatModule.class.isAssignableFrom(c)) {
                    return;
                }
                modules.put(modid, (CompatModule)c.newInstance());
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (alternate == null || alternate.trim().isEmpty()) {
            return;
        }
        try {
            Class<?> c2 = Class.forName(alternate);
            if (!CompatModule.class.isAssignableFrom(c2)) {
                return;
            }
            modules.put(modid, (CompatModule)c2.newInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<CompatModule> getLoadedModules() {
        return Collections.unmodifiableList(new ArrayList<CompatModule>(modules.values()));
    }

    public static CompatModule getModule(String modid) {
        try {
            return modules.get(modid);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void preInit(FMLPreInitializationEvent ev) {
        for (CompatModule m : CompatibilityUtils.getLoadedModules()) {
            m.preInit(ev);
        }
    }

    public static void init(FMLInitializationEvent ev) {
        for (CompatModule m : CompatibilityUtils.getLoadedModules()) {
            m.init(ev);
        }
    }

    public static void postInit(FMLPostInitializationEvent ev) {
        for (CompatModule m : CompatibilityUtils.getLoadedModules()) {
            m.postInit(ev);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenders() {
        for (CompatModule m : CompatibilityUtils.getLoadedModules()) {
            m.registerRenders();
        }
    }

    public static void registerBlocksAndItems() {
        for (CompatModule m : CompatibilityUtils.getLoadedModules()) {
            m.registerBlocks();
            m.registerItems();
        }
    }

    static {
        if (Config.Motors.isRedstoneMotorEnabled) {
            CompatibilityUtils.registerModule(UUID.randomUUID().toString(), NoCompatModule.class, CompatModuleVanilla.class);
        }
        if (Config.Motors.isIC2MotorEnabled) {
            CompatibilityUtils.registerModule("IC2", CompatModuleIC2.class, null);
        }
        if (Config.Motors.isPneumaticCraftMotorEnabled) {
            CompatibilityUtils.registerModule("PneumaticCraft", CompatModulePC.class, null);
        }
        if (Config.Motors.isHydCraftMotorEnabled) {
            CompatibilityUtils.registerModule("HydCraft", CompatModuleHC.class, null);
        }
        if (RFUtils.isRFApiLoaded() && Config.Motors.isRedstoneFluxMotorEnabled) {
            CompatibilityUtils.registerModule(UUID.randomUUID().toString(), NoCompatModule.class, CompatModuleRF.class);
        }
        if (Config.Motors.isBloodMagicMotorEnabled) {
            CompatibilityUtils.registerModule("AWWayofTime", CompatModuleBM.class, null);
        }
        if (Config.Motors.isAEMotorEnabled) {
            CompatibilityUtils.registerModule("appliedenergistics2", CompatModuleAE2.class, null);
        }
        CompatibilityUtils.registerModule("ComputerCraft", CompatModuleCC.class, null);
        CompatibilityUtils.registerModule("NotEnoughItems", CompatModuleNEI.class, null);
        CompatibilityUtils.registerModule("Waila", CompatModuleWaila.class, null);
        CompatibilityUtils.registerModule("OpenComputers", CompatModuleOC.class, null);
        for (ModContainer mod : Loader.instance().getModList()) {
            if (!mod.getModId().equals("BuildCraft|Core")) continue;
            if (!mod.getVersion().equals("0.2") && (!VersionParser.parseRange((String)"[6.1.5,)").containsVersion(mod.getProcessedVersion()) || !ModAPIManager.INSTANCE.hasAPI("BuildCraftAPI|statements"))) break;
            CompatibilityUtils.registerModule("BuildCraft|Core", CompatModuleBC.class, null);
            break;
        }
        CompatibilityUtils.registerModule("EnderIO", CompatModuleEIO.class, null);
        CompatibilityUtils.registerModule("DimensionalAnchors", CompatModuleDA.class, null);
        CompatibilityUtils.registerModule("Railcraft", CompatModuleRC.class, null);
        CompatibilityUtils.registerModule("funkylocomotion", CompatModuleFL.class, null);
    }
}

