/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.framez;

import com.amadornes.framez.api.IMotorProvider;
import com.amadornes.framez.api.IMotorRegistry;
import com.amadornes.framez.api.IRenderMotorSpecial;
import com.amadornes.framez.tile.TileMotor;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class MotorRegistry
implements IMotorRegistry {
    public static final MotorRegistry INST = new MotorRegistry();
    private List<IMotorProvider> providers = new ArrayList<IMotorProvider>();
    private List<IRenderMotorSpecial> renderers;

    private MotorRegistry() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.initClient();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void initClient() {
        this.renderers = new ArrayList<IRenderMotorSpecial>();
    }

    @Override
    public void registerMotor(IMotorProvider provider) {
        if (provider == null) {
            return;
        }
        if (this.providers.contains(provider)) {
            return;
        }
        this.providers.add(provider);
    }

    @Override
    public IMotorProvider[] getRegisteredMotors() {
        return this.providers.toArray(new IMotorProvider[0]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSpecialRenderer(IRenderMotorSpecial renderer) {
        if (renderer == null) {
            return;
        }
        if (this.renderers.contains(renderer)) {
            return;
        }
        this.renderers.add(renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMotorSpecial[] getRenderers(TileMotor tile, ForgeDirection face) {
        ArrayList<IRenderMotorSpecial> l = new ArrayList<IRenderMotorSpecial>();
        for (IRenderMotorSpecial r : this.renderers) {
            if (!r.shouldRender(tile, face)) continue;
            l.add(r);
        }
        IRenderMotorSpecial[] renderers = l.toArray(new IRenderMotorSpecial[0]);
        l.clear();
        return renderers;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMotorSpecial[] getRenderers(ItemStack item, ForgeDirection face) {
        ArrayList<IRenderMotorSpecial> l = new ArrayList<IRenderMotorSpecial>();
        for (IRenderMotorSpecial r : this.renderers) {
            if (!r.shouldRender(item, face)) continue;
            l.add(r);
        }
        IRenderMotorSpecial[] renderers = l.toArray(new IRenderMotorSpecial[0]);
        l.clear();
        return renderers;
    }
}

