/*
 * Decompiled with CFR 0.152.
 */
package neresources.entries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import neresources.api.distributions.DistributionBase;
import neresources.api.messages.RegisterOreMessage;
import neresources.api.utils.DistributionHelpers;
import neresources.api.utils.restrictions.Restriction;
import neresources.config.Settings;
import neresources.utils.MapKeys;
import net.minecraft.item.ItemStack;

public class OreMatchEntry {
    private float[] chances;
    Map<String, Boolean> silkTouchMap = new LinkedHashMap<String, Boolean>();
    List<OreEntry> oreSet = new ArrayList<OreEntry>();
    private int minY;
    private int maxY;
    private int bestY;
    private boolean denseOre;
    private int colour;
    private Restriction restriction;
    List<ItemStack> drops = new ArrayList<ItemStack>();

    public OreMatchEntry(RegisterOreMessage message) {
        this.restriction = message.getRestriction();
        this.addMessage(message);
    }

    private void addMessage(RegisterOreMessage message) {
        this.silkTouchMap.put(MapKeys.key(message.getOre()), message.needSilkTouch());
        this.oreSet.add(new OreEntry(message.getOre(), message.getDistribution()));
        this.calcChances();
        if (this.colour == -16777216) {
            this.colour = message.getColour();
        }
    }

    public boolean add(RegisterOreMessage message) {
        if (!this.restriction.isMergeable(message.getRestriction())) {
            return false;
        }
        this.addMessage(message);
        return message.getRestriction().equals(this.restriction);
    }

    public void add(OreMatchEntry oreMatchEntry) {
        if (this.restriction.isMergeable(oreMatchEntry.restriction)) {
            this.silkTouchMap.putAll(oreMatchEntry.silkTouchMap);
            this.oreSet.addAll(oreMatchEntry.oreSet);
            this.denseOre |= oreMatchEntry.denseOre;
            this.calcChances();
            if (this.colour == -16777216) {
                this.colour = oreMatchEntry.getColour();
            }
        }
    }

    private void calcChances() {
        this.chances = new float[256];
        this.minY = 256;
        this.maxY = 0;
        for (OreEntry entry : this.oreSet) {
            DistributionBase distribution = entry.getDistribution();
            int i = 0;
            for (float chance : distribution.getDistribution()) {
                if (++i == this.chances.length) break;
                int n = i;
                this.chances[n] = this.chances[n] + chance * (this.denseOre && i < 81 ? 1.0976562f : 1.0f);
                if (!(this.chances[i] > 0.0f)) continue;
                if (this.minY > i) {
                    this.minY = i;
                }
                if (i <= this.maxY) continue;
                this.maxY = i;
            }
            this.bestY = distribution.getBestHeight();
        }
        if (this.minY == 256) {
            this.minY = 0;
        }
        if (this.maxY == 0) {
            this.maxY = 255;
        }
        if (this.oreSet.size() > 1) {
            this.bestY = DistributionHelpers.calculateMeanLevel(this.chances, 40, 0, 1000.0f);
        }
    }

    public float[] getChances() {
        return this.getChances(Settings.EXTRA_RANGE);
    }

    public float[] getChances(int extraRange) {
        return Arrays.copyOfRange(this.chances, Math.max(this.minY - extraRange, 0), Math.min(this.maxY + extraRange + 2, 255));
    }

    public int getBestY() {
        return this.bestY;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public boolean isSilkTouchNeeded(ItemStack itemStack) {
        Boolean silkTouch = this.silkTouchMap.get(MapKeys.key(itemStack));
        return silkTouch == null ? false : silkTouch;
    }

    public int getColour() {
        return this.colour;
    }

    public void addDrop(ItemStack nonOre) {
        this.drops.add(nonOre);
        boolean silkTouch = false;
        if (MapKeys.getKey(nonOre).startsWith("denseore")) {
            this.denseOre = true;
            silkTouch = true;
            this.calcChances();
        }
        this.silkTouchMap.put(MapKeys.key(nonOre), silkTouch);
    }

    public void removeDrop(ItemStack removeDrop) {
        Iterator<ItemStack> itr = this.drops.iterator();
        while (itr.hasNext()) {
            ItemStack drop = itr.next();
            if (!drop.func_77969_a(removeDrop)) continue;
            this.silkTouchMap.remove(MapKeys.key(drop));
            itr.remove();
        }
        if (MapKeys.getKey(removeDrop).startsWith("denseore")) {
            this.denseOre = false;
            this.calcChances();
        }
    }

    public List<ItemStack> getDrops() {
        return this.drops;
    }

    public List<ItemStack> getOresAndDrops() {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        for (OreEntry entry : this.oreSet) {
            ItemStack ore = entry.getOre();
            if (list.contains(ore)) continue;
            list.add(ore);
        }
        list.addAll(this.drops);
        return list;
    }

    public List<String> getRestrictions() {
        return this.restriction.getStringList(Settings.useDimNames);
    }

    public String toString() {
        return "Match: " + this.oreSet.get(0).getOre().func_82833_r() + " - " + this.restriction.toString();
    }

    private class OreEntry {
        private ItemStack ore;
        private DistributionBase distribution;

        public OreEntry(ItemStack ore, DistributionBase distribution) {
            this.ore = ore;
            this.distribution = distribution;
        }

        public ItemStack getOre() {
            return this.ore;
        }

        public DistributionBase getDistribution() {
            return this.distribution;
        }
    }
}

