/*
 * Decompiled with CFR 0.152.
 */
package neresources.api.utils;

public class LightLevel {
    public static LightLevel any = new LightLevel(-1, Relative.above);
    public static LightLevel bat = new LightLevel(4);
    public static LightLevel hostile = new LightLevel(8);
    public static LightLevel blaze = new LightLevel(12);
    int lightLevel;
    Relative relative;

    LightLevel(int level, Relative relative) {
        this.lightLevel = level;
        this.relative = relative;
    }

    public static LightLevel decodeLightLevel(String string) {
        int level;
        if (string == null || string == "" || !string.contains(":")) {
            return any;
        }
        String[] splitString = string.split(":");
        if (splitString.length != 2) {
            return any;
        }
        try {
            level = Integer.valueOf(splitString[0]);
        }
        catch (Exception e) {
            return any;
        }
        if (level < 0 || level > 15) {
            return any;
        }
        return new LightLevel(level, splitString[1].equals("a") ? Relative.above : Relative.below);
    }

    public String encode() {
        return this.lightLevel + ":" + (this.relative == Relative.above ? "a" : "b");
    }

    LightLevel(int level, int relative) {
        this.lightLevel = level;
        this.relative = relative > 0 ? Relative.above : Relative.below;
    }

    LightLevel(int level) {
        this(level, Relative.below);
    }

    public String toString() {
        if (this.lightLevel < 0) {
            return "Light level: any";
        }
        return "Light Level: " + this.relative.toString() + " " + this.lightLevel;
    }

    public static enum Relative {
        above("Above"),
        below("Below");

        String text;

        private Relative(String string2) {
            this.text = string2;
        }

        public String toString() {
            return this.text;
        }
    }
}

