/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour.util;

import chbachman.api.item.IModularItem;
import chbachman.api.nbt.helper.NBTHelper;
import chbachman.api.nbt.helper.NBTList;
import chbachman.api.upgrade.IUpgrade;
import chbachman.armour.util.BaublesUtil;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class UpgradeUtil {
    public static boolean doesPlayerHaveUpgrade(EntityPlayer player, IUpgrade upgrade) {
        ItemStack[] armourArray;
        if (Loader.isModLoaded((String)"Baubles")) {
            return BaublesUtil.doesPlayerHaveUpgrade(player, upgrade);
        }
        for (ItemStack armour : armourArray = player.field_71071_by.field_70460_b) {
            if (!UpgradeUtil.doesItemStackContainUpgrade(armour, upgrade)) continue;
            return true;
        }
        return false;
    }

    public static List<ItemStack> getPlayerUpgrades(EntityPlayer player, IUpgrade upgrade) {
        ItemStack[] armourArray;
        if (Loader.isModLoaded((String)"Baubles")) {
            return BaublesUtil.getPlayerUpgrades(player, upgrade);
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(6);
        for (ItemStack armour : armourArray = player.field_71071_by.field_70460_b) {
            if (!UpgradeUtil.doesItemStackContainUpgrade(armour, upgrade)) continue;
            list.add(armour);
        }
        return list;
    }

    public static void removeUpgrade(ItemStack stack, IUpgrade upgrade) {
        if (stack.field_77990_d == null) {
            NBTHelper.createDefaultStackTag(stack);
            return;
        }
        if (stack.func_77973_b() instanceof IModularItem) {
            NBTList<IUpgrade> list = NBTHelper.getNBTUpgradeList(stack.field_77990_d);
            list.remove(upgrade);
        }
    }

    public static List<IUpgrade> getDependencyList(IUpgrade upgrade) {
        ArrayList<IUpgrade> list = new ArrayList<IUpgrade>();
        list.add(upgrade);
        return list;
    }

    public static boolean doesItemStackContainUpgrade(ItemStack stack, IUpgrade upgrade) {
        if (stack == null || upgrade == null) {
            return false;
        }
        NBTHelper.createDefaultStackTag(stack);
        NBTList<IUpgrade> list = NBTHelper.getNBTUpgradeList(stack.field_77990_d);
        return list.contains(upgrade);
    }
}

